/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzVQq;
import com.aspose.words.internal.zzW2r;
import com.aspose.words.internal.zzXvZ;
import com.aspose.words.internal.zzY23;
import com.aspose.words.internal.zzlR;
import com.aspose.words.net.System.Data.DBNull;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataKey;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzD8;
import com.aspose.words.net.System.Data.zzVTQ;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzYwd;
    private Object[] zzYTu;
    private int zzKm = 1;
    private int zzYkx;
    private String zzYaE;
    private Map<String, Object> zzYbt = new HashMap<String, Object>();
    private Map<String, String> zzYYF = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzYwd = table;
        this.zzYTu = new Object[table.getColumns().getCount()];
        Arrays.fill(this.zzYTu, DBNull.Value);
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzD8.zzZa5(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzYwd.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        DataRow dataRow = this;
        return dataRow.getValue(dataRow.zzYwd.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzYwd;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzYwd.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzYwd.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return new DataRow[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        DataTable dataTable = this.zzYwd.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzYwd.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzYwd.getDataSet() == null) {
            return new DataRow[0];
        }
        if (relation.getDataSet() != this.zzYwd.getDataSet()) {
            throw new IllegalStateException("Row not in the DataSet");
        }
        if (relation.getChildKey().getTable() != this.zzYwd) {
            throw new IllegalStateException(zzW2r.zzD8("Table {0} is not the child table in the relation {1}", this.zzYwd.getTableName(), relation.getRelationName()));
        }
        return DataRelation.zzWPL(relation.getParentKey(), relation.getChildKey(), this);
    }

    public void set(int columnIndex, Object value) {
        this.zzW11(columnIndex, value);
        this.zzYwd.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        DataRow dataRow = this;
        dataRow.set(dataRow.zzYwd.getColumns().indexOf(columnName), value);
    }

    public void set(DataColumn column, Object value) {
        this.set(column.getColumnName(), value);
    }

    public int getRowState() {
        return this.zzKm;
    }

    public void setRowState(int state) {
        this.zzKm = state;
    }

    public void delete() {
        zzVTQ.zzD8(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzYbt.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzYbt.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzYTu.length];
        System.arraycopy(this.zzYTu, 0, objectArray, 0, this.zzYTu.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzYTu.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzYTu.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzW11(i, array[i]);
        }
        this.zzYwd.onDataRowChanged(this);
    }

    final int zzQY() {
        return this.zzYkx;
    }

    final void zzZws(String string, String string2) {
        this.zzYYF.put(string, string2);
    }

    final void zzZKs(String string, String string2) {
        this.zzYaE = zzW2r.zzD8(string, string2);
    }

    final String zzWOp() {
        return this.zzYaE;
    }

    final void zzZT(int n) {
        this.zzYkx = n;
    }

    final Object[] zzZAl() {
        return this.zzYTu;
    }

    static boolean zzWPL(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null && dataColumn != DBNull.Value) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzYfD(index)) {
            return null;
        }
        return this.zzYTu[index];
    }

    private void zzW11(int n, Object object) {
        if (!this.zzYfD(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof DBNull ? object : (object instanceof Clob ? DataRow.zzWPL((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzWPL((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzWPL(clazz, object)))));
        this.zzYTu[n] = object2;
    }

    private static Object zzWPL(Class clazz, Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString().trim();
        if (string.isEmpty()) {
            return object;
        }
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zzlR.class) {
                return zzlR.zzWPL(string, zzY23.zzZpD(), 128).zzZL4();
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(string).doubleValue();
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            zzVQq.zzZa5(exception);
        }
        return object;
    }

    private boolean zzYfD(int n) {
        this.zzY0y();
        return this.zzYTu != null && n >= 0 && n < this.zzYTu.length;
    }

    public Object[] getKeyValues(DataKey childKey) {
        if (childKey == null) {
            return null;
        }
        return childKey.getKeyValues(this);
    }

    public void remove(int index) {
        int n = this.zzYwd.getColumns().getCount();
        if (this.zzYTu.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzYTu.length - 1];
        System.arraycopy(this.zzYTu, 0, objectArray, 0, index);
        System.arraycopy(this.zzYTu, index + 1, objectArray, index, this.zzYTu.length - index - 1);
        this.zzYTu = objectArray;
    }

    private void zzY0y() {
        if (this.zzYwd == null || this.zzYwd.getColumns() == null || this.zzYTu == null) {
            return;
        }
        int n = this.zzYwd.getColumns().getCount();
        if (this.zzYTu.length == n) {
            return;
        }
        Object[] objectArray = new Object[this.zzYTu.length];
        System.arraycopy(this.zzYTu, 0, objectArray, 0, this.zzYTu.length);
        this.zzYTu = new Object[n];
        int n2 = Math.min(objectArray.length, this.zzYTu.length);
        System.arraycopy(objectArray, 0, this.zzYTu, 0, n2);
        for (int i = n2; i < this.zzYTu.length; ++i) {
            this.zzYTu[i] = DBNull.Value;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] zzWPL(Blob blob) {
        InputStream inputStream;
        byte[] byArray;
        block11: {
            byArray = null;
            inputStream = null;
            if (blob != null && blob.length() != 0L) break block11;
            return null;
        }
        Object object = new ByteArrayOutputStream();
        inputStream = blob.getBinaryStream();
        zzXvZ.zzWPL(inputStream, (OutputStream)object);
        byArray = ((ByteArrayOutputStream)object).toByteArray();
        if (inputStream == null) return byArray;
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            object = iOException;
            zzVQq.zzZa5(iOException);
        }
        return byArray;
        catch (Exception exception) {
            Exception exception2;
            try {
                exception2 = exception;
                zzVQq.zzZa5(exception);
                if (inputStream == null) return byArray;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzVQq.zzZa5(iOException);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                exception2 = iOException;
                zzVQq.zzZa5(iOException);
            }
            return byArray;
        }
    }

    private static String zzWPL(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzVQq.zzZa5(exception);
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    zzVQq.zzZa5(iOException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzYTu;
        int n = dataRow.zzYTu.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

