/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzVQq;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzD8;
import com.aspose.words.net.System.Data.zzZMM;
import com.aspose.words.net.System.Data.zzZa5;
import com.aspose.words.net.System.Data.zznj;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzWFW;
    private final DataColumnCollection zzYI3;
    private final ConstraintCollection zzXk3;
    private final zzZMM zzWdl;
    private ResultSet zzYEz;
    private String zzXGB;
    private DataSet zzIv;
    private String zzVQi;
    private UniqueConstraint zzZTk;
    private boolean zz3R;
    private final List<DataTableEventListener> zzX61;
    private final Set<DataRow> zzZsa;
    private DataRelationCollection zzXhy;

    public DataTable() {
        this.zzWFW = new DataRowCollection(this);
        this.zzYI3 = new DataColumnCollection(this);
        this.zzXk3 = new ConstraintCollection(this);
        this.zzWdl = new zzZMM(this);
        this.zzVQi = "";
        this.zz3R = true;
        this.zzX61 = new ArrayList<DataTableEventListener>();
        this.zzZsa = new HashSet<DataRow>();
        this.zzXhy = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzWFW = new DataRowCollection(this);
        this.zzYI3 = new DataColumnCollection(this);
        this.zzXk3 = new ConstraintCollection(this);
        this.zzWdl = new zzZMM(this);
        this.zzVQi = "";
        this.zz3R = true;
        this.zzX61 = new ArrayList<DataTableEventListener>();
        this.zzZsa = new HashSet<DataRow>();
        this.zzXhy = new DataRelationCollection();
        this.zzXGB = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzD8.zzWPL(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzWFW = new DataRowCollection(this);
        this.zzYI3 = new DataColumnCollection(this);
        this.zzXk3 = new ConstraintCollection(this);
        this.zzWdl = new zzZMM(this);
        this.zzVQi = "";
        this.zz3R = true;
        this.zzX61 = new ArrayList<DataTableEventListener>();
        this.zzZsa = new HashSet<DataRow>();
        this.zzXhy = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzYEz = resultSet;
        this.zzXGB = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzYEz != null) {
            if (this.zzYEz.getStatement() != null) {
                this.zzYEz.getStatement().getConnection().close();
            }
            this.zzYEz = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzXGB;
    }

    public void setTableName(String tableName) {
        this.zzXGB = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzYI3.getCount();
    }

    public String getColumnName(int index) {
        return this.zzYI3.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzYEz;
    }

    public DataSet getDataSet() {
        return this.zzIv;
    }

    final void zzVTQ(DataSet dataSet) {
        this.zzIv = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzIv.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzXhy.add(dataRelation);
        }
        return this.zzXhy;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzIv.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzWFW;
    }

    public DataColumnCollection getColumns() {
        return this.zzYI3;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXk3;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZTk == null) {
            return new DataColumn[0];
        }
        return this.zzZTk.getColumns();
    }

    final void zzZMM(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZTk != null) {
                this.zzZTk.zzZym(false);
                this.getConstraints().remove(this.zzZTk);
                this.zzZTk = null;
            }
            return;
        }
        if (this.zzZTk != null && DataColumn.areColumnSetsTheSame(value, this.zzZTk.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzWPL(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZTk != null) {
            this.zzZTk.zzZym(false);
            this.getConstraints().remove(this.zzZTk);
            this.zzZTk = null;
        }
        UniqueConstraint.zzWPL(this.getConstraints(), uniqueConstraint);
        this.zzZTk = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzVQi;
    }

    public void setNamespace(String namespace) {
        this.zzVQi = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zz3R;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zz3R = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZsa.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzD8.zzWPL(this.getResultSet(), this);
            zzD8.zzD8(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzVQq.zzVTQ(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzD8.zzFe(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzX61.contains(listener)) {
            this.zzX61.add(listener);
        }
    }

    public void removeEventListener(zzZa5 listener) {
        if (this.zzX61.contains(listener)) {
            this.zzX61.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzX61.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZsa.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzX61) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZsa.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzX61) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZsa.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzX61) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzX61) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzX61) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zznj zzWPL(zzD8[] zzD8Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzD8Array.length];
        for (int i = 0; i < zzD8Array.length; ++i) {
            dataColumnArray[i] = zzD8Array[i].zzZJX();
        }
        DataTable dataTable = this;
        zznj zznj2 = dataTable.zzWdl.zzVTQ(dataColumnArray);
        if (zznj2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zznj2;
    }

    final zzZMM zzYen() {
        return this.zzWdl;
    }

    final Set<DataRow> zz7h() {
        return this.zzZsa;
    }
}

