/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zz5M;
import com.aspose.words.internal.zzDT;
import com.aspose.words.internal.zzVXu;
import com.aspose.words.internal.zzWQS;
import com.aspose.words.internal.zzWS;
import com.aspose.words.internal.zzWdc;
import com.aspose.words.internal.zzX9X;
import com.aspose.words.internal.zzXPF;
import com.aspose.words.internal.zzXdv;
import com.aspose.words.internal.zzXl7;
import com.aspose.words.internal.zzXn5;
import com.aspose.words.internal.zzY8e;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.internal.zzYjh;
import com.aspose.words.internal.zzYsB;
import com.aspose.words.internal.zzZJZ;
import com.aspose.words.internal.zzZsI;
import com.aspose.words.internal.zzy;
import com.aspose.words.zz5u;
import com.aspose.words.zzPn;
import com.aspose.words.zzVVd;
import com.aspose.words.zzVW0;
import com.aspose.words.zzVZZ;
import com.aspose.words.zzW4l;
import com.aspose.words.zzW5d;
import com.aspose.words.zzWBB;
import com.aspose.words.zzWCS;
import com.aspose.words.zzWXJ;
import com.aspose.words.zzWYy;
import com.aspose.words.zzWbY;
import com.aspose.words.zzWcP;
import com.aspose.words.zzWdR;
import com.aspose.words.zzWeM;
import com.aspose.words.zzWwY;
import com.aspose.words.zzWxU;
import com.aspose.words.zzX2x;
import com.aspose.words.zzX3o;
import com.aspose.words.zzX7L;
import com.aspose.words.zzXAU;
import com.aspose.words.zzXC1;
import com.aspose.words.zzXlQ;
import com.aspose.words.zzXyv;
import com.aspose.words.zzY2Y;
import com.aspose.words.zzY8L;
import com.aspose.words.zzYC9;
import com.aspose.words.zzYEh;
import com.aspose.words.zzYHy;
import com.aspose.words.zzYI7;
import com.aspose.words.zzYMK;
import com.aspose.words.zzYOw;
import com.aspose.words.zzYQb;
import com.aspose.words.zzYXY;
import com.aspose.words.zzYjc;
import com.aspose.words.zzZ4k;
import com.aspose.words.zzZ5u;
import com.aspose.words.zzZ6B;
import com.aspose.words.zzZ6i;
import com.aspose.words.zzZFf;
import com.aspose.words.zzZGL;
import com.aspose.words.zzZZS;
import com.aspose.words.zzZoc;
import com.aspose.words.zzZuO;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zz5u,
zzWYy,
zzWeM,
zzXlQ {
    private Document zzX2Q;
    private Node zzVWy;
    private Node zzpZ;
    private zzWXJ zzWGm;
    private Font zzvD;
    private zzXPF<zzWXJ> zzW7M;
    private zzXPF<zzWCS> zzYAa;
    private zzXPF<zzXK2> zzZod;
    private zzYI7 zzuh = zzYI7.zzOu();
    private zzPn zzYql = new zzPn();
    private zzWCS zzZxI;
    private RowFormat zzXFM;
    private CellFormat zzXh3;
    private ParagraphFormat zzZgb;
    private zzXPF<zzVVd> zzXTW;
    private int zzZPv = 0;
    private int zz60 = -1;
    private int zzB6;
    private boolean zzXZU;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzYbj(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzYbj(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzYbj(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXK2(documentBuilder.getCurrentSection(), zzXC1.zzXlC(headerFooterType), 0, 0);
    }

    private void zzYbj(int n, int n2, int n3, int n4) {
        this.zzX2Q.ensureMinimum();
        Section section = (Section)this.zzX2Q.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXK2(section, 1, n3, n4);
    }

    private void zzXK2(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzXC1.zzXNG(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzX2Q, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzX2Q));
            }
        }
        this.zzXK2(story, n2, n3);
    }

    private void zzXK2(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXK2((CompositeNode)paragraph2, n3);
    }

    final void zzXK2(Paragraph paragraph, int n) {
        this.zzXK2((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzXfu().zzXEG() ? zzYC9.zzR3(this.zzX2Q, fieldName) : zzYC9.zzX6T(this.zzXfu(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXK2(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXK2(field, isAfter, false);
    }

    private boolean zzXK2(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZoc zzZoc2 = field.getFormat().zzWzU();
        Inline inline = zzZoc2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXK2(inline.zzYBa(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzYXY.zzXK2(this.zzX2Q, bookmarkName) : zzYXY.zzWS3(this.zzX2Q, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzMa() == 6) {
            this.zzXK2(node.zzZqg(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzYOw.zzZu(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzXK2((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXK2(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzWS3(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzXK2(structuredDocumentTag);
            return;
        }
        this.zzYKF(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzXQe(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzXK2((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzMa() == 6) {
            this.zz6a(node);
        } else {
            Node node2 = node;
            if (zzYOw.zzvp(node2.getNodeType())) {
                Paragraph paragraph = zzYOw.zzZu(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zz6a(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzMa() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zz6a(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzB6 = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzWBV();
            return;
        }
        if (!this.zzYjs()) {
            this.zzWBV();
        }
    }

    private void zzXK2(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzYjs() {
        Node node = this.zzXfu();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzXfu().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXK2(((StructuredDocumentTag)documentBuilder.zzXfu().getParentNode()).zzWsA(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzXfu(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXK2(inline.zzYBa(), true);
            return true;
        }
        return false;
    }

    private void zzWBV() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXK2(documentBuilder.getCurrentParagraph().zzYFz(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzXQe(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz6s() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzXfu().zzZq3(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzWo7();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzXK2((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzZ6B(text, false);
    }

    public void writeln(String text) {
        this.zzZ6B(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzXfu() != null && this.zzXfu().zzMa() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzXfu().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzdF();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzWxU zzWxU2 = new zzWxU(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzX2Q, this.zzXgU(), this.zzVWp());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().zzJO(paragraph);
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzWS3(this.zzXfu(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzWxU2.dispose();
        }
        if (this.getDocument().zzZKF()) {
            zzYOw.zzYKF((zzX7L)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzEl());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzYsq() {
        zzWXJ zzWXJ2;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzdF();
        Node node = this.zzXfu();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzbx(false);
        } else {
            run2 = run = (Run)node.zzYq5(21);
        }
        if (run2 == null && zzYb0.zzXFC(node, paragraph.zzYzF())) {
            run = paragraph.zzYzF();
        }
        if (run != null) {
            cloneable = run.zzYBa();
            zzWXJ2 = (zzWXJ)((zzY8L)cloneable).zzYFg();
        } else {
            cloneable = paragraph.zzYFz();
            zzWXJ2 = (zzWXJ)((zzY8L)cloneable).zzYFg();
        }
        zzWXJ zzWXJ3 = zzWXJ2;
        Paragraph paragraph2 = new Paragraph(this.zzX2Q, this.zzXgU(), zzWXJ3);
        paragraph.zzWDP(paragraph2);
        zzWxU zzWxU2 = new zzWxU(this.zzX2Q);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzWS3(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzWxU2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzY2Y.zzR3(this);
    }

    public void insertBreak(int breakType) {
        this.zzWls(breakType, true);
    }

    final void zzWls(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzWqK(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzX8h(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzXkC())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzWqK(bl)) {
                        this.zzX8h(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzWqK(bl)) {
                        this.zzXrq(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzWqK(bl)) {
                        this.zzXrq(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzWqK(bl)) {
                        this.zzXrq(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzWqK(bl)) {
                        this.zzXrq(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzWqK(bl)) {
                        this.zzXrq(4);
                    }
                    return;
                }
                case 8: {
                    this.zzX8h(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zz5M.zzYXr(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzY8e.zzWS3("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzdF();
        return zzYOw.zzXK2(fieldType, updateField, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzdF();
        return zzYOw.zzXK2(fieldCode, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzdF();
        return zzYOw.zzXK2(fieldCode, fieldValue, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzYb0.zzWS3((Object)displayText, "displayText");
        zzYb0.zzWS3((Object)urlOrBookmark, "hrefOrBookmark");
        zzWBB zzWBB2 = this.zzWS3(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzWBB2.zzYKF(documentBuilder.zzWLw(88, true));
        return zzYOw.zzXK2(zzWBB2.getStart(), zzWBB2.getSeparator(), zzWBB2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZjy(70);
        if (zz5M.zzYXr(name)) {
            this.startBookmark(name);
        }
        this.zzTX(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzXUk(70);
        String string = zz5M.zzYXr(fieldValue) ? fieldValue : FormField.zzXPH;
        Run run = new Run(this.zzX2Q, string, this.zzVWp());
        this.insertNode(run);
        Node node = this.zzWLw(70, true);
        if (zz5M.zzYXr(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzXf1(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzXK2((CompositeNode)((Paragraph)node.zzZqg()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZjy(71);
        if (zz5M.zzYXr(name)) {
            this.startBookmark(name);
        }
        this.zzTX(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzWLw(71, false);
        if (zz5M.zzYXr(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXf1(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZjy(83);
        if (zz5M.zzYXr(name)) {
            this.startBookmark(name);
        }
        this.zzTX(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzWLw(83, false);
        if (zz5M.zzYXr(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXf1(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzX2Q, footnoteType, !zz5M.zzYXr(referenceMark), referenceMark, this.zzVWp());
        Style style = this.getDocument().getStyles().zzZJO(zzYOw.zzZ2r(footnoteType));
        footnote.zzYBa().set(50, style.zzZRm());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzX2Q);
        Style style2 = this.getDocument().getStyles().zzZJO(zzYOw.zzWEO(footnoteType));
        paragraph.zzpe().set(1000, style2.zzZRm());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzX2Q, '\u0002', new zzWXJ()) : new Run(this.zzX2Q, footnote.getReferenceMark(), new zzWXJ());
        inline.zzYBa().set(50, style.zzZRm());
        paragraph.appendChild(inline);
        if (zz5M.zzYXr(footnoteText)) {
            Node node = this.zzXfu();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zz6a(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzYCk(zzDT zzDT2) throws Exception {
        return this.zzXK2(zzDT2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzYCk(zzDT.zzWS3(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXK2(zzDT zzDT2, double d, double d2) throws Exception {
        return this.zzXK2(zzDT2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXK2(zzDT.zzWS3(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        zzXl7 zzXl72 = new zzXl7();
        try {
            zzXdv.zzWS3(image, zzXl72);
            Shape shape = this.zzXK2(zzXl72, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzXl72.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzYb0.zzYKF(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzVXu.zzW5f(fileName);
        try {
            Shape shape = this.zzXK2((zzDT)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzDT)object).close();
            }
        }
    }

    private Shape zzXK2(zzDT zzDT2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzDT2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzYb0.zzR3(zzDT2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXK2(zzDT.zzWS3(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXK2(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzXK2(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzWQS.zzZRP(object)) {
            object4 = new zzXdv((byte[])object);
            bl2 = true;
            ((zzWdc)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzX2Q.getCompatibilityOptions().getMswVersion() > 12 || this.zzX2Q.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzX2Q, 0);
            object3 = new zzX3o();
            ((zzZZS)object3).zzXK2(zzXAU.zzXHp("rect"));
            ((zzX3o)object3).zzXK2(new zzWbY());
            ((zzX3o)object3).zzGX().zzZqj().zzYKF(this.zzX2Q);
            object2 = new zzZ4k();
            ((zzZGL)object2).zzWS3(new zzYQb(this.zzX2Q.zzXPS(), ""));
            ((zzZGL)object2).zzXK2(new zzZ6i());
            ((zzWwY)object3).zzXK2((zzZGL)object2);
            shape.setShapeType(75);
            shape.zzVWC((zzWwY)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzX2Q, 75);
        }
        if (zzWQS.zzZXc(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzXK2((byte[])object, new zzW4l(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzW4l(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzWQS.zzXAV((byte[])object2));
                this.zzXK2((zzX3o)shape.zzY1e(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzX3o)shape.zzY1e()).zzGX().zzZqj().zzYqS((byte[])object);
            object3 = zzWQS.zzWgJ(object);
            object4 = new zzW4l(((zzX9X)object3).getWidthPoints(), ((zzX9X)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzWS3(this.zzVWp());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzWQS.zz5B(object)) {
            d5 = DocumentBuilder.zzXK2(shape, object);
        }
        shape.zzXK2(d3, d4, (zzW4l)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzXK2(Shape shape, byte[] byArray) throws Exception {
        int n = zzWQS.zzZV(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzYOw.zzXJO(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzYOw.zzZKt(n);
        return d;
    }

    private void zzXK2(zzX3o zzX3o2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzX3o2.zzGX().zzZqj().getExtensions();
        zzXl7 zzXl72 = new zzXl7(byArray);
        try {
            object = zzYOw.zzXK2(zzXl72, this.zzX2Q);
            ((zzW5d)object).zzWoY(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzW5d)object).zznh();
            byArray2 = ((zzW5d)object).zzXoy(true);
        }
        finally {
            zzXl72.close();
        }
        zzX3o2.zzGX().zzZqj().setExtensions(new zzWS<zzVW0>());
        object = zzVW0.zzXK2(byArray2, this.zzX2Q);
        zzX3o2.zzGX().zzZqj().getExtensions().zzYtJ(((zzVW0)object).getUri(), (zzVW0)object);
    }

    private Shape zzXK2(zzDT zzDT2, String string, boolean bl, zzDT zzDT3) throws Exception {
        zzWdR zzWdR2 = zzWdR.zzXag(string);
        Shape shape = this.zzXK2(zzDT3, bl, zzWdR2, null);
        zzXyv zzXyv2 = zzZ5u.zzXK2(zzDT2, string, bl);
        return DocumentBuilder.zzXK2(null, false, shape, zzWdR2.zzWJK, zzXyv2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXK2(zzDT.zzWS3(stream), progId, asIcon, zzDT.zzWS3(presentation));
    }

    private Shape zzXK2(String string, boolean bl, boolean bl2, zzDT zzDT2) throws Exception {
        zzWdR zzWdR2 = zzWdR.zzXqe(zzXn5.zzZi0(string));
        return this.zzXK2(string, bl, bl2, zzDT2, zzWdR2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXK2(fileName, isLinked, asIcon, zzDT.zzWS3(presentation));
    }

    private Shape zzXK2(String string, String string2, boolean bl, boolean bl2, zzDT zzDT2) throws Exception {
        zzWdR zzWdR2 = zzWdR.zzXag(string2);
        return this.zzXK2(string, bl, bl2, zzDT2, zzWdR2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzXK2(fileName, progId, isLinked, asIcon, zzDT.zzWS3(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWdR zzWdR2 = zzWdR.zzXqe(zzXn5.zzZi0(fileName));
        return this.zzXK2(fileName, isLinked, iconFile, iconCaption, zzWdR2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzWdR zzWdR2 = zzWdR.zzXag(progId);
        return this.zzXK2(fileName, isLinked, iconFile, iconCaption, zzWdR2);
    }

    private Shape zzWS3(zzDT zzDT2, String string, String string2, String string3) throws Exception {
        zzWdR zzWdR2 = zzWdR.zzXag(string);
        Shape shape = this.zzXK2(string2, string3, zzWdR2);
        zzXyv zzXyv2 = zzZ5u.zzXK2(zzDT2, string, true);
        return DocumentBuilder.zzXK2(null, false, shape, zzWdR2.zzWJK, zzXyv2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWS3(zzDT.zzWS3(stream), progId, iconFile, iconCaption);
    }

    final Shape zzXK2(zzYjc zzYjc2, zzDT zzDT2) throws Exception {
        Shape shape = this.zzZMT(zzDT2);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzYjc2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzdF();
        if (this.zzWnV()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzXOq(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZuO zzZuO2 = zzYOw.zzXK2(html, options, this);
        zzZuO2.zzZGL();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzdF();
        return zzYOw.zzXK2(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzdF();
        return zzYOw.zzXK2(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzYHy zzYHy2 = new zzYHy();
        return zzYHy2.zzXK2(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYMK(this).zzXK2(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYMK(this).zzXK2(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzX2Q, 75);
        shape.zzWS3(this.zzVWp());
        shape.zzXaV(true);
        shape.getSignatureLine().zzXK2(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYMT(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzYyO(this.zzX2Q);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzWnV() {
        boolean bl = false;
        if (this.zzXfu().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzXfu().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXOq(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzdF();
        if (this.zz6s() == null) {
            this.startTable();
        }
        if (this.zz6s().zzYca() == 1) {
            this.zz6s().zzYi0();
        }
        if (this.zz6s().zzYca() == 3) {
            this.zz6s().zzWC6();
        }
        return this.zz6s().zzWN3();
    }

    public Table startTable() {
        this.zzXTW.push(new zzVVd(this));
        return this.zz6s().startTable();
    }

    public Table endTable() {
        if (this.zz6s() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz6s().endTable();
        this.zzXTW.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz6s() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz6s().endRow();
        if (this.zzvD != null && this.zzvD.getHidden()) {
            row.zzZEi().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzX2Q, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzX2Q, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWJa();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzX2Q, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzYLe();
        bookmarkStart.zzZjW(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzWJa();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzYLe();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzX2Q, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzUz(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzX2Q);
        this.zz60 = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zz60 == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzX2Q, this.zz60);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzX2Q, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzYb0.zzWS3((Object)importFormatOptions, "ImportFormatOptions");
        this.zzdF();
        return zzZFf.zzXK2(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzYb0.zzWS3((Object)importFormatOptions, "ImportFormatOptions");
        this.zzdF();
        importFormatOptions.zzW67(true);
        Node node = zzZFf.zzXK2(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzW67(false);
        return node;
    }

    public Document getDocument() {
        return this.zzX2Q;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzX2Q) {
            return;
        }
        this.zzX2Q = value;
        this.zz6a(null);
        this.zzWGm = new zzWXJ();
        this.zzW7M = null;
        this.zzYAa = null;
        this.zzvD = null;
        this.zzXTW = new zzXPF();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzvD == null) {
            DocumentBuilder documentBuilder = this;
            this.zzvD = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzvD;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZgb == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZgb = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzZgb;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzXFM == null) {
            this.zzXFM = new RowFormat(this);
        }
        return this.zzXFM;
    }

    public CellFormat getCellFormat() {
        if (this.zzXh3 == null) {
            this.zzXh3 = new CellFormat(this);
        }
        return this.zzXh3;
    }

    final void zzXZ1(Node node) {
        this.getCurrentParagraph().zzWDP(node);
    }

    public void pushFont() {
        zzWXJ zzWXJ2;
        if (this.getCurrentParagraph() != null) {
            zzWXJ zzWXJ3 = this.getCurrentParagraph().zzYFz();
            zzWXJ2 = (zzWXJ)zzWXJ3.zzYFg();
        } else {
            zzWXJ2 = this.zzVWp();
        }
        zzWXJ zzWXJ4 = zzWXJ2;
        this.zzZbu().push(new zzXK2(this.zzVWp(), zzWXJ4));
    }

    public void popFont() {
        zzXPF<zzXK2> zzXPF2 = this.zzZbu();
        if (zzXPF2.size() > 0) {
            zzXK2 zzXK22 = (zzXK2)this.zzZbu().pop();
            this.zzXK2(zzXK22.zzYBa(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXZ1(zzXK22.zzYEK());
            }
        }
    }

    final void zzZ8w() {
        this.zzZhh().push(this.zzVWp());
    }

    final void zzXLX() {
        zzXPF<zzWXJ> zzXPF2 = this.zzZhh();
        if (zzXPF2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXK2((zzWXJ)documentBuilder.zzZhh().pop(), false);
        }
    }

    final void zz5b() {
        this.zzY9l().push(this.zzXgU());
    }

    final void zzXky() {
        zzXPF<zzWCS> zzXPF2 = this.zzY9l();
        if (zzXPF2.size() > 0) {
            zzWCS zzWCS2 = (zzWCS)this.zzY9l().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXK2(zzWCS2);
            }
        }
    }

    private zzWBB zzWS3(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZjy(88);
        zzWcP zzWcP2 = new zzWcP();
        zzWcP2.setTarget(string2);
        zzWcP2.setScreenTip(string3);
        if (bl) {
            zzWcP2.setSubAddress(string);
        } else {
            zzWcP2.setAddress(zzZsI.zzWQo(string));
            zzWcP2.setSubAddress(zzZsI.zzYrf(string));
        }
        this.zzTX(zzWcP2.zzxy());
        FieldSeparator fieldSeparator = this.zzXUk(88);
        return new zzWBB(fieldStart, fieldSeparator, null);
    }

    final zzWBB zzYbj(String string, String string2, String string3) {
        boolean bl = zzZsI.zzWXs(string);
        String string4 = bl ? zzZsI.zzYrf(string) : string;
        return this.zzWS3(string4, bl, string2, string3);
    }

    final zzWBB zzXK2(zzWcP zzWcP2) {
        FieldStart fieldStart = this.zzZjy(88);
        this.zzTX(zzWcP2.zzxy());
        FieldSeparator fieldSeparator = this.zzXUk(88);
        return new zzWBB(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzZj1() {
        return this.zzWLw(88, true);
    }

    final zzWXJ zzVWp() {
        zzWXJ zzWXJ2 = this.zzWGm;
        return (zzWXJ)zzWXJ2.zzYFg();
    }

    final zzWCS zzXgU() {
        zzWCS zzWCS2 = this.zzpe();
        return (zzWCS)zzWCS2.zzYFg();
    }

    final zzYI7 zzYds() {
        zzYI7 zzYI72 = this.zzZEi();
        return (zzYI7)zzYI72.zzYFg();
    }

    final zzPn zzYcH() {
        zzPn zzPn2 = this.zzZ3o();
        return (zzPn)zzPn2.zzYFg();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzXfu(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzXfu().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzXZU && this.zzXfu().getNodeType() == 28;
    }

    private void zzZ6B(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzXfu()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzXC1.zzbV(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzPt(string2.substring(n4, n4 + n2));
                }
                switch (this.zzZPv) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzX8h(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzPt(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzdF();
        if (this.zz6s() != null && this.zz6s().zzYca() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzXfu().zzWDP(node);
    }

    final void zzX8W(int n) {
        this.zzWqK(true);
        this.zzXrq(n);
    }

    private void zzXrq(int n) {
        this.insertParagraph();
        zzWxU zzWxU2 = new zzWxU(this.getDocument());
        try {
            zzVZZ zzVZZ2 = this.getCurrentSection().zzZ0Y();
            zzVZZ zzVZZ3 = (zzVZZ)zzVZZ2.zzYFg();
            Section section = new Section(this.zzX2Q, zzVZZ3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzX2Q));
            this.zzX2Q.insertAfter(section, this.getCurrentSection());
            section.getBody().zzWS3(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzWxU2.dispose();
        }
    }

    final FieldStart zzZjy(int n) {
        this.zzdF();
        return zzYOw.zzXK2(n, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    final Run zzTX(String string) {
        return zzYOw.zzWS3(string, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    final FieldEnd zzWLw(int n, boolean bl) {
        return zzYOw.zzWS3(n, bl, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    final FieldSeparator zzXUk(int n) {
        return zzYOw.zzWS3(n, this.zzVWp(), this.zzWXM(), this.zzZoP(), this.zzZoP() == null);
    }

    private FormField zzXf1(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzX2Q, new zzX2x(), this.zzVWp());
        CompositeNode compositeNode = node == null ? this.zzWXM() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzWqK(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz6s() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzXQe(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzPt(String string) {
        if (this.zzZWa(string)) {
            zzZJZ zzZJZ2 = new zzZJZ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYjh zzYjh2 : zzZJZ2.zzWxv(this.getParagraphFormat().getBidi())) {
                zzZ6B zzZ6B2 = zzZ6B.zzYV(zzYjh2.zzWSX());
                zzWXJ zzWXJ2 = this.zzVWp();
                zzWXJ2.zzYU(265, zzZ6B2);
                if (zzYjh2.zzXhs()) {
                    zzWXJ2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzX2Q, zzYjh2.getText(), zzWXJ2);
                this.insertNode(run);
            }
            return;
        }
        this.zzX8h(string);
    }

    private boolean zzZWa(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzy.zz2T(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXK2(zzWXJ zzWXJ2, boolean bl) {
        zzWXJ zzWXJ3;
        if (bl) {
            zzWXJ zzWXJ4 = zzWXJ2;
            zzWXJ3 = (zzWXJ)zzWXJ4.zzYFg();
        } else {
            zzWXJ3 = zzWXJ2;
        }
        this.zzWGm = zzWXJ3;
    }

    final void zz1e() {
        this.zzWGm.clear();
    }

    final void zzX9w() {
        if (this.zzWJa() != null) {
            zzPn zzPn2;
            zzPn zzPn3 = zzPn2 = this.zzWJa().zzZ3o();
            this.zzYql = (zzPn)zzPn3.zzYFg();
            zzPn2.zzWS3(this.zzYql);
        }
    }

    private Shape zzXK2(String string, boolean bl, boolean bl2, zzDT zzDT2, zzWdR zzWdR2) throws Exception {
        if (zzWdR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzXK2(zzDT2, bl2, zzWdR2, string);
        zzXyv zzXyv2 = zzZ5u.zzXK2(string, bl, bl2, zzWdR2);
        return DocumentBuilder.zzXK2(string, bl, shape, zzWdR2.zzWJK, zzXyv2);
    }

    private Shape zzXK2(String string, boolean bl, String string2, String string3, zzWdR zzWdR2) throws Exception {
        if (zzWdR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzXn5.zzX0F(string);
        }
        Shape shape = string2 != null ? this.zzVRC(string2, string3) : this.zzXK2(null, string3, zzWdR2);
        zzXyv zzXyv2 = zzZ5u.zzXK2(string, bl, true, zzWdR2);
        return DocumentBuilder.zzXK2(string, bl, shape, zzWdR2.zzWJK, zzXyv2);
    }

    private static Shape zzXK2(String string, boolean bl, Shape shape, String string2, zzXyv zzXyv2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzWS3(zzXyv2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzXK2(zzDT zzDT2, boolean bl, zzWdR zzWdR2, String string) throws Exception {
        if (zzWdR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzDT2 != null) {
            return this.zzZMT(zzDT2);
        }
        if (!bl) {
            return this.zzYV(zzZ5u.zzYOM().get("normal"));
        }
        String string2 = string != null ? zzXn5.zzX0F(string) : zzZ5u.zz7(zzWdR2.zzWjl);
        return this.zzXK2(zzWdR2, string2);
    }

    private Shape zzXK2(String string, String string2, zzWdR zzWdR2) throws Exception {
        if (zzWdR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zzZ5u.zz7(zzWdR2.zzWjl);
        }
        if (string != null) {
            return this.zzVRC(string, string2);
        }
        return this.zzXK2(zzWdR2, string2);
    }

    private Shape zzXK2(zzWdR zzWdR2, String string) throws Exception {
        if (zzWdR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zzZ5u.zzGo(zzWdR2.zzWjl);
        zzYsB zzYsB2 = new zzYsB(byArray, null, string, this.getDocument().zzVUf());
        return this.zzYV(zzYsB2.zzZml());
    }

    private Shape zzVRC(String string, String string2) throws Exception {
        zzYsB zzYsB2 = new zzYsB(string, string2, this.getDocument().zzVUf());
        return this.zzYV(zzYsB2.zzZml());
    }

    private Shape zzZMT(zzDT zzDT2) throws Exception {
        byte[] byArray = zzYb0.zzR3(zzDT2);
        return this.zzYV(byArray);
    }

    private Shape zzYV(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzX2Q, 1);
        shape.setShapeType(75);
        shape.zzWS3(this.zzVWp());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzYMT(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzXK2(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzWS3(compositeNode, n);
            return;
        }
        this.zzYKF(compositeNode, n);
    }

    private void zzWS3(CompositeNode compositeNode, int n) {
        zzYEh zzYEh2 = zzYEh.zzZ6B(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzYEh2.zzXK2(null, true, true, true, false, true);
            node = zzYEh2.getNode();
            if (zzYEh2.zzXnQ() && (!node.isComposite() || node.zzMa() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzZ7I().length() : node.getTextLength();
            if (!zzYEh2.zzXnQ() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzYEh2.zzXnQ() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzXK2((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzXK2(null, node);
            this.zzB6 = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzXK2(StructuredDocumentTag structuredDocumentTag) {
        this.zz6a(structuredDocumentTag);
        this.zzXZU = true;
        this.zzB6 = 0;
        zzWXJ zzWXJ2 = structuredDocumentTag.zzWsA();
        switch (structuredDocumentTag.zzMa()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzYeQ(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzWXJ2 = ((Inline)node).zzYBa();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzWXJ2 = paragraph.zzYFz();
                break;
            }
            default: {
                return;
            }
        }
        this.zzXK2(zzWXJ2, true);
    }

    private void zzYKF(CompositeNode compositeNode, int n) {
        zzYEh zzYEh2 = zzYEh.zzkI(compositeNode);
        while (zzYEh2.getNode() != compositeNode || !zzYEh2.zzXnQ()) {
            int n2;
            Node node = zzYEh2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZ7I().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzXK2(null, node);
                this.zzB6 = n;
                return;
            }
            while (zzYEh2.zzXK2(null, false, true, true, false, true) && zzYEh2.zzXnQ() && zzYEh2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzdF() {
        int n = this.zzB6;
        if (n == 0) {
            return;
        }
        this.zzB6 = 0;
        Run run = zzYb0.zzXK2((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzOP(n);
        }
    }

    private Run zzX8h(String string) {
        Run run = new Run(this.zzX2Q, string, this.zzVWp());
        this.insertNode(run);
        return run;
    }

    final boolean zzZdS() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzW5M() {
        return this.zzZPv;
    }

    final void zz5r(int n) {
        this.zzZPv = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXfu();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzXfu();
        }
        return (Paragraph)this.zzXfu().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzXfu();
        }
        return (StructuredDocumentTag)this.zzXfu().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzXfu().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzVVd zz6s() {
        zzXPF<zzVVd> zzXPF2 = this.zzXTW;
        if (zzXPF2.size() > 0) {
            return (zzVVd)this.zzXTW.peek();
        }
        return null;
    }

    private Cell zzWJa() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZoJ();
    }

    private CompositeNode zzWXM() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzXfu();
        }
        return this.zzXfu().getParentNode();
    }

    private Node zzZoP() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzXfu();
    }

    private zzXPF<zzWXJ> zzZhh() {
        if (this.zzW7M == null) {
            this.zzW7M = new zzXPF();
        }
        return this.zzW7M;
    }

    private zzXPF<zzWCS> zzY9l() {
        if (this.zzYAa == null) {
            this.zzYAa = new zzXPF();
        }
        return this.zzYAa;
    }

    private zzXPF<zzXK2> zzZbu() {
        if (this.zzZod == null) {
            this.zzZod = new zzXPF();
        }
        return this.zzZod;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWGm.zzZf3(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzWGm.zzX4F(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZAt(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZAt(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWGm.zzYU(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWxw()) {
            this.getCurrentParagraph().zzYFz().zzYU(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWGm.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWGm.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWxw()) {
            this.getCurrentParagraph().zzYFz().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzpe().zzZf3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzpe().zzX4F(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzWVx(key, 0);
        }
        return this.getDocument().getStyles().zzWsp().zzgw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzpe().zzYU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzpe().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzpe().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZEi().zzZf3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzZEi().zzgw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZEi().zzVYl(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZEi().zzYU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZEi().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzZEi().clear();
        zzYI7.zzOu().zzWS3(this.zzZEi());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZ3o().zzZf3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzZ3o().zzgw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzZ3o().zzVYl(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzYb0.zzXK2(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzWJa() != null ? this.zzWJa().getCellFormat() : this.getCellFormat();
            border.zzXK2(cellFormat);
        }
        this.zzZ3o().zzYU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZ3o().clear();
    }

    private Node zzXfu() {
        Node node = this.zzVWy != null && this.zzVWy.getParentNode() == null ? this.zzpZ : this.zzVWy;
        if (node != null && node.zzMa() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzXZU = this.zzXZU && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zz6a(Node node) {
        this.zzVWy = node;
        if (this.zzVWy != null) {
            this.zzpZ = this.zzVWy.getParentNode();
        }
        this.zzXZU = false;
    }

    private zzWCS zzpe() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzpe();
        }
        if (this.zzZxI == null) {
            this.zzZxI = new zzWCS();
        }
        return this.zzZxI;
    }

    private zzYI7 zzZEi() {
        if (this.zz6s() != null && this.zz6s().zzYca() == 1) {
            return this.zzuh;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzZEi();
        }
        return this.zzuh;
    }

    private zzPn zzZ3o() {
        if (this.zz6s() != null && this.zz6s().zzYca() != 3) {
            return this.zzYql;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZoJ().zzZ3o();
        }
        return this.zzYql;
    }

    static final class zzXK2 {
        private zzWXJ zzWGm;
        private zzWXJ zz6D;

        public zzXK2(zzWXJ zzWXJ2, zzWXJ zzWXJ3) {
            this.zzWGm = zzWXJ2;
            this.zz6D = zzWXJ3;
        }

        public final zzWXJ zzYBa() {
            return this.zzWGm;
        }

        public final zzWXJ zzYEK() {
            return this.zz6D;
        }
    }
}

