/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zz5M;
import com.aspose.words.internal.zz5Y;
import com.aspose.words.internal.zz9j;
import com.aspose.words.internal.zzDT;
import com.aspose.words.internal.zzVXf;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXiG;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzW0r = new HashMap();
    private static HashMap<Integer, Integer> zzYfg = new HashMap();
    private static HashMap<Integer, Integer> zzVWa = new HashMap();
    private static HashMap<Integer, Integer> zzZbq = new HashMap();
    private static HashMap<Integer, Integer> zzWAa = new HashMap();
    private static HashMap<Integer, Integer> zzZmb = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzYb0.zzYKF(fileName, "fileName");
        zzVXf zzVXf2 = zzYb0.zzWoY(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz2P(zzVXf2);
            return fileFormatInfo;
        }
        finally {
            ((zzDT)zzVXf2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz2P(zz9j.zzXK2(stream));
    }

    static FileFormatInfo zz2P(zzDT zzDT2) throws Exception {
        if (zzDT2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzXiG zzXiG2 = new zzXiG();
            zzDT zzDT3 = zzDT2;
            zzXiG zzXiG3 = zzXiG2;
            return zzXiG2.zzWS3(zzDT3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYKF(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZnh(zz5Y.zzrg(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYLC(zz5Y.zzrg(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zz5M.zzYXr(string = zz5Y.zzZy8(FileFormatUtil.zzYY1(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZnh(FileFormatUtil.zzzO(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYLC(FileFormatUtil.zzYY1(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zz5Y.zzZy8(FileFormatUtil.zzzO(saveFormat));
        if (zz5M.zzYXr(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzYLC(zz5Y.zzYXY(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zz5Y.zzZy8(FileFormatUtil.zzW97(imageType));
    }

    static Exception zzYKF(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzZWe(int n) {
        return zz5Y.toString(FileFormatUtil.zzzO(n));
    }

    static int zzYLC(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYb0.zzXK2(zzWAa, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzj7(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzYb0.zzXK2(zzZmb, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzZ3d(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzYY1(int n) {
        return zzYb0.zzXK2(zzW0r, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzzO(int n) {
        return zzYb0.zzXK2(zzYfg, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzW97(int n) {
        return zzYb0.zzXK2(zzVWa, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZnh(int n) {
        return zzYb0.zzXK2(zzZbq, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzOT(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzYb0.zzWS3(zzWAa, Integer.valueOf(n), Integer.valueOf(n2));
            zzYb0.zzWS3(zzYfg, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZbq.containsKey(n)) {
                zzYb0.zzWS3(zzZbq, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzYb0.zzWS3(zzW0r, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzYb0.zzWS3(zzZmb, Integer.valueOf(n), Integer.valueOf(n4));
            zzYb0.zzWS3(zzVWa, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzOT(12, 10, 10, 1);
        FileFormatUtil.zzOT(12, 0, 0, 1);
        FileFormatUtil.zzOT(13, 11, 11, 1);
        FileFormatUtil.zzOT(14, 20, 20, 1);
        FileFormatUtil.zzOT(14, 0, 254, 1);
        FileFormatUtil.zzOT(15, 21, 21, 1);
        FileFormatUtil.zzOT(16, 22, 22, 1);
        FileFormatUtil.zzOT(17, 23, 23, 1);
        FileFormatUtil.zzOT(19, 24, 24, 1);
        FileFormatUtil.zzOT(20, 25, 25, 1);
        FileFormatUtil.zzOT(21, 26, 26, 1);
        FileFormatUtil.zzOT(22, 27, 27, 1);
        FileFormatUtil.zzOT(25, 30, 30, 1);
        FileFormatUtil.zzOT(18, 31, 31, 1);
        FileFormatUtil.zzOT(26, 50, 50, 1);
        FileFormatUtil.zzOT(27, 45, 255, 1);
        FileFormatUtil.zzOT(28, 51, 51, 1);
        FileFormatUtil.zzOT(29, 54, 52, 1);
        FileFormatUtil.zzOT(30, 0, 53, 1);
        FileFormatUtil.zzOT(32, 53, 54, 1);
        FileFormatUtil.zzOT(23, 60, 60, 1);
        FileFormatUtil.zzOT(24, 61, 61, 1);
        FileFormatUtil.zzOT(35, 40, 64, 1);
        FileFormatUtil.zzOT(42, 47, 255, 1);
        FileFormatUtil.zzOT(43, 48, 255, 1);
        FileFormatUtil.zzOT(36, 41, 255, 1);
        FileFormatUtil.zzOT(37, 46, 255, 1);
        FileFormatUtil.zzOT(39, 42, 255, 1);
        FileFormatUtil.zzOT(38, 44, 255, 1);
        FileFormatUtil.zzOT(31, 52, 55, 1);
        FileFormatUtil.zzOT(33, 70, 62, 1);
        FileFormatUtil.zzOT(34, 73, 63, 1);
        FileFormatUtil.zzOT(40, 71, 255, 1);
        FileFormatUtil.zzOT(8, 100, 255, 1);
        FileFormatUtil.zzOT(9, 105, 255, 1);
        FileFormatUtil.zzOT(6, 101, 255, 6);
        FileFormatUtil.zzOT(7, 102, 255, 7);
        FileFormatUtil.zzOT(5, 104, 255, 5);
        FileFormatUtil.zzOT(4, 0, 255, 4);
        FileFormatUtil.zzOT(3, 0, 255, 3);
        FileFormatUtil.zzOT(41, 72, 255, 1);
        FileFormatUtil.zzOT(2, 103, 255, 2);
        FileFormatUtil.zzOT(10, 106, 255, 8);
        FileFormatUtil.zzOT(47, 80, 255, 1);
    }
}

