/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.internal.zzZJU;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzwO;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzwO zzYvx;

    BorderCollection(zzwO parent) {
        this.zzYvx = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzYb0.zzXFC(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzZo4().equals(brColl.zzZo4()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzYvx.getPossibleBorderKeys().zzXK2(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzYvx.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzYvx, borderKey);
            this.zzYvx.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzYvx.getPossibleBorderKeys().zzok().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzYvx.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzYvx.getPossibleBorderKeys().zzok().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWdc(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzYvx.getPossibleBorderKeys().zzok().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWdc(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzZo4().zzXSZ();
    }

    public final void setColor(Color value) throws Exception {
        this.zzM3(zzZJU.zzXK2(value));
    }

    private zzZJU zzZo4() throws Exception {
        return this.get(0).zzZo4();
    }

    private void zzM3(zzZJU zzZJU2) throws Exception {
        Iterator iterator = this.zzYvx.getPossibleBorderKeys().zzok().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWdc(n)) continue;
            this.getByBorderType(n).zzM3(zzZJU2);
        }
    }

    final boolean zzEJ(int n) {
        return this.zzYvx.getPossibleBorderKeys().zzZvw(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzYvx.getPossibleBorderKeys().zzok().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWdc(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzYvx.getPossibleBorderKeys().zzok().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWdc(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXK2(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzWdc(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXK2
    implements Iterator<Border> {
        private BorderCollection zzYQs;
        private int zzWG6;

        zzXK2(BorderCollection borderCollection) {
            this.zzYQs = borderCollection;
            this.zzWG6 = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzWG6 >= this.zzYQs.getCount() - 1) {
                return false;
            }
            ++this.zzWG6;
            return true;
        }

        private Border zzYPj() {
            try {
                return this.zzYQs.get(this.zzWG6);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzYPj();
        }
    }
}

