/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXPF;
import com.aspose.words.internal.zzY8e;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWgD;
import com.aspose.words.zzX6O;
import com.aspose.words.zzYEh;
import com.aspose.words.zzYOw;
import com.aspose.words.zzZzG;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzZp7;
    private Node zzZfC;
    private Node zzXWz;
    private int zzXkW;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzYKF(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzZp7 == null) {
            return null;
        }
        if (this.zzZp7.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzZp7;
    }

    final CompositeNode zzZqg() {
        if (zzYOw.zzUG(this.getParentNode())) {
            return this.getParentNode().zzZqg();
        }
        return this.getParentNode();
    }

    final CompositeNode zzWzn() {
        if (zzYOw.zzUG(this.getParentNode()) || zzYOw.zzWHr(this.getParentNode())) {
            return this.getParentNode().zzWzn();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzZp7 != null) {
            return this.zzZp7.getDocument();
        }
        return null;
    }

    final Document zzZWj() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zz7A() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzSa();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXWz;
    }

    final Node zzf9() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzYOw.zzvp((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzMt() {
        Node node = zzYOw.zzYbj(this.getPreviousSibling(), false);
        if (node == null && zzYOw.zzUG(this.getParentNode())) {
            node = this.getParentNode().zzMt();
        }
        return node;
    }

    final Node zzYdp() {
        Node node = zzYOw.zzW7T(this.getNextSibling(), false);
        if (node == null && zzYOw.zzUG(this.getParentNode())) {
            node = this.getParentNode().zzYdp();
        }
        return node;
    }

    final CompositeNode zzXQn() {
        Node node = this;
        while ((node = node.zzMt()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzWo7() {
        Node node = this;
        while ((node = node.zzYdp()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZfC;
    }

    final Node zzYzg() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzYOw.zzvp((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzXK0() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYWB() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZ5q() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzYOw.zzWLw(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWbR() {
        return this.zzZfC;
    }

    final void zzZkc(Node node) {
        this.zzZfC = node;
    }

    final Node zzY3q() {
        return this.zzXWz;
    }

    final void zzXDx(Node node) {
        this.zzXWz = node;
    }

    final Node zzXOh() {
        Node node = this;
        if (node.zzZfC != null) {
            node = this;
            return node.zzZfC;
        }
        return this.getParentNode();
    }

    final int zzMa() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzYOw.zzWZh(this);
        boolean bl2 = zzYOw.zzWLY(this);
        boolean bl3 = zzYOw.zzY6z(this);
        boolean bl4 = zzYOw.zz2T(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzMa() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzMa() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXK2(isCloneChildren, new zzXK2(this));
    }

    Node zzXK2(boolean bl, zzWgD zzWgD2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzZp7 != null) {
            node.zzZp7 = this.getDocument().zzWXx();
        }
        node.zzZfC = null;
        node.zzXWz = null;
        if (zzWgD2 != null) {
            zzWgD2.zziA(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzUv(StringBuilder stringBuilder) {
        zzYb0.zzWS3(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZEz(Node node) {
        this.zzZp7 = node != null ? node : this.getDocument().zzWXx();
    }

    final void zzYKF(DocumentBase documentBase) {
        this.zzZp7 = documentBase != null ? documentBase.zzWXx() : null;
    }

    final boolean zzZq3(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYB8() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzZDm(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYq5(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzXFC(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzUv(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZ6j(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final <T extends Node> T zzJO(T t) {
        return this.getParentNode().insertAfter(t, this);
    }

    final <T extends Node> T zzWDP(T t) {
        return this.getParentNode().insertBefore(t, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzZzG zzZzG2 = zzYOw.zzXbP(saveFormat);
        return zzZzG2.zzWfY(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZzG zzZzG2 = zzYOw.zzWS3(saveOptions);
        return zzZzG2.zzWfY(this);
    }

    final Node zzYkP(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzYOw.zzWxh(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYEh zzYXm() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYEh.zzkI(node);
        }
        return zzYEh.zzZ6B(this.getParentNode());
    }

    final zzYEh zzXlb() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYEh.zzZ6B(node);
        }
        return zzYEh.zzkI(this.getParentNode());
    }

    final boolean zzwv(Node node) {
        return Node.zzYVw(this, node);
    }

    final boolean zzXEG() {
        return this.getAncestor(1) == null;
    }

    static Node zzXiH(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzXPF<Node> zzXPF2 = Node.zzYei(node);
        zzXPF<Node> zzXPF3 = Node.zzYei(node2);
        return Node.zzXK2(zzXPF2, zzXPF3);
    }

    static boolean zzYVw(Node node, Node node2) {
        zzXPF<Node> zzXPF2;
        if (node == null || node2 == null) {
            return false;
        }
        zzXPF<Node> zzXPF3 = Node.zzYei(node);
        Node node3 = Node.zzXK2(zzXPF3, zzXPF2 = Node.zzYei(node2));
        if (node3 == null) {
            return false;
        }
        zzXPF<Node> zzXPF4 = zzXPF3;
        if (zzXPF4.size() == 0 || (zzXPF4 = zzXPF2).size() == 0) {
            zzXPF4 = zzXPF2;
            boolean bl = zzXPF4.size() > 0;
            return bl;
        }
        Object e = zzXPF3.peek();
        Object e2 = zzXPF2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzXPF<Node> zzYei(Node node) {
        zzXPF<Node> zzXPF2 = new zzXPF<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzXPF2.push(node2);
        }
        return zzXPF2;
    }

    private static Node zzXK2(zzXPF<Node> zzXPF2, zzXPF<Node> zzXPF3) {
        Node node = null;
        while (zzXPF2.peek() == zzXPF3.peek()) {
            node = (Node)zzXPF2.pop();
            zzXPF3.pop();
            zzXPF<Node> zzXPF4 = zzXPF2;
            if (zzXPF4.size() != 0 && (zzXPF4 = zzXPF3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzXkW;
    }

    public void setCustomNodeId(int value) {
        this.zzXkW = value;
    }

    private String zzZ62() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzYb0.zzXK2(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzY8e.zzW67(stringBuilder.toString());
    }

    public String toString() {
        return zzY8e.zzW67(zzY8e.zzWS3("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzZ62()));
    }

    public void dd() {
    }

    final Node zzY6z(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzYyO(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWZh(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzYyO(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzYyO(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXK2
    implements zzWgD {
        private Node zzY4i;
        private HashMap<Integer, Integer> zz1s;

        zzXK2(Node node) {
            this.zzY4i = node;
        }

        @Override
        public final void zziA(Node node, Node node2) {
            if (node == this.zzY4i) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzX6O zzX6O2 = (zzX6O)((Object)node2);
            if (this.zz1s == null) {
                this.zz1s = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzYb0.zzXK2(this.zz1s, Integer.valueOf(zzX6O2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzXmF();
                zzYb0.zzWS3(this.zz1s, Integer.valueOf(zzX6O2.getIdInternal()), Integer.valueOf(n));
            }
            zzX6O2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzYb0.zzXK2(this.zz1s, Integer.valueOf(zzX6O2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzX6O2.setParentIdInternal(n2);
            }
        }
    }
}

