/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zz9j;
import com.aspose.words.zzXld;
import com.aspose.words.zzY1i;
import com.aspose.words.zzY7f;
import com.aspose.words.zzZU8;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzZU8,
Iterable<T> {
    private Node zzYND;
    private CompositeNode zzZ6C;
    private DocumentBase zzSB;
    private boolean zzZBp;
    private int zzcL;
    private int zzYrC;
    private Node zzWDk;
    private int zzBI;
    private zzXld zzX0q;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzY7f.zzR4(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzY7f(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzXld matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzZ6C = container;
        this.zzSB = container.getDocument();
        this.zzX0q = matcher;
        this.zzZBp = isDeep;
        this.zzXUT();
    }

    public Node get(int index) {
        try {
            this.zzXrm();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzYrC == index) {
                return this.zzWDk;
            }
            int n = index - this.zzYrC;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzwi(nodeCollection.zzWDk, n);
            if (node != null) {
                this.zzYrC = index;
                this.zzWDk = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzZBp) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZ6C.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzZBp) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZ6C.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzYMp();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzY1i(this);
    }

    final <TNode extends Node> zzY1i<TNode> zzZAx() {
        return new zzY1i(this);
    }

    final ArrayList<Node> zzWvz() {
        return this.zzYMp();
    }

    final <TValue extends Node> ArrayList<TValue> zzYMp() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zz9j.zzXK2(arrayList, node);
        }
        return arrayList;
    }

    private Node zzwi(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzYUL(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzqW(curNode, true);
    }

    private Node zzqW(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzYND = node;
        do {
            node2 = this.zzYND;
            Node node3 = this.zzZBp ? this.zzXK2(true, this.zzYND) : (this.zzYND = this.zzX0q.zzbL() ? this.zzYKF(true, this.zzYND) : this.zzWS3(true, this.zzYND));
        } while (this.zzYND != null && !this.zzX0q.zzWDj(this.zzYND));
        return node2;
    }

    private Node zzYUL(Node node, boolean bl) throws Exception {
        while ((this.zzZBp ? this.zzXK2(bl, node) : (node = this.zzX0q.zzbL() ? this.zzYKF(bl, node) : this.zzWS3(bl, node))) != null && !this.zzX0q.zzWDj(node)) {
        }
        return node;
    }

    private Node zzXK2(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZ6C);
        }
        return node.previousPreOrder(this.zzZ6C);
    }

    private Node zzWS3(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZ6C) {
                return this.zzZ6C.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZ6C) {
            return this.zzZ6C.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYKF(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZ6C ? this.zzZ6C.zzXtl() : node.zzYdp();
        } else {
            Node node3 = node2 = node == this.zzZ6C ? this.zzZ6C.zzWiZ() : node.zzMt();
        }
        if (node2 == this.zzZ6C.getNextSibling() || node2 == this.zzZ6C.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzXrm() {
        if (this.zzcL != this.zzVQJ()) {
            this.zzXUT();
        }
    }

    private void zzXUT() {
        this.zzcL = this.zzVQJ();
        this.zzYrC = -1;
        this.zzWDk = this.zzZ6C;
        this.zzBI = -1;
    }

    private int zzVQJ() {
        if (this.zzSB != null) {
            return this.zzSB.zzWFY();
        }
        return 0;
    }

    public int getCount() {
        this.zzXrm();
        if (this.zzBI == -1) {
            this.zzBI = zzY1i.zzXK2(this);
        }
        return this.zzBI;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzYND;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZ6C;
    }
}

