/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz5M;
import com.aspose.words.internal.zzW9c;
import com.aspose.words.internal.zzXL1;
import com.aspose.words.internal.zzY8e;
import com.aspose.words.internal.zzYWb;
import com.aspose.words.internal.zzYb0;
import com.aspose.words.zzZr6;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzX2Q;
    private zzZr6 zzei;

    Watermark(Document doc, zzZr6 watermarkProvider) {
        this.zzX2Q = doc;
        this.zzei = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzHN(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXK2(text, textWatermarkOptions, this.zzX2Q);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzYb0.zzWS3((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzX2Q, 75);
        shape.getImageData().setImage(image);
        this.zzXK2(shape, options, this.zzX2Q);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzYb0.zzWS3((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzX2Q, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXK2(shape, options, this.zzX2Q);
    }

    public final int getType() {
        Shape shape = this.zzei.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYP1();
        if (shape.zzYHq()) {
            return 0;
        }
        if (shape.zzZLf()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzei.add(shape);
    }

    public final void remove() {
        this.zzei.remove();
    }

    private static void zzHN(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zz5M.zz0C(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzYb0.zzXK2(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXK2(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzWS3(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzYtJ(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzWS3(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzW1K() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzU6()) / d2) > (double)(f = pageSetup.zzVPD())) {
            d = (double)f / d3;
        }
        shape.zzZt7(zzXL1.zzYKF(d2 * d, 2, 1));
        shape.zzXnh(zzXL1.zzYKF(d3 * d, 2, 1));
    }

    private Shape zzXK2(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXK2(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzYtJ(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXK2(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZCa() ? 1.0f : textWatermarkOptions.getFontSize();
        zzW9c zzW9c2 = document.zzVUf().zzYKF(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzW9c2.zzYyO(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZCa()) {
            l = Watermark.zzXK2(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZt7(zzXL1.zzYKF(Float.intBitsToFloat(n), 2, 1));
        shape.zzXnh(zzXL1.zzYKF(zzYWb.zzYF3(l), 2, 1));
    }

    private static long zzXK2(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzU6();
        float f2 = pageSetup.zzVPD();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYWb.zzYF3(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYWb.zzZT0(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYWb.zzYF3(l) >= Float.intBitsToFloat(n)) {
            return zzYWb.zzZT0(f2 / f3, f2);
        }
        float f6 = f;
        return zzYWb.zzZT0(f6, f6 * f3);
    }

    private static void zzYtJ(Shape shape, String string) {
        shape.setName(zzY8e.zzWS3("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

