package com.github.mikephil.charting.utils;

/**
 * Contains information needed to determine the highlighted value.
 * 
 * @author Philipp Jahoda
 */
public class Highlight {

	/** the x-index of the highlighted value */
	private int mXIndex;

	/** the index of the dataset the highlighted value is in */
	private int mDataSetIndex;

	/**
	 * constructor
	 * 
	 * @param x
	 *            the index of the highlighted value on the x-axis
	 * @param dataSet
	 *            the index of the DataSet the highlighted value belongs to
	 */
	public Highlight(int x, int dataSet) {
		this.mXIndex = x;
		this.mDataSetIndex = dataSet;
	}

	/**
	 * returns the index of the DataSet the highlighted value is in
	 * 
	 * @return
	 */
	public int getDataSetIndex() {
		return mDataSetIndex;
	}

	/**
	 * returns the index of the highlighted value on the x-axis
	 * 
	 * @return
	 */
	public int getXIndex() {
		return mXIndex;
	}

	@Override
	public boolean equals(Object o) {
		if (this != null && o != null) {
			if (o instanceof Highlight) {
				Highlight other = (Highlight) o;
				if (mXIndex == other.mXIndex && mDataSetIndex == other.mDataSetIndex) {
					return true;
				}
			}
		}
		return false;
	}
}
