/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;

public class DataSet {
    private ArrayList<Entry> mYVals = null;
    private float mYMax = 0.0f;
    private float mYMin = 0.0f;
    private float mYValueSum = 0.0f;
    private String mLabel = "DataSet";

    public DataSet(ArrayList<Entry> yVals, String label) {
        this.mLabel = label;
        this.mYVals = yVals;
        if (yVals.size() <= 0) {
            return;
        }
        this.calcMinMax();
        this.calcYValueSum();
    }

    public void notifyDataSetChanged() {
        this.calcMinMax();
        this.calcYValueSum();
    }

    public DataSet cloneDataSet() {
        ArrayList<Entry> duplicatedEntries = new ArrayList<Entry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            Entry entry = this.mYVals.get(i).copy();
            duplicatedEntries.add(entry);
        }
        DataSet dataSet = new DataSet(duplicatedEntries, this.mLabel);
        return dataSet;
    }

    private void calcMinMax() {
        if (this.mYVals.size() == 0) {
            return;
        }
        this.mYMin = this.mYVals.get(0).getVal();
        this.mYMax = this.mYVals.get(0).getVal();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            if (this.mYVals.get(i).getVal() < this.mYMin) {
                this.mYMin = this.mYVals.get(i).getVal();
            }
            if (!(this.mYVals.get(i).getVal() > this.mYMax)) continue;
            this.mYMax = this.mYVals.get(i).getVal();
        }
    }

    private void calcYValueSum() {
        this.mYValueSum = 0.0f;
        for (int i = 0; i < this.mYVals.size(); ++i) {
            this.mYValueSum += Math.abs(this.mYVals.get(i).getVal());
        }
    }

    public int getEntryCount() {
        return this.mYVals.size();
    }

    public float getYValForXIndex(int xIndex) {
        Entry s = this.getEntryForXIndex(xIndex);
        if (s != null) {
            return s.getVal();
        }
        return Float.NaN;
    }

    public Entry getEntryForXIndex(int xIndex) {
        for (int i = 0; i < this.mYVals.size(); ++i) {
            if (xIndex != this.mYVals.get(i).getXIndex()) continue;
            return this.mYVals.get(i);
        }
        return null;
    }

    public ArrayList<Entry> getEntriesForXIndex(int xIndex) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            if (xIndex != this.mYVals.get(i).getXIndex()) continue;
            entries.add(this.mYVals.get(i));
        }
        return entries;
    }

    public ArrayList<Entry> getYVals() {
        return this.mYVals;
    }

    public float getYValueSum() {
        return this.mYValueSum;
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public int getIndexInEntries(int xIndex) {
        for (int i = 0; i < this.mYVals.size(); ++i) {
            if (xIndex != this.mYVals.get(i).getXIndex()) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<DataSet> makeDataSets(ArrayList<Double[]> yValues) {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (int i = 0; i < yValues.size(); ++i) {
            Double[] curValues = yValues.get(i);
            ArrayList<Entry> entries = new ArrayList<Entry>();
            for (int j = 0; j < curValues.length; ++j) {
                entries.add(new Entry(curValues[j].floatValue(), j));
            }
            dataSets.add(new DataSet(entries, "DS " + i));
        }
        return dataSets;
    }

    public DataSet copy() {
        ArrayList<Entry> yVals = new ArrayList<Entry>();
        for (int i = 0; i < this.mYVals.size(); ++i) {
            yVals.add(this.mYVals.get(i).copy());
        }
        DataSet copied = new DataSet(yVals, this.mLabel);
        return copied;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toSimpleString());
        for (int i = 0; i < this.mYVals.size(); ++i) {
            buffer.append(this.mYVals.get(i).toString() + " ");
        }
        return buffer.toString();
    }

    public String toSimpleString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataSet, label: " + this.mLabel + ", entries: " + this.mYVals.size() + "\n");
        return buffer.toString();
    }

    public String getLabel() {
        return this.mLabel;
    }
}

