/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j;

import com.github.llmjava.cohere4j.AuthorizationInterceptor;
import com.github.llmjava.cohere4j.CohereApi;
import com.github.llmjava.cohere4j.CohereConfig;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class CohereApiFactory {
    Gson gson;
    OkHttpClient okHttpClient;

    public CohereApiFactory createHttpClient(CohereConfig config) {
        String apiKey = config.getApiKey();
        Duration timeout = config.getTimeout();
        this.okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationInterceptor(apiKey)).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).build();
        return this;
    }

    CohereApiFactory createGson() {
        this.gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setLenient().create();
        return this;
    }

    CohereApi build() {
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.cohere.ai/").client(this.okHttpClient).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson)).build();
        return (CohereApi)retrofit.create(CohereApi.class);
    }
}

