/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class CohereConfig {
    private final Configuration config;
    public static final String BASE_URL = "https://api.cohere.ai/";
    public static final String API_KEY = "cohere.apiKey";
    public static final String TIMEOUT = "timeout";
    public static final Long DEFAULT_TIMEOUT_MILLIS = 10000L;

    public CohereConfig(Configuration config) {
        this.config = config;
    }

    public String getApiKey() {
        return this.config.getString(API_KEY);
    }

    public Duration getTimeout() {
        Long timeout = this.config.getLong(TIMEOUT, DEFAULT_TIMEOUT_MILLIS);
        return Duration.ofMillis(timeout);
    }

    public Integer getTopK() {
        return this.config.getInteger("topK", Integer.valueOf(0));
    }

    public Double geTopP() {
        return this.config.getDouble("topP", 0.0);
    }

    public Double getTemperature() {
        return this.config.getDouble("temperature", 0.75);
    }

    public String getModel() {
        return this.config.getString("cohere.model", "command");
    }

    public Integer getNumGenerations() {
        return this.config.getInteger("num_generations", Integer.valueOf(1));
    }

    public Boolean isStream() {
        return this.config.getBoolean("stream", false);
    }

    public Integer getMaxTokens() {
        return this.config.getInteger("max_tokens", Integer.valueOf(1024));
    }

    public String getTruncate() {
        return this.config.getString("truncate", "END");
    }

    public String getPreset() {
        return this.config.getString("preset");
    }

    public List<String> getEndSequences() {
        ArrayList<String> result = new ArrayList<String>();
        String sequences = this.config.getString("end_sequences");
        if (sequences != null) {
            for (String seq : sequences.split(",")) {
                result.add(seq);
            }
        }
        return result;
    }

    public List<String> getStopSequences() {
        ArrayList<String> result = new ArrayList<String>();
        String sequences = this.config.getString("stop_sequences");
        if (sequences != null) {
            for (String seq : sequences.split(",")) {
                result.add(seq);
            }
        }
        return result;
    }

    public Double getFrequencyPenalty() {
        return this.config.getDouble("frequency_penalty", 0.0);
    }

    public Double getPresencePenalty() {
        return this.config.getDouble("presence_penalty", 0.0);
    }

    public String getReturnLikelihoods() {
        return this.config.getString("return_likelihoods");
    }

    public Map<String, Double> getLogitBias() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        String sequences = this.config.getString("logit_bias");
        if (sequences != null) {
            for (String pair : sequences.split(",")) {
                String[] kv = pair.split(":");
                if (kv.length != 2) continue;
                result.put(kv[0], Double.valueOf(kv[1]));
            }
        }
        return result;
    }

    public static CohereConfig fromProperties(String path) throws ConfigurationException {
        PropertiesConfiguration baseConfig = new Configurations().properties(path);
        return new CohereConfig((Configuration)baseConfig);
    }
}

