/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j.exception;

import com.github.llmjava.cohere4j.exception.CohereResponse;
import com.google.gson.Gson;
import java.io.IOException;
import retrofit2.Response;

public class CohereException
extends RuntimeException {
    int code;
    private static final Gson gson = new Gson();

    CohereException(int code, String message) {
        super(message);
        this.code = code;
    }

    public CohereException(Throwable cause) {
        super(cause);
    }

    public static CohereException fromResponse(Response<?> response) {
        try {
            int code = response.code();
            String body = response.errorBody().string();
            CohereResponse resp = (CohereResponse)gson.fromJson(body, CohereResponse.class);
            return new CohereException(code, resp.message);
        }
        catch (IOException e) {
            return new CohereException(e);
        }
    }
}

