/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j.request;

import java.util.ArrayList;
import java.util.List;

public class ClassifyRequest {
    private List<String> inputs;
    private List<Example> examples;
    private String model;
    private String preset;
    private String truncate;

    ClassifyRequest(Builder builder) {
        this.inputs = builder.inputs;
        this.examples = builder.examples;
        this.model = builder.model;
        this.preset = builder.preset;
        this.truncate = builder.truncate;
    }

    public static class Builder {
        private List<String> inputs = new ArrayList<String>();
        private List<Example> examples = new ArrayList<Example>();
        private String model;
        private String preset;
        private String truncate;

        public Builder withInput(String text) {
            this.inputs.add(text);
            return this;
        }

        public Builder withExample(String text, String label) {
            this.examples.add(new Example(text, label));
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withPreset(String preset) {
            this.preset = preset;
            return this;
        }

        public Builder withTruncate(String truncate) {
            this.truncate = truncate;
            return this;
        }

        public ClassifyRequest build() {
            return new ClassifyRequest(this);
        }
    }

    public static class Example {
        private String text;
        private String label;

        public Example(String text, String label) {
            this.text = text;
            this.label = label;
        }
    }
}

