/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j.request;

import java.util.ArrayList;
import java.util.List;

public class EmbedRequest {
    private String[] texts;
    private String model;
    private String truncate;

    EmbedRequest(Builder builder) {
        this.texts = builder.texts.toArray(new String[builder.texts.size()]);
        this.model = builder.model;
        this.truncate = builder.truncate;
    }

    public static class Builder {
        private List<String> texts = new ArrayList<String>();
        private String model;
        private String truncate;

        public Builder withText(String text) {
            this.texts.add(text);
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withTruncate(String truncate) {
            this.truncate = truncate;
            return this;
        }

        public EmbedRequest build() {
            return new EmbedRequest(this);
        }
    }
}

