/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j.request;

import com.github.llmjava.cohere4j.CohereConfig;
import java.util.List;
import java.util.Map;

public class GenerateRequest {
    private String prompt;
    private String model;
    private Integer num_generations;
    private Boolean stream;
    private Integer max_tokens;
    private String truncate;
    private Double temperature;
    private String preset;
    private List<String> end_sequences;
    private List<String> stop_sequences;
    private Integer k;
    private Double p;
    private Double frequency_penalty;
    private Double presence_penalty;
    private String return_likelihoods;
    private Map<String, Double> logit_bias;

    GenerateRequest(Builder builder) {
        this.prompt = builder.prompt;
        this.model = builder.model;
        this.num_generations = builder.num_generations;
        this.stream = builder.stream;
        this.max_tokens = builder.max_tokens;
        this.truncate = builder.truncate;
        this.temperature = builder.temperature;
        this.preset = builder.preset;
        this.end_sequences = builder.end_sequences;
        this.stop_sequences = builder.stop_sequences;
        this.k = builder.k;
        this.p = builder.p;
        this.frequency_penalty = builder.frequency_penalty;
        this.presence_penalty = builder.presence_penalty;
        this.return_likelihoods = builder.return_likelihoods;
        this.logit_bias = builder.logit_bias;
    }

    public Boolean isStreaming() {
        return this.stream != null && this.stream != false;
    }

    public static class Builder {
        private String prompt;
        private String model;
        private Integer num_generations;
        private Boolean stream;
        private Integer max_tokens;
        private String truncate;
        private Double temperature;
        private String preset;
        private List<String> end_sequences;
        private List<String> stop_sequences;
        private Integer k;
        private Double p;
        private Double frequency_penalty;
        private Double presence_penalty;
        private String return_likelihoods;
        private Map<String, Double> logit_bias;

        public Builder withPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withStream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder withMaxTokens(Integer maxTokens) {
            this.max_tokens = maxTokens;
            return this;
        }

        public Builder withTruncate(String truncate) {
            this.truncate = truncate;
            return this;
        }

        public Builder withLikelihoods(String likelihoods) {
            this.return_likelihoods = likelihoods;
            return this;
        }

        public Builder withConfig(CohereConfig config) {
            this.model = config.getModel();
            this.num_generations = config.getNumGenerations();
            this.stream = config.isStream();
            this.max_tokens = config.getMaxTokens();
            this.truncate = config.getTruncate();
            this.temperature = config.getTemperature();
            this.preset = config.getPreset();
            this.end_sequences = config.getEndSequences();
            this.stop_sequences = config.getStopSequences();
            this.k = config.getTopK();
            this.p = config.geTopP();
            this.frequency_penalty = config.getFrequencyPenalty();
            this.presence_penalty = config.getPresencePenalty();
            this.return_likelihoods = config.getReturnLikelihoods();
            this.logit_bias = config.getLogitBias();
            return this;
        }

        public GenerateRequest build() {
            return new GenerateRequest(this);
        }
    }
}

