/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j.request;

import java.util.ArrayList;
import java.util.List;

public class RerankRequest {
    private String model;
    private String query;
    private List<String> documents;
    private Integer top_n;
    private Boolean return_documents;
    private Integer max_chunks_per_doc;

    RerankRequest(Builder builder) {
        this.model = builder.model;
        this.query = builder.query;
        this.documents = builder.documents;
        this.top_n = builder.top_n;
        this.return_documents = builder.return_documents;
        this.max_chunks_per_doc = builder.max_chunks_per_doc;
    }

    public static class Builder {
        private String model;
        private String query;
        private List<String> documents = new ArrayList<String>();
        private Integer top_n;
        private Boolean return_documents;
        private Integer max_chunks_per_doc;

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder withDocument(String document) {
            this.documents.add(document);
            return this;
        }

        public Builder withTopN(Integer top_n) {
            this.top_n = top_n;
            return this;
        }

        public Builder withReturnDocuments(Boolean return_documents) {
            this.return_documents = return_documents;
            return this;
        }

        public Builder withMaxChunksPerDoc(Integer max_chunks_per_doc) {
            this.max_chunks_per_doc = max_chunks_per_doc;
            return this;
        }

        public RerankRequest build() {
            return new RerankRequest(this);
        }
    }
}

