/*
 * Decompiled with CFR 0.152.
 */
package com.github.llmjava.cohere4j.response;

import com.github.llmjava.cohere4j.response.Meta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RerankResponse {
    private String id;
    private List<Result> results;
    private Map<Integer, Result> resultByIndex = new HashMap<Integer, Result>();
    private Meta meta;

    private void init() {
        if (this.resultByIndex.isEmpty() && this.results != null && !this.results.isEmpty()) {
            for (Result result : this.results) {
                this.resultByIndex.put(result.index, result);
            }
        }
    }

    public Result getResultByIndex(int index) {
        this.init();
        return this.resultByIndex.get(index);
    }

    public Result getResultByRank(int rank) {
        return this.results.get(rank);
    }

    public Float getScoreByIndex(int index) {
        this.init();
        Result result = this.resultByIndex.get(index);
        return result.getRelevanceScore();
    }

    public static class Result {
        private Integer index;
        private Float relevance_score;

        public Integer getIndex() {
            return this.index;
        }

        public Float getRelevanceScore() {
            return this.relevance_score;
        }
    }
}

