/*
 * Decompiled with CFR 0.152.
 */
package com.owl93.dpb;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BaseInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import androidx.core.content.ContextCompat;
import com.owl93.dpb.CircularProgressView$WhenMappings;
import com.owl93.dpb.DeterminateProgressViewListener;
import com.owl93.dpb.Direction;
import com.owl93.dpb.Gradient;
import com.owl93.dpb.R;
import com.owl93.dpb.StrokeGradient;
import com.owl93.dpb.TextFormat;
import com.owl93.dpb.TextGradient;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0014\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b3\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00cf\u00012\u00020\u0001:\u0002\u00cf\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0007\u0010\u00b2\u0001\u001a\u00020\u00162\t\b\u0002\u0010\u00b3\u0001\u001a\u00020\u000eJ\u001c\u0010\u00b4\u0001\u001a\u00020P2\u0007\u0010\u00b5\u0001\u001a\u00020\t2\b\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001H\u0002J\u001b\u0010\u00b8\u0001\u001a\u00020\t2\u0007\u0010\u00b9\u0001\u001a\u00020\t2\u0007\u0010\u00ba\u0001\u001a\u00020\tH\u0002J&\u0010\u00bb\u0001\u001a\u0004\u0018\u00010P2\u0007\u0010\u00bc\u0001\u001a\u00020\u00162\u0006\u0010s\u001a\u00020\u00162\b\u0010\u00bd\u0001\u001a\u00030\u00be\u0001H\u0002J;\u0010\u00bf\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u00be\u0001\u0012\u0004\u0012\u00020P0\u00c0\u00012\u0007\u0010\u00c1\u0001\u001a\u00020\t2\u0007\u0010\u00c2\u0001\u001a\u00020\t2\u0007\u0010\u00c3\u0001\u001a\u00020\t2\u0007\u0010\u00c4\u0001\u001a\u00020\u001cH\u0002J\n\u0010\u00c5\u0001\u001a\u00030\u00b1\u0001H\u0002J\t\u0010\u00c6\u0001\u001a\u00020vH\u0002J\u0013\u0010\u00c7\u0001\u001a\u00030\u00b7\u00012\u0007\u0010\u00c8\u0001\u001a\u00020$H\u0002J\u0014\u0010\u00c9\u0001\u001a\u00030\u00b1\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u00ca\u0001\u001a\u00030\u00b1\u00012\n\u0010\u00cb\u0001\u001a\u0005\u0018\u00010\u00cc\u0001H\u0014J\n\u0010\u00cd\u0001\u001a\u00030\u00b1\u0001H\u0002J\n\u0010\u00ce\u0001\u001a\u00030\u00b1\u0001H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R$\u0010:\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R$\u0010?\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR$\u0010D\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR$\u0010I\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010F\"\u0004\bK\u0010HR$\u0010L\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010F\"\u0004\bN\u0010HR\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010R\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u000e\u0010W\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010X\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010T\"\u0004\bZ\u0010VR$\u0010[\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010F\"\u0004\b]\u0010HR$\u0010^\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010F\"\u0004\b`\u0010HR$\u0010a\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010F\"\u0004\bc\u0010HR\u000e\u0010d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010e\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR$\u0010j\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u000e\u0010o\u001a\u00020pX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010q\u001a\u0004\u0018\u00010rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010s\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010T\"\u0004\bu\u0010VR(\u0010w\u001a\u0004\u0018\u00010v2\b\u00109\u001a\u0004\u0018\u00010v@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R\u000e\u0010|\u001a\u00020}X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010~\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b\u007f\u0010F\"\u0005\b\u0080\u0001\u0010HR'\u0010\u0081\u0001\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0082\u0001\u0010A\"\u0005\b\u0083\u0001\u0010CR)\u0010\u0084\u0001\u001a\u00020!2\u0006\u00109\u001a\u00020!@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R'\u0010\u0089\u0001\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008a\u0001\u0010F\"\u0005\b\u008b\u0001\u0010HR'\u0010\u008c\u0001\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008d\u0001\u0010F\"\u0005\b\u008e\u0001\u0010HR'\u0010\u008f\u0001\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0090\u0001\u0010F\"\u0005\b\u0091\u0001\u0010HR\u000f\u0010\u0092\u0001\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0093\u0001\u001a\u00020$2\u0006\u00109\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001\"\u0006\b\u0096\u0001\u0010\u0097\u0001R'\u0010\u0098\u0001\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0099\u0001\u0010F\"\u0005\b\u009a\u0001\u0010HR'\u0010\u009b\u0001\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u009c\u0001\u0010l\"\u0005\b\u009d\u0001\u0010nR\u000f\u0010\u009e\u0001\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u009f\u0001\u001a\u00020pX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u00a0\u0001\u001a\u0004\u0018\u00010rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\u00a1\u0001\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a2\u0001\u0010T\"\u0005\b\u00a3\u0001\u0010VR\u000f\u0010\u00a4\u0001\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u00a5\u0001\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u00a6\u0001\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00a7\u0001\u0010F\"\u0005\b\u00a8\u0001\u0010HR'\u0010\u00a9\u0001\u001a\u00020\t2\u0006\u00109\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00aa\u0001\u0010F\"\u0005\b\u00ab\u0001\u0010HR\u000f\u0010\u00ac\u0001\u001a\u00020pX\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\u00ad\u0001\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u00ae\u0001\u0010T\"\u0005\b\u00af\u0001\u0010V\u00a8\u0006\u00d0\u0001"}, d2={"Lcom/owl93/dpb/CircularProgressView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "DEFAULT_ANIMATION_DURATION", "", "DEFAULT_DIRECTION", "Lcom/owl93/dpb/Direction;", "DEFAULT_DRAW_TEXT", "", "DEFAULT_DRAW_TRACK", "DEFAULT_INTERPOLATOR_IDX", "DEFAULT_MAX_VALUE", "", "DEFAULT_STARTING_ANGLE", "DEFAULT_STK_GRAD_LINEAR_ANGLE", "DEFAULT_STK_GRAD_SIZE", "Lcom/owl93/dpb/StrokeGradient;", "DEFAULT_STK_GRAD_STYLE", "Lcom/owl93/dpb/Gradient;", "DEFAULT_STROKE_COLOR", "DEFAULT_STROKE_WIDTH", "DEFAULT_TEXT_COLOR", "DEFAULT_TEXT_FORMAT", "Lcom/owl93/dpb/TextFormat;", "DEFAULT_TEXT_SIZE", "DEFAULT_TXT_GRAD_SIZE", "Lcom/owl93/dpb/TextGradient;", "DEFAULT_TXT_GRAD_STYLE", "DEFAULT_TXT_LINEAR_ANGLE", "_progress", "animationDuration", "getAnimationDuration", "()J", "setAnimationDuration", "(J)V", "animationInterpolator", "Landroid/view/animation/BaseInterpolator;", "getAnimationInterpolator", "()Landroid/view/animation/BaseInterpolator;", "setAnimationInterpolator", "(Landroid/view/animation/BaseInterpolator;)V", "animationListener", "Lcom/owl93/dpb/DeterminateProgressViewListener;", "getAnimationListener", "()Lcom/owl93/dpb/DeterminateProgressViewListener;", "setAnimationListener", "(Lcom/owl93/dpb/DeterminateProgressViewListener;)V", "value", "direction", "getDirection", "()Lcom/owl93/dpb/Direction;", "setDirection", "(Lcom/owl93/dpb/Direction;)V", "drawTrack", "getDrawTrack", "()Z", "setDrawTrack", "(Z)V", "gradientCenterColor", "getGradientCenterColor", "()I", "setGradientCenterColor", "(I)V", "gradientEndColor", "getGradientEndColor", "setGradientEndColor", "gradientStartColor", "getGradientStartColor", "setGradientStartColor", "halfGradientPositions", "", "isAnimating", "maxValue", "getMaxValue", "()F", "setMaxValue", "(F)V", "minDimen", "progress", "getProgress", "setProgress", "startingAngle", "getStartingAngle", "setStartingAngle", "strokeColor", "getStrokeColor", "setStrokeColor", "strokeGradientLinearAngle", "getStrokeGradientLinearAngle", "setStrokeGradientLinearAngle", "strokeGradientMode", "strokeGradientSize", "getStrokeGradientSize", "()Lcom/owl93/dpb/StrokeGradient;", "setStrokeGradientSize", "(Lcom/owl93/dpb/StrokeGradient;)V", "strokeGradientStyle", "getStrokeGradientStyle", "()Lcom/owl93/dpb/Gradient;", "setStrokeGradientStyle", "(Lcom/owl93/dpb/Gradient;)V", "strokePaint", "Landroid/graphics/Paint;", "strokeShader", "Landroid/graphics/Shader;", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textBounds", "Landroid/graphics/Rect;", "textColor", "getTextColor", "setTextColor", "textEnabled", "getTextEnabled", "setTextEnabled", "textFormat", "getTextFormat", "()Lcom/owl93/dpb/TextFormat;", "setTextFormat", "(Lcom/owl93/dpb/TextFormat;)V", "textGradientCenterColor", "getTextGradientCenterColor", "setTextGradientCenterColor", "textGradientEndColor", "getTextGradientEndColor", "setTextGradientEndColor", "textGradientLinearAngle", "getTextGradientLinearAngle", "setTextGradientLinearAngle", "textGradientMode", "textGradientSize", "getTextGradientSize", "()Lcom/owl93/dpb/TextGradient;", "setTextGradientSize", "(Lcom/owl93/dpb/TextGradient;)V", "textGradientStartColor", "getTextGradientStartColor", "setTextGradientStartColor", "textGradientStyle", "getTextGradientStyle", "setTextGradientStyle", "textHeight", "textPaint", "textShader", "textSize", "getTextSize", "setTextSize", "textWidth", "thirdsGradientPositions", "trackAlpha", "getTrackAlpha", "setTrackAlpha", "trackColor", "getTrackColor", "setTrackColor", "trackPaint", "trackWidth", "getTrackWidth", "setTrackWidth", "animateProgressChange", "", "toValue", "duration", "computeLinearAngle", "angle", "bounds", "Landroid/graphics/RectF;", "computeMiddleColor", "color1", "color2", "computeStrokeRadialPositions", "strokeEnd", "colors", "", "determineGradientDetails", "Lkotlin/Pair;", "start", "center", "end", "style", "determineGradientStatus", "formatText", "getTextGradientBounds", "grad", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "regenerateStrokeShader", "regenerateTextShader", "Companion", "app_release"})
public final class CircularProgressView
extends View {
    private final int DEFAULT_STROKE_COLOR;
    private final int DEFAULT_TEXT_COLOR;
    private final float DEFAULT_TEXT_SIZE = 100.0f;
    private final int DEFAULT_STARTING_ANGLE = 0;
    private final Direction DEFAULT_DIRECTION;
    private final float DEFAULT_STROKE_WIDTH = 20.0f;
    private final boolean DEFAULT_DRAW_TRACK = true;
    private final float DEFAULT_MAX_VALUE = 100.0f;
    private final boolean DEFAULT_DRAW_TEXT = true;
    private final TextFormat DEFAULT_TEXT_FORMAT;
    private final int DEFAULT_INTERPOLATOR_IDX = 0;
    private final long DEFAULT_ANIMATION_DURATION = 400L;
    private final Gradient DEFAULT_STK_GRAD_STYLE;
    private final int DEFAULT_STK_GRAD_LINEAR_ANGLE = 0;
    private final StrokeGradient DEFAULT_STK_GRAD_SIZE;
    private final Gradient DEFAULT_TXT_GRAD_STYLE;
    private final int DEFAULT_TXT_LINEAR_ANGLE = 0;
    private final TextGradient DEFAULT_TXT_GRAD_SIZE;
    private final float[] thirdsGradientPositions;
    private final float[] halfGradientPositions;
    private float _progress;
    private float minDimen;
    private float textWidth;
    private float textHeight;
    private Paint strokePaint;
    private Paint trackPaint;
    private Paint textPaint;
    private Rect textBounds;
    private Shader strokeShader;
    private Shader textShader;
    @Nullable
    private DeterminateProgressViewListener animationListener;
    private float maxValue;
    private int strokeColor;
    private boolean strokeGradientMode;
    private int gradientStartColor;
    private int gradientCenterColor;
    private int gradientEndColor;
    @NotNull
    private Gradient strokeGradientStyle;
    private int strokeGradientLinearAngle;
    @NotNull
    private StrokeGradient strokeGradientSize;
    private boolean drawTrack;
    private int trackColor;
    private float trackWidth;
    private int trackAlpha;
    private float strokeWidth;
    private float progress;
    private int startingAngle;
    @NotNull
    private Direction direction;
    private boolean textEnabled;
    private float textSize;
    private int textColor;
    private boolean textGradientMode;
    private int textGradientStartColor;
    private int textGradientCenterColor;
    private int textGradientEndColor;
    @NotNull
    private Gradient textGradientStyle;
    private int textGradientLinearAngle;
    @NotNull
    private TextGradient textGradientSize;
    @NotNull
    private TextFormat textFormat;
    @Nullable
    private String text;
    private long animationDuration;
    @NotNull
    private BaseInterpolator animationInterpolator;
    private boolean isAnimating;
    private static final String TAG = "CircularProgressView";
    public static final int DEFAULT_TRACK_ALPHA = 125;
    private static final BaseInterpolator[] interpolators;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Nullable
    public final DeterminateProgressViewListener getAnimationListener() {
        return this.animationListener;
    }

    public final void setAnimationListener(@Nullable DeterminateProgressViewListener determinateProgressViewListener) {
        this.animationListener = determinateProgressViewListener;
    }

    public final float getMaxValue() {
        return this.maxValue;
    }

    public final void setMaxValue(float value) {
        this.maxValue = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set maxvalue: " + value));
    }

    public final int getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(int value) {
        this.strokeColor = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set strokeColor: " + value));
    }

    public final int getGradientStartColor() {
        return this.gradientStartColor;
    }

    public final void setGradientStartColor(int value) {
        this.gradientStartColor = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set gradientStart: " + value));
    }

    public final int getGradientCenterColor() {
        return this.gradientCenterColor;
    }

    public final void setGradientCenterColor(int value) {
        this.gradientCenterColor = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set gradientCenter: " + value));
    }

    public final int getGradientEndColor() {
        return this.gradientEndColor;
    }

    public final void setGradientEndColor(int value) {
        this.gradientEndColor = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set gradientEnd: " + value));
    }

    @NotNull
    public final Gradient getStrokeGradientStyle() {
        return this.strokeGradientStyle;
    }

    public final void setStrokeGradientStyle(@NotNull Gradient value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.strokeGradientStyle = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set gradientStyle: " + (Object)((Object)value)));
    }

    public final int getStrokeGradientLinearAngle() {
        return this.strokeGradientLinearAngle;
    }

    public final void setStrokeGradientLinearAngle(int value) {
        this.strokeGradientLinearAngle = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set strokeLinearAngle: " + value));
    }

    @NotNull
    public final StrokeGradient getStrokeGradientSize() {
        return this.strokeGradientSize;
    }

    public final void setStrokeGradientSize(@NotNull StrokeGradient value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.strokeGradientSize = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set strokeRadialSize: " + (Object)((Object)value)));
    }

    public final boolean getDrawTrack() {
        return this.drawTrack;
    }

    public final void setDrawTrack(boolean value) {
        this.drawTrack = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set drawTrack: " + value));
    }

    public final int getTrackColor() {
        return this.trackColor;
    }

    public final void setTrackColor(int value) {
        this.trackColor = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set trackColor: " + value));
    }

    public final float getTrackWidth() {
        return this.trackWidth;
    }

    public final void setTrackWidth(float value) {
        this.trackWidth = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set trackWidth: " + value));
    }

    public final int getTrackAlpha() {
        return this.trackAlpha;
    }

    public final void setTrackAlpha(int value) {
        this.trackAlpha = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set trackAlpha: " + value));
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(float value) {
        this.strokeWidth = value;
        this.regenerateStrokeShader();
        this.postInvalidate();
        Log.d((String)TAG, (String)("set strokeWidth: " + value));
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        if (!this.isAnimating) {
            this.progress = value;
            this._progress = value;
            this.postInvalidate();
            Log.d((String)TAG, (String)("set progress: " + value));
        } else {
            Log.d((String)TAG, (String)"can't set progress when animating");
        }
    }

    public final int getStartingAngle() {
        return this.startingAngle;
    }

    public final void setStartingAngle(int value) {
        this.startingAngle = value % 360;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set startingAngle: " + value));
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.direction = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set direction: " + (Object)((Object)value)));
    }

    public final boolean getTextEnabled() {
        return this.textEnabled;
    }

    public final void setTextEnabled(boolean value) {
        this.textEnabled = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textEnabled: " + value));
    }

    public final float getTextSize() {
        return this.textSize;
    }

    public final void setTextSize(float value) {
        this.textSize = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textSize: " + value));
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int value) {
        this.textColor = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textColor: " + value));
    }

    public final int getTextGradientStartColor() {
        return this.textGradientStartColor;
    }

    public final void setTextGradientStartColor(int value) {
        this.textGradientStartColor = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textGradientStart: " + value));
    }

    public final int getTextGradientCenterColor() {
        return this.textGradientCenterColor;
    }

    public final void setTextGradientCenterColor(int value) {
        this.textGradientCenterColor = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textGradientCenter: " + value));
    }

    public final int getTextGradientEndColor() {
        return this.textGradientEndColor;
    }

    public final void setTextGradientEndColor(int value) {
        this.textGradientEndColor = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textGradientEnd: " + value));
    }

    @NotNull
    public final Gradient getTextGradientStyle() {
        return this.textGradientStyle;
    }

    public final void setTextGradientStyle(@NotNull Gradient value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.textGradientStyle = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textGradientStyle: " + (Object)((Object)value)));
    }

    public final int getTextGradientLinearAngle() {
        return this.textGradientLinearAngle;
    }

    public final void setTextGradientLinearAngle(int value) {
        this.textGradientLinearAngle = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textGradientLinearAngle: " + value));
    }

    @NotNull
    public final TextGradient getTextGradientSize() {
        return this.textGradientSize;
    }

    public final void setTextGradientSize(@NotNull TextGradient value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.textGradientSize = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textGradientSize: " + (Object)((Object)value)));
    }

    @NotNull
    public final TextFormat getTextFormat() {
        return this.textFormat;
    }

    public final void setTextFormat(@NotNull TextFormat value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.textFormat = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set textFormat: " + (Object)((Object)value)));
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        this.text = value;
        this.postInvalidate();
        Log.d((String)TAG, (String)("set text: " + value));
    }

    public final long getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(long l) {
        this.animationDuration = l;
    }

    @NotNull
    public final BaseInterpolator getAnimationInterpolator() {
        return this.animationInterpolator;
    }

    public final void setAnimationInterpolator(@NotNull BaseInterpolator baseInterpolator) {
        Intrinsics.checkParameterIsNotNull((Object)baseInterpolator, (String)"<set-?>");
        this.animationInterpolator = baseInterpolator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray attrs = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.CircularProgressView, 0, 0);
        try {
            TextFormat textFormat;
            Gradient gradient;
            Gradient gradient2;
            this.setMaxValue(attrs.getFloat(R.styleable.CircularProgressView_maxValue, this.DEFAULT_MAX_VALUE));
            this.setStrokeWidth(attrs.getDimension(R.styleable.CircularProgressView_strokeWidth, this.DEFAULT_STROKE_WIDTH));
            this.setStrokeColor(attrs.getColor(R.styleable.CircularProgressView_strokeColor, this.DEFAULT_STROKE_COLOR));
            this.setDrawTrack(attrs.getBoolean(R.styleable.CircularProgressView_drawTrack, this.DEFAULT_DRAW_TRACK));
            this.setTrackWidth(attrs.getFloat(R.styleable.CircularProgressView_trackWidth, this.DEFAULT_STROKE_WIDTH / (float)2));
            this.setTrackAlpha(attrs.getInt(R.styleable.CircularProgressView_trackAlpha, -1));
            this.setGradientStartColor(attrs.getColor(R.styleable.CircularProgressView_gradientStartColor, 0));
            this.setGradientCenterColor(attrs.getColor(R.styleable.CircularProgressView_gradientCenterColor, 0));
            this.setGradientEndColor(attrs.getColor(R.styleable.CircularProgressView_gradientEndColor, 0));
            switch (attrs.getInt(R.styleable.CircularProgressView_strokeGradientStyle, 0)) {
                case 1: {
                    gradient2 = Gradient.STYLE_LINEAR;
                    break;
                }
                case 2: {
                    gradient2 = Gradient.STYLE_RADIAL;
                    break;
                }
                default: {
                    gradient2 = Gradient.STYLE_SWEEP;
                }
            }
            this.setStrokeGradientStyle(gradient2);
            this.setStrokeGradientLinearAngle(attrs.getInt(R.styleable.CircularProgressView_strokeGradient_linearAngle, 0));
            this.setStrokeGradientSize(attrs.getInt(R.styleable.CircularProgressView_strokeGradientSize, 1) == 1 ? StrokeGradient.STROKE_ONLY : StrokeGradient.VIEW);
            this.setProgress(attrs.getFloat(R.styleable.CircularProgressView_progress, this.DEFAULT_MAX_VALUE));
            this.setStartingAngle(attrs.getInt(R.styleable.CircularProgressView_startingAngle, this.DEFAULT_STARTING_ANGLE) % 360);
            this.setText(attrs.getString(R.styleable.CircularProgressView_text));
            CharSequence charSequence = this.text;
            int n = R.styleable.CircularProgressView_textEnabled;
            TypedArray typedArray = attrs;
            CircularProgressView circularProgressView = this;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = charSequence == null || charSequence.length() == 0;
            circularProgressView.setTextEnabled(typedArray.getBoolean(n, !bl3));
            this.setTextColor(attrs.getColor(R.styleable.CircularProgressView_textColor, this.DEFAULT_TEXT_COLOR));
            this.setTextGradientStartColor(attrs.getColor(R.styleable.CircularProgressView_textGradientStartColor, 0));
            this.setTextGradientCenterColor(attrs.getColor(R.styleable.CircularProgressView_textGradientCenterColor, 0));
            this.setTextGradientEndColor(attrs.getColor(R.styleable.CircularProgressView_textGradientEndColor, 0));
            switch (attrs.getInt(R.styleable.CircularProgressView_textGradientStyle, 0)) {
                case 1: {
                    gradient = Gradient.STYLE_LINEAR;
                    break;
                }
                case 2: {
                    gradient = Gradient.STYLE_RADIAL;
                    break;
                }
                default: {
                    gradient = Gradient.STYLE_SWEEP;
                }
            }
            this.setTextGradientStyle(gradient);
            this.setTextGradientLinearAngle(attrs.getInt(R.styleable.CircularProgressView_textGradient_linearAngle, 0));
            this.setTextGradientSize(attrs.getInt(R.styleable.CircularProgressView_textGradientSize, 1) == 1 ? TextGradient.TEXT_ONLY : TextGradient.VIEW);
            this.setTextSize(attrs.getDimension(R.styleable.CircularProgressView_textSize, this.DEFAULT_TEXT_SIZE));
            switch (attrs.getInt(R.styleable.CircularProgressView_textFormat, 0)) {
                case 1: {
                    textFormat = TextFormat.DECIMAL_PERCENT;
                    break;
                }
                case 2: {
                    textFormat = TextFormat.FLOAT;
                    break;
                }
                case 3: {
                    textFormat = TextFormat.INT;
                    break;
                }
                default: {
                    textFormat = TextFormat.PERCENT;
                }
            }
            this.setTextFormat(textFormat);
            this.setDirection(attrs.getInt(R.styleable.CircularProgressView_direction, 0) == 0 ? Direction.CW : Direction.CCW);
            this.animationDuration = attrs.getInt(R.styleable.CircularProgressView_progressAnimationDuration, (int)this.DEFAULT_ANIMATION_DURATION);
            this.animationInterpolator = interpolators[attrs.getInt(R.styleable.CircularProgressView_animationInterpolator, this.DEFAULT_INTERPOLATOR_IDX)];
        }
        finally {
            attrs.recycle();
        }
        this.determineGradientStatus();
        if (this.strokeGradientMode) {
            this.regenerateStrokeShader();
        }
        if (this.textGradientMode) {
            this.regenerateTextShader();
        }
    }

    private final void determineGradientStatus() {
        this.strokeGradientMode = this.gradientStartColor != 0 && this.gradientEndColor != 0;
        this.textGradientMode = this.textGradientStartColor != 0 && this.textGradientEndColor != 0;
    }

    private final Pair<int[], float[]> determineGradientDetails(int start, int center, int end, Gradient style) {
        Pair pair;
        if (center == 0) {
            int[] nArray;
            int computedCenter = this.computeMiddleColor(start, end);
            if (style == Gradient.STYLE_SWEEP) {
                int[] nArray2 = new int[4];
                nArray2[0] = computedCenter;
                nArray2[1] = end;
                nArray2[2] = start;
                nArray = nArray2;
                nArray2[3] = computedCenter;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = start;
                nArray = nArray3;
                nArray3[1] = end;
            }
            pair = new Pair((Object)nArray, (Object)this.halfGradientPositions);
        } else {
            int[] nArray;
            if (style == Gradient.STYLE_SWEEP) {
                int[] nArray4 = new int[6];
                nArray4[0] = start;
                nArray4[1] = center;
                nArray4[2] = center;
                nArray4[3] = end;
                nArray4[4] = end;
                nArray = nArray4;
                nArray4[5] = start;
            } else {
                int[] nArray5 = new int[3];
                nArray5[0] = start;
                nArray5[1] = center;
                nArray = nArray5;
                nArray5[2] = end;
            }
            pair = new Pair((Object)nArray, (Object)this.thirdsGradientPositions);
        }
        return pair;
    }

    private final float[] computeStrokeRadialPositions(float strokeEnd, float strokeWidth, int[] colors) {
        float[] fArray;
        if (this.strokeGradientSize == StrokeGradient.VIEW) {
            return null;
        }
        float colorStart = strokeEnd - strokeWidth;
        float strokeCenter = strokeWidth / (float)2;
        if (colors.length == 3) {
            float[] fArray2 = new float[3];
            fArray2[0] = colorStart / strokeEnd;
            fArray2[1] = (colorStart + strokeCenter) / strokeEnd;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = colorStart / strokeEnd;
            fArray = fArray3;
            fArray3[1] = 1.0f;
        }
        return fArray;
    }

    private final float[] computeLinearAngle(int angle, RectF bounds) {
        float[] fArray;
        float xStart = bounds.left;
        float xEnd = bounds.right;
        float yStart = bounds.top;
        float yEnd = bounds.bottom;
        float f = bounds.width();
        float f2 = bounds.height();
        boolean bl = false;
        float md = Math.max(f, f2) / (float)2;
        float c = bounds.centerX();
        switch (angle % 360) {
            case 0: {
                float[] fArray2 = new float[4];
                fArray2[0] = xStart;
                fArray2[1] = yStart;
                fArray2[2] = xEnd;
                fArray = fArray2;
                fArray2[3] = yStart;
                break;
            }
            case 45: {
                float[] fArray3 = new float[4];
                fArray3[0] = c - md;
                fArray3[1] = yStart;
                fArray3[2] = c + md;
                fArray = fArray3;
                fArray3[3] = yEnd;
                break;
            }
            case 90: {
                float[] fArray4 = new float[4];
                fArray4[0] = c;
                fArray4[1] = yStart;
                fArray4[2] = c;
                fArray = fArray4;
                fArray4[3] = yEnd;
                break;
            }
            case 135: {
                float[] fArray5 = new float[4];
                fArray5[0] = c + md;
                fArray5[1] = yStart;
                fArray5[2] = c - md;
                fArray = fArray5;
                fArray5[3] = yEnd;
                break;
            }
            case 180: {
                float[] fArray6 = new float[4];
                fArray6[0] = xEnd;
                fArray6[1] = yStart;
                fArray6[2] = xStart;
                fArray = fArray6;
                fArray6[3] = yStart;
                break;
            }
            case 225: {
                float[] fArray7 = new float[4];
                fArray7[0] = c + md;
                fArray7[1] = yEnd;
                fArray7[2] = c - md;
                fArray = fArray7;
                fArray7[3] = yStart;
                break;
            }
            case 270: {
                float[] fArray8 = new float[4];
                fArray8[0] = c;
                fArray8[1] = yEnd;
                fArray8[2] = c;
                fArray = fArray8;
                fArray8[3] = yStart;
                break;
            }
            case 315: {
                float[] fArray9 = new float[4];
                fArray9[0] = c - md;
                fArray9[1] = yEnd;
                fArray9[2] = c + md;
                fArray = fArray9;
                fArray9[3] = yStart;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Linear Angle " + angle + " not valid"));
                float[] fArray10 = new float[4];
                fArray10[0] = xStart;
                fArray10[1] = yStart;
                fArray10[2] = xEnd;
                fArray = fArray10;
                fArray10[3] = yStart;
            }
        }
        return fArray;
    }

    private final void regenerateStrokeShader() {
        Shader shader;
        if (this.minDimen == 0.0f || !this.strokeGradientMode) {
            return;
        }
        float c = this.minDimen / (float)2;
        Pair<int[], float[]> details = this.determineGradientDetails(this.gradientStartColor, this.gradientCenterColor, this.gradientEndColor, this.strokeGradientStyle);
        switch (CircularProgressView$WhenMappings.$EnumSwitchMapping$0[this.strokeGradientStyle.ordinal()]) {
            case 1: {
                shader = (Shader)new SweepGradient(c, c, (int[])details.getFirst(), (float[])details.getSecond());
                break;
            }
            case 2: {
                float[] points = this.computeLinearAngle(this.strokeGradientLinearAngle, new RectF(0.0f, 0.0f, this.minDimen, this.minDimen));
                shader = (Shader)new LinearGradient(points[0], points[1], points[2], points[3], (int[])details.getFirst(), null, Shader.TileMode.CLAMP);
                break;
            }
            case 3: {
                float end = !this.drawTrack || this.strokeWidth >= this.trackWidth ? c : c - (this.trackWidth - this.strokeWidth) / (float)2;
                float[] positions = this.computeStrokeRadialPositions(end, this.strokeWidth, (int[])details.getFirst());
                shader = (Shader)new RadialGradient(c, c, end, (int[])details.getFirst(), positions, Shader.TileMode.CLAMP);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.strokeShader = shader;
    }

    private final RectF getTextGradientBounds(TextGradient grad) {
        RectF rectF;
        if (grad == TextGradient.VIEW) {
            rectF = new RectF(0.0f, 0.0f, this.minDimen, this.minDimen);
        } else {
            float c = this.minDimen / (float)2;
            rectF = new RectF(c - (float)(this.textBounds.width() / 2), c - (float)(this.textBounds.height() / 2), c + (float)(this.textBounds.width() / 2), c + (float)(this.textBounds.height() / 2));
        }
        return rectF;
    }

    private final void regenerateTextShader() {
        if (this.minDimen == 0.0f) {
            return;
        }
        float c = this.minDimen / (float)2;
        Pair<int[], float[]> details = this.determineGradientDetails(this.textGradientStartColor, this.textGradientCenterColor, this.textGradientEndColor, this.textGradientStyle);
        if (this.textGradientMode) {
            Shader shader;
            CircularProgressView circularProgressView = this;
            switch (CircularProgressView$WhenMappings.$EnumSwitchMapping$1[this.textGradientStyle.ordinal()]) {
                case 1: {
                    shader = (Shader)new SweepGradient(c, c, (int[])details.getFirst(), (float[])details.getSecond());
                    break;
                }
                case 2: {
                    RectF tb = this.getTextGradientBounds(this.textGradientSize);
                    float[] points = this.computeLinearAngle(this.textGradientLinearAngle, tb);
                    shader = (Shader)new LinearGradient(points[0], points[1], points[2], points[3], (int[])details.getFirst(), null, Shader.TileMode.CLAMP);
                    break;
                }
                case 3: {
                    float f;
                    float f2 = c;
                    float f3 = c;
                    if (this.textGradientSize == TextGradient.TEXT_ONLY) {
                        int n = this.textBounds.width() / 2;
                        int n2 = this.textBounds.height() / 2;
                        float f4 = f3;
                        float f5 = f2;
                        CircularProgressView circularProgressView2 = circularProgressView;
                        boolean bl = false;
                        int n3 = Math.max(n, n2);
                        circularProgressView = circularProgressView2;
                        f2 = f5;
                        f3 = f4;
                        f = n3;
                    } else {
                        f = this.minDimen;
                    }
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    float[] fArray = null;
                    int[] nArray = (int[])details.getFirst();
                    float f6 = f;
                    float f7 = f3;
                    float f8 = f2;
                    shader = (Shader)new RadialGradient(f8, f7, f6, nArray, fArray, tileMode);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            circularProgressView.textShader = shader;
        }
    }

    protected void onDraw(@Nullable Canvas canvas) {
        float maxStroke;
        float f;
        boolean bl;
        if (canvas == null) {
            return;
        }
        this.determineGradientStatus();
        int n = this.getWidth();
        int n2 = this.getHeight();
        CircularProgressView circularProgressView = this;
        boolean bl2 = false;
        int n3 = Math.min(n, n2);
        circularProgressView.minDimen = n3;
        this.regenerateStrokeShader();
        Paint paint = this.strokePaint;
        n2 = 0;
        bl2 = false;
        Paint it2 = paint;
        boolean bl32 = false;
        it2.setColor(this.strokeColor);
        it2.setStrokeWidth(this.strokeWidth);
        it2.setShader(this.strokeGradientMode ? this.strokeShader : null);
        float degrees = this._progress / this.maxValue * 360.0f;
        if (this.direction == Direction.CCW) {
            degrees *= (float)-1;
        }
        float startingAngle = -90.0f + (float)this.startingAngle;
        if (this.drawTrack) {
            float it2 = this.strokeWidth;
            float bl32 = this.trackWidth;
            bl = false;
            f = Math.max(it2, bl32);
        } else {
            f = maxStroke = this.strokeWidth;
        }
        if (this.drawTrack) {
            Paint it2 = this.trackPaint;
            boolean bl32 = false;
            bl = false;
            Paint it3 = it2;
            boolean bl4 = false;
            it3.setColor(this.trackColor == 0 ? this.strokeColor : this.trackColor);
            it3.setStrokeWidth(this.trackWidth);
            it3.setAlpha(this.trackAlpha == -1 ? 125 : this.trackAlpha);
            canvas.drawArc(maxStroke / (float)2, maxStroke / (float)2, this.minDimen - maxStroke / (float)2, this.minDimen - maxStroke / (float)2, 0.0f, 360.0f, false, this.trackPaint);
        }
        canvas.drawArc(maxStroke / (float)2, maxStroke / (float)2, this.minDimen - maxStroke / (float)2, this.minDimen - maxStroke / (float)2, startingAngle, degrees, false, this.strokePaint);
        if (this.textEnabled) {
            String string = this.text;
            if (string == null) {
                string = this.formatText();
            }
            String text = string;
            this.textPaint.getTextBounds(text, 0, text.length(), this.textBounds);
            this.textHeight = this.textBounds.height();
            this.textWidth = this.textBounds.width();
            this.regenerateTextShader();
            Paint bl32 = this.textPaint;
            bl = false;
            boolean bl5 = false;
            Paint it4 = bl32;
            boolean bl6 = false;
            it4.setColor(this.textColor);
            it4.setTextSize(this.textSize);
            it4.setShader(this.textGradientMode ? this.textShader : null);
            float c = this.minDimen / (float)2;
            canvas.drawText(text, c, c + (float)(this.textBounds.height() / 2), this.textPaint);
        }
    }

    private final String formatText() {
        String string;
        float percent = this._progress / this.maxValue * (float)100;
        switch (CircularProgressView$WhenMappings.$EnumSwitchMapping$2[this.textFormat.ordinal()]) {
            case 1: {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%3.0f%%";
                Object[] objectArray = new Object[]{Float.valueOf(percent)};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                break;
            }
            case 2: {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string4 = "%3.2f%%";
                Object[] objectArray = new Object[]{Float.valueOf(percent)};
                boolean bl = false;
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                break;
            }
            case 3: {
                string = String.valueOf((int)this._progress);
                break;
            }
            default: {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string6 = "%#.2f";
                Object[] objectArray = new Object[]{Float.valueOf(this._progress)};
                boolean bl = false;
                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                string = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
            }
        }
        return string;
    }

    public final void animateProgressChange(float toValue, long duration) {
        block1: {
            if (this.isAnimating) {
                return;
            }
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this._progress, toValue});
            boolean bl = false;
            boolean bl2 = false;
            ValueAnimator $this$apply = valueAnimator;
            boolean bl3 = false;
            $this$apply.setInterpolator((TimeInterpolator)this.animationInterpolator);
            ValueAnimator valueAnimator2 = $this$apply;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator2, (String)"this");
            valueAnimator2.setDuration(duration);
            $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, duration){
                final /* synthetic */ CircularProgressView this$0;
                final /* synthetic */ long $duration$inlined;
                {
                    this.this$0 = circularProgressView;
                    this.$duration$inlined = l;
                }

                public final void onAnimationUpdate(ValueAnimator it) {
                    block2: {
                        ValueAnimator valueAnimator = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                        Object object = valueAnimator.getAnimatedValue();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                        }
                        CircularProgressView.access$set_progress$p(this.this$0, ((Float)object).floatValue());
                        this.this$0.invalidate();
                        CircularProgressView.access$setAnimating$p(this.this$0, it.getAnimatedFraction() != 1.0f);
                        if (CircularProgressView.access$isAnimating$p(this.this$0)) break block2;
                        Log.d((String)"CircularProgressView", (String)("isAnimating: " + CircularProgressView.access$isAnimating$p(this.this$0)));
                        this.this$0.setProgress(CircularProgressView.access$get_progress$p(this.this$0));
                        DeterminateProgressViewListener determinateProgressViewListener = this.this$0.getAnimationListener();
                        if (determinateProgressViewListener != null) {
                            determinateProgressViewListener.onAnimationEnd();
                        }
                    }
                }
            });
            valueAnimator.start();
            this.isAnimating = true;
            Log.d((String)TAG, (String)("isAnimating: " + this.isAnimating));
            DeterminateProgressViewListener determinateProgressViewListener = this.animationListener;
            if (determinateProgressViewListener == null) break block1;
            determinateProgressViewListener.onAnimationStart(toValue, this._progress);
        }
    }

    public static /* synthetic */ void animateProgressChange$default(CircularProgressView circularProgressView, float f, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = circularProgressView.animationDuration;
        }
        circularProgressView.animateProgressChange(f, l);
    }

    private final int computeMiddleColor(int color1, int color2) {
        int alpha = (Color.alpha((int)color1) + Color.alpha((int)color2)) / 2;
        int red = (Color.red((int)color1) + Color.red((int)color2)) / 2;
        int green = (Color.green((int)color1) + Color.green((int)color2)) / 2;
        int blue = (Color.blue((int)color1) + Color.blue((int)color2)) / 2;
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public CircularProgressView(@NotNull Context context) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.DEFAULT_STROKE_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_SIZE = 100.0f;
        this.DEFAULT_DIRECTION = Direction.CW;
        this.DEFAULT_STROKE_WIDTH = 20.0f;
        this.DEFAULT_DRAW_TRACK = true;
        this.DEFAULT_MAX_VALUE = 100.0f;
        this.DEFAULT_DRAW_TEXT = true;
        this.DEFAULT_TEXT_FORMAT = TextFormat.PERCENT;
        this.DEFAULT_ANIMATION_DURATION = 400L;
        this.DEFAULT_STK_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_STK_GRAD_SIZE = StrokeGradient.STROKE_ONLY;
        this.DEFAULT_TXT_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_TXT_GRAD_SIZE = TextGradient.TEXT_ONLY;
        this.thirdsGradientPositions = new float[]{0.0f, 0.16666667f, 0.33333334f, 0.5f, 0.6666667f, 0.8333333f};
        this.halfGradientPositions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        this._progress = this.DEFAULT_MAX_VALUE;
        Paint paint2 = new Paint();
        CircularProgressView circularProgressView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint it = paint2;
        boolean bl3 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        circularProgressView.strokePaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl4 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        it.setAlpha(0);
        circularProgressView.trackPaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl5 = false;
        it.setFlags(1);
        it.setTextAlign(Paint.Align.CENTER);
        circularProgressView.textPaint = paint = paint2;
        this.textBounds = new Rect();
        this.maxValue = this.DEFAULT_MAX_VALUE;
        this.strokeColor = this.DEFAULT_STROKE_COLOR;
        this.strokeGradientStyle = this.DEFAULT_STK_GRAD_STYLE;
        this.strokeGradientLinearAngle = this.DEFAULT_STK_GRAD_LINEAR_ANGLE;
        this.strokeGradientSize = this.DEFAULT_STK_GRAD_SIZE;
        this.drawTrack = this.DEFAULT_DRAW_TRACK;
        this.trackColor = this.DEFAULT_STROKE_COLOR;
        this.trackWidth = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.trackAlpha = 125;
        this.strokeWidth = this.DEFAULT_STROKE_WIDTH;
        this.progress = this.DEFAULT_MAX_VALUE;
        this.startingAngle = this.DEFAULT_STARTING_ANGLE;
        this.direction = this.DEFAULT_DIRECTION;
        this.textEnabled = this.DEFAULT_DRAW_TEXT;
        this.textSize = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.textColor = this.DEFAULT_STROKE_COLOR;
        this.textGradientStyle = this.DEFAULT_TXT_GRAD_STYLE;
        this.textGradientLinearAngle = this.DEFAULT_TXT_LINEAR_ANGLE;
        this.textGradientSize = this.DEFAULT_TXT_GRAD_SIZE;
        this.textFormat = this.DEFAULT_TEXT_FORMAT;
        this.animationDuration = this.DEFAULT_ANIMATION_DURATION;
        this.animationInterpolator = interpolators[this.DEFAULT_INTERPOLATOR_IDX];
        this.init(null);
    }

    public CircularProgressView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.DEFAULT_STROKE_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_SIZE = 100.0f;
        this.DEFAULT_DIRECTION = Direction.CW;
        this.DEFAULT_STROKE_WIDTH = 20.0f;
        this.DEFAULT_DRAW_TRACK = true;
        this.DEFAULT_MAX_VALUE = 100.0f;
        this.DEFAULT_DRAW_TEXT = true;
        this.DEFAULT_TEXT_FORMAT = TextFormat.PERCENT;
        this.DEFAULT_ANIMATION_DURATION = 400L;
        this.DEFAULT_STK_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_STK_GRAD_SIZE = StrokeGradient.STROKE_ONLY;
        this.DEFAULT_TXT_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_TXT_GRAD_SIZE = TextGradient.TEXT_ONLY;
        this.thirdsGradientPositions = new float[]{0.0f, 0.16666667f, 0.33333334f, 0.5f, 0.6666667f, 0.8333333f};
        this.halfGradientPositions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        this._progress = this.DEFAULT_MAX_VALUE;
        Paint paint2 = new Paint();
        CircularProgressView circularProgressView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint it = paint2;
        boolean bl3 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        circularProgressView.strokePaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl4 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        it.setAlpha(0);
        circularProgressView.trackPaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl5 = false;
        it.setFlags(1);
        it.setTextAlign(Paint.Align.CENTER);
        circularProgressView.textPaint = paint = paint2;
        this.textBounds = new Rect();
        this.maxValue = this.DEFAULT_MAX_VALUE;
        this.strokeColor = this.DEFAULT_STROKE_COLOR;
        this.strokeGradientStyle = this.DEFAULT_STK_GRAD_STYLE;
        this.strokeGradientLinearAngle = this.DEFAULT_STK_GRAD_LINEAR_ANGLE;
        this.strokeGradientSize = this.DEFAULT_STK_GRAD_SIZE;
        this.drawTrack = this.DEFAULT_DRAW_TRACK;
        this.trackColor = this.DEFAULT_STROKE_COLOR;
        this.trackWidth = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.trackAlpha = 125;
        this.strokeWidth = this.DEFAULT_STROKE_WIDTH;
        this.progress = this.DEFAULT_MAX_VALUE;
        this.startingAngle = this.DEFAULT_STARTING_ANGLE;
        this.direction = this.DEFAULT_DIRECTION;
        this.textEnabled = this.DEFAULT_DRAW_TEXT;
        this.textSize = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.textColor = this.DEFAULT_STROKE_COLOR;
        this.textGradientStyle = this.DEFAULT_TXT_GRAD_STYLE;
        this.textGradientLinearAngle = this.DEFAULT_TXT_LINEAR_ANGLE;
        this.textGradientSize = this.DEFAULT_TXT_GRAD_SIZE;
        this.textFormat = this.DEFAULT_TEXT_FORMAT;
        this.animationDuration = this.DEFAULT_ANIMATION_DURATION;
        this.animationInterpolator = interpolators[this.DEFAULT_INTERPOLATOR_IDX];
        this.init(attributeSet);
    }

    public CircularProgressView(@NotNull Context context, @NotNull AttributeSet attributeSet, int defStyleAttr) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet, defStyleAttr);
        this.DEFAULT_STROKE_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_SIZE = 100.0f;
        this.DEFAULT_DIRECTION = Direction.CW;
        this.DEFAULT_STROKE_WIDTH = 20.0f;
        this.DEFAULT_DRAW_TRACK = true;
        this.DEFAULT_MAX_VALUE = 100.0f;
        this.DEFAULT_DRAW_TEXT = true;
        this.DEFAULT_TEXT_FORMAT = TextFormat.PERCENT;
        this.DEFAULT_ANIMATION_DURATION = 400L;
        this.DEFAULT_STK_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_STK_GRAD_SIZE = StrokeGradient.STROKE_ONLY;
        this.DEFAULT_TXT_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_TXT_GRAD_SIZE = TextGradient.TEXT_ONLY;
        this.thirdsGradientPositions = new float[]{0.0f, 0.16666667f, 0.33333334f, 0.5f, 0.6666667f, 0.8333333f};
        this.halfGradientPositions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        this._progress = this.DEFAULT_MAX_VALUE;
        Paint paint2 = new Paint();
        CircularProgressView circularProgressView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint it = paint2;
        boolean bl3 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        circularProgressView.strokePaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl4 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        it.setAlpha(0);
        circularProgressView.trackPaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl5 = false;
        it.setFlags(1);
        it.setTextAlign(Paint.Align.CENTER);
        circularProgressView.textPaint = paint = paint2;
        this.textBounds = new Rect();
        this.maxValue = this.DEFAULT_MAX_VALUE;
        this.strokeColor = this.DEFAULT_STROKE_COLOR;
        this.strokeGradientStyle = this.DEFAULT_STK_GRAD_STYLE;
        this.strokeGradientLinearAngle = this.DEFAULT_STK_GRAD_LINEAR_ANGLE;
        this.strokeGradientSize = this.DEFAULT_STK_GRAD_SIZE;
        this.drawTrack = this.DEFAULT_DRAW_TRACK;
        this.trackColor = this.DEFAULT_STROKE_COLOR;
        this.trackWidth = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.trackAlpha = 125;
        this.strokeWidth = this.DEFAULT_STROKE_WIDTH;
        this.progress = this.DEFAULT_MAX_VALUE;
        this.startingAngle = this.DEFAULT_STARTING_ANGLE;
        this.direction = this.DEFAULT_DIRECTION;
        this.textEnabled = this.DEFAULT_DRAW_TEXT;
        this.textSize = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.textColor = this.DEFAULT_STROKE_COLOR;
        this.textGradientStyle = this.DEFAULT_TXT_GRAD_STYLE;
        this.textGradientLinearAngle = this.DEFAULT_TXT_LINEAR_ANGLE;
        this.textGradientSize = this.DEFAULT_TXT_GRAD_SIZE;
        this.textFormat = this.DEFAULT_TEXT_FORMAT;
        this.animationDuration = this.DEFAULT_ANIMATION_DURATION;
        this.animationInterpolator = interpolators[this.DEFAULT_INTERPOLATOR_IDX];
        this.init(attributeSet);
    }

    public CircularProgressView(@NotNull Context context, @NotNull AttributeSet attributeSet, int defStyleAttr, int defStyleRes) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet, defStyleAttr, defStyleRes);
        this.DEFAULT_STROKE_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_COLOR = ContextCompat.getColor((Context)this.getContext(), (int)R.color.teal);
        this.DEFAULT_TEXT_SIZE = 100.0f;
        this.DEFAULT_DIRECTION = Direction.CW;
        this.DEFAULT_STROKE_WIDTH = 20.0f;
        this.DEFAULT_DRAW_TRACK = true;
        this.DEFAULT_MAX_VALUE = 100.0f;
        this.DEFAULT_DRAW_TEXT = true;
        this.DEFAULT_TEXT_FORMAT = TextFormat.PERCENT;
        this.DEFAULT_ANIMATION_DURATION = 400L;
        this.DEFAULT_STK_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_STK_GRAD_SIZE = StrokeGradient.STROKE_ONLY;
        this.DEFAULT_TXT_GRAD_STYLE = Gradient.STYLE_SWEEP;
        this.DEFAULT_TXT_GRAD_SIZE = TextGradient.TEXT_ONLY;
        this.thirdsGradientPositions = new float[]{0.0f, 0.16666667f, 0.33333334f, 0.5f, 0.6666667f, 0.8333333f};
        this.halfGradientPositions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
        this._progress = this.DEFAULT_MAX_VALUE;
        Paint paint2 = new Paint();
        CircularProgressView circularProgressView = this;
        boolean bl = false;
        boolean bl2 = false;
        Paint it = paint2;
        boolean bl3 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        circularProgressView.strokePaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl4 = false;
        it.setStyle(Paint.Style.STROKE);
        it.setStrokeCap(Paint.Cap.BUTT);
        it.setFlags(1);
        it.setAlpha(0);
        circularProgressView.trackPaint = paint = paint2;
        paint2 = new Paint();
        circularProgressView = this;
        bl = false;
        bl2 = false;
        it = paint2;
        boolean bl5 = false;
        it.setFlags(1);
        it.setTextAlign(Paint.Align.CENTER);
        circularProgressView.textPaint = paint = paint2;
        this.textBounds = new Rect();
        this.maxValue = this.DEFAULT_MAX_VALUE;
        this.strokeColor = this.DEFAULT_STROKE_COLOR;
        this.strokeGradientStyle = this.DEFAULT_STK_GRAD_STYLE;
        this.strokeGradientLinearAngle = this.DEFAULT_STK_GRAD_LINEAR_ANGLE;
        this.strokeGradientSize = this.DEFAULT_STK_GRAD_SIZE;
        this.drawTrack = this.DEFAULT_DRAW_TRACK;
        this.trackColor = this.DEFAULT_STROKE_COLOR;
        this.trackWidth = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.trackAlpha = 125;
        this.strokeWidth = this.DEFAULT_STROKE_WIDTH;
        this.progress = this.DEFAULT_MAX_VALUE;
        this.startingAngle = this.DEFAULT_STARTING_ANGLE;
        this.direction = this.DEFAULT_DIRECTION;
        this.textEnabled = this.DEFAULT_DRAW_TEXT;
        this.textSize = this.DEFAULT_STROKE_WIDTH / (float)2;
        this.textColor = this.DEFAULT_STROKE_COLOR;
        this.textGradientStyle = this.DEFAULT_TXT_GRAD_STYLE;
        this.textGradientLinearAngle = this.DEFAULT_TXT_LINEAR_ANGLE;
        this.textGradientSize = this.DEFAULT_TXT_GRAD_SIZE;
        this.textFormat = this.DEFAULT_TEXT_FORMAT;
        this.animationDuration = this.DEFAULT_ANIMATION_DURATION;
        this.animationInterpolator = interpolators[this.DEFAULT_INTERPOLATOR_IDX];
    }

    static {
        Companion = new Companion(null);
        interpolators = new BaseInterpolator[]{(BaseInterpolator)new DecelerateInterpolator(), (BaseInterpolator)new AccelerateInterpolator(), (BaseInterpolator)new AccelerateDecelerateInterpolator(), (BaseInterpolator)new LinearInterpolator(), (BaseInterpolator)new AnticipateInterpolator(), (BaseInterpolator)new AnticipateOvershootInterpolator(), (BaseInterpolator)new AnticipateOvershootInterpolator()};
    }

    public static final /* synthetic */ float access$get_progress$p(CircularProgressView $this) {
        return $this._progress;
    }

    public static final /* synthetic */ void access$set_progress$p(CircularProgressView $this, float f) {
        $this._progress = f;
    }

    public static final /* synthetic */ boolean access$isAnimating$p(CircularProgressView $this) {
        return $this.isAnimating;
    }

    public static final /* synthetic */ void access$setAnimating$p(CircularProgressView $this, boolean bl) {
        $this.isAnimating = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/owl93/dpb/CircularProgressView$Companion;", "", "()V", "DEFAULT_TRACK_ALPHA", "", "TAG", "", "interpolators", "", "Landroid/view/animation/BaseInterpolator;", "[Landroid/view/animation/BaseInterpolator;", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

