/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.core;

import android.content.Context;
import android.view.View;
import com.lzf.easyfloat.core.FloatingWindowHelper;
import com.lzf.easyfloat.data.FloatConfig;
import com.lzf.easyfloat.interfaces.FloatCallbacks;
import com.lzf.easyfloat.utils.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rJ#\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0017\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004J+\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u000b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/lzf/easyfloat/core/FloatingWindowManager;", "", "()V", "DEFAULT_TAG", "", "windowMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/lzf/easyfloat/core/FloatingWindowHelper;", "getWindowMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "checkTag", "", "config", "Lcom/lzf/easyfloat/data/FloatConfig;", "create", "", "context", "Landroid/content/Context;", "dismiss", "tag", "force", "(Ljava/lang/String;Z)Lkotlin/Unit;", "getHelper", "getTag", "remove", "floatTag", "visible", "isShow", "needShow", "(ZLjava/lang/String;Z)Lkotlin/Unit;", "easyfloat_release"})
public final class FloatingWindowManager {
    @NotNull
    public static final FloatingWindowManager INSTANCE = new FloatingWindowManager();
    @NotNull
    private static final String DEFAULT_TAG = "default";
    @NotNull
    private static final ConcurrentHashMap<String, FloatingWindowHelper> windowMap = new ConcurrentHashMap();

    private FloatingWindowManager() {
    }

    @NotNull
    public final ConcurrentHashMap<String, FloatingWindowHelper> getWindowMap() {
        return windowMap;
    }

    public final void create(@NotNull Context context, @NotNull FloatConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.checkTag(config)) {
            FloatingWindowHelper helper = new FloatingWindowHelper(context, config);
            helper.createWindow(new FloatingWindowHelper.CreateCallback(config, helper){
                final /* synthetic */ FloatConfig $config;
                final /* synthetic */ FloatingWindowHelper $helper;
                {
                    this.$config = $config;
                    this.$helper = $helper;
                }

                public void onCreate(boolean success) {
                    if (success) {
                        Map map = FloatingWindowManager.INSTANCE.getWindowMap();
                        String string = this.$config.getFloatTag();
                        Intrinsics.checkNotNull((Object)string);
                        String string2 = string;
                        FloatingWindowHelper floatingWindowHelper = this.$helper;
                        boolean bl = false;
                        map.put(string2, floatingWindowHelper);
                    }
                }
            });
        } else {
            Function3<Boolean, String, View, Unit> function3;
            FloatCallbacks.Builder builder;
            Object object = config.getCallbacks();
            if (object != null) {
                object.createdResult(false, "Tag exception. You need to set different EasyFloat tag.", null);
            }
            object = config.getFloatCallbacks();
            if (object != null && (builder = ((FloatCallbacks)object).getBuilder()) != null && (function3 = builder.getCreatedResult$easyfloat_release()) != null) {
                function3.invoke((Object)false, (Object)"Tag exception. You need to set different EasyFloat tag.", null);
            }
            Logger.INSTANCE.w("Tag exception. You need to set different EasyFloat tag.");
        }
    }

    @Nullable
    public final Unit dismiss(@Nullable String tag, boolean force) {
        Unit unit;
        FloatingWindowHelper floatingWindowHelper = this.getHelper(tag);
        if (floatingWindowHelper == null) {
            unit = null;
        } else {
            FloatingWindowHelper floatingWindowHelper2 = floatingWindowHelper;
            boolean bl = false;
            boolean bl2 = false;
            FloatingWindowHelper $this$dismiss_u24lambda_u2d0 = floatingWindowHelper2;
            boolean bl3 = false;
            if (force) {
                $this$dismiss_u24lambda_u2d0.remove(force);
            } else {
                $this$dismiss_u24lambda_u2d0.exitAnim();
            }
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    public static /* synthetic */ Unit dismiss$default(FloatingWindowManager floatingWindowManager, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return floatingWindowManager.dismiss(string, bl);
    }

    @Nullable
    public final FloatingWindowHelper remove(@Nullable String floatTag) {
        return windowMap.remove(this.getTag(floatTag));
    }

    @Nullable
    public final Unit visible(boolean isShow, @Nullable String tag, boolean needShow) {
        Unit unit;
        FloatingWindowHelper floatingWindowHelper = this.getHelper(tag);
        if (floatingWindowHelper == null) {
            unit = null;
        } else {
            floatingWindowHelper.setVisible(isShow ? 0 : 8, needShow);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    public static /* synthetic */ Unit visible$default(FloatingWindowManager floatingWindowManager, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            Object object2 = windowMap;
            boolean bl3 = false;
            FloatingWindowHelper floatingWindowHelper = (FloatingWindowHelper)object2.get(string);
            bl2 = floatingWindowHelper == null ? true : ((object2 = floatingWindowHelper.getConfig()) == null ? true : (bl3 = ((FloatConfig)object2).getNeedShow$easyfloat_release()));
        }
        return floatingWindowManager.visible(bl, string, bl2);
    }

    private final boolean checkTag(FloatConfig config) {
        config.setFloatTag(this.getTag(config.getFloatTag()));
        String string = config.getFloatTag();
        Intrinsics.checkNotNull((Object)string);
        return windowMap.containsKey(string);
    }

    private final String getTag(String tag) {
        String string = tag;
        return string == null ? DEFAULT_TAG : string;
    }

    @Nullable
    public final FloatingWindowHelper getHelper(@Nullable String tag) {
        return windowMap.get(this.getTag(tag));
    }
}

