/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.utils;

import android.content.Context;
import android.view.MotionEvent;
import com.lzf.easyfloat.EasyFloat;
import com.lzf.easyfloat.R;
import com.lzf.easyfloat.anim.DefaultAnimator;
import com.lzf.easyfloat.enums.ShowPattern;
import com.lzf.easyfloat.enums.SidePattern;
import com.lzf.easyfloat.interfaces.FloatCallbacks;
import com.lzf.easyfloat.interfaces.OnFloatAnimator;
import com.lzf.easyfloat.interfaces.OnTouchRangeListener;
import com.lzf.easyfloat.utils.DisplayUtils;
import com.lzf.easyfloat.utils.DragUtils;
import com.lzf.easyfloat.utils.LifecycleUtils;
import com.lzf.easyfloat.widget.BaseSwitchView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J<\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007JF\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\n2\b\b\u0002\u0010\u001f\u001a\u00020\nH\u0007J,\u0010 \u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\n2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\"\u0010#\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/lzf/easyfloat/utils/DragUtils;", "", "()V", "ADD_TAG", "", "CLOSE_TAG", "addView", "Lcom/lzf/easyfloat/widget/BaseSwitchView;", "closeView", "downX", "", "offset", "screenWidth", "", "dismissAdd", "", "()Lkotlin/Unit;", "dismissClose", "registerDragClose", "event", "Landroid/view/MotionEvent;", "listener", "Lcom/lzf/easyfloat/interfaces/OnTouchRangeListener;", "layoutId", "showPattern", "Lcom/lzf/easyfloat/enums/ShowPattern;", "appFloatAnimator", "Lcom/lzf/easyfloat/interfaces/OnFloatAnimator;", "registerSwipeAdd", "slideOffset", "start", "end", "setAddView", "progress", "showAdd", "showClose", "easyfloat_release"})
public final class DragUtils {
    @NotNull
    public static final DragUtils INSTANCE = new DragUtils();
    @NotNull
    private static final String ADD_TAG = "ADD_TAG";
    @NotNull
    private static final String CLOSE_TAG = "CLOSE_TAG";
    @Nullable
    private static BaseSwitchView addView;
    @Nullable
    private static BaseSwitchView closeView;
    private static float downX;
    private static int screenWidth;
    private static float offset;

    private DragUtils() {
    }

    @JvmOverloads
    public final void registerSwipeAdd(@Nullable MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId, float slideOffset, float start, float end) {
        if (event == null) {
            return;
        }
        if (!(slideOffset == -1.0f)) {
            if (slideOffset >= start) {
                float f = (slideOffset - start) / (end - start);
                float f2 = 1.0f;
                boolean bl = false;
                float progress = Math.min(f, f2);
                this.setAddView(event, progress, listener, layoutId);
            } else {
                this.dismissAdd();
            }
        } else {
            screenWidth = DisplayUtils.INSTANCE.getScreenWidth((Context)LifecycleUtils.INSTANCE.getApplication());
            offset = event.getRawX() / (float)screenWidth;
            int n = event.getAction();
            switch (n) {
                case 0: {
                    downX = event.getRawX();
                    break;
                }
                case 2: {
                    if (downX < start * (float)screenWidth && offset >= start) {
                        float f = (offset - start) / (end - start);
                        float f3 = 1.0f;
                        boolean bl = false;
                        float progress = Math.min(f, f3);
                        this.setAddView(event, progress, listener, layoutId);
                        break;
                    }
                    this.dismissAdd();
                    break;
                }
                case 1: 
                case 3: {
                    downX = 0.0f;
                    this.setAddView(event, offset, listener, layoutId);
                }
            }
        }
    }

    public static /* synthetic */ void registerSwipeAdd$default(DragUtils dragUtils, MotionEvent motionEvent, OnTouchRangeListener onTouchRangeListener, int n, float f, float f2, float f3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            onTouchRangeListener = null;
        }
        if ((n2 & 4) != 0) {
            n = R.layout.default_add_layout;
        }
        if ((n2 & 8) != 0) {
            f = -1.0f;
        }
        if ((n2 & 0x10) != 0) {
            f2 = 0.1f;
        }
        if ((n2 & 0x20) != 0) {
            f3 = 0.5f;
        }
        dragUtils.registerSwipeAdd(motionEvent, onTouchRangeListener, n, f, f2, f3);
    }

    private final void setAddView(MotionEvent event, float progress, OnTouchRangeListener listener, int layoutId) {
        BaseSwitchView baseSwitchView = addView;
        if (baseSwitchView != null) {
            BaseSwitchView baseSwitchView2 = baseSwitchView;
            boolean bl = false;
            boolean bl2 = false;
            BaseSwitchView it = baseSwitchView2;
            boolean bl3 = false;
            it.setTouchRangeListener(event, listener);
            it.setTranslationX((float)it.getWidth() * (1.0f - progress));
            it.setTranslationY((float)it.getWidth() * (1.0f - progress));
        }
        if (event.getAction() == 1 || event.getAction() == 3) {
            this.dismissAdd();
        } else {
            this.showAdd(layoutId);
        }
    }

    static /* synthetic */ void setAddView$default(DragUtils dragUtils, MotionEvent motionEvent, float f, OnTouchRangeListener onTouchRangeListener, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            onTouchRangeListener = null;
        }
        dragUtils.setAddView(motionEvent, f, onTouchRangeListener, n);
    }

    private final void showAdd(int layoutId) {
        if (EasyFloat.Companion.isShow(ADD_TAG)) {
            return;
        }
        EasyFloat.Builder.setGravity$default(EasyFloat.Builder.setLayout$default(EasyFloat.Companion.with((Context)LifecycleUtils.INSTANCE.getApplication()), layoutId, null, 2, null).setShowPattern(ShowPattern.CURRENT_ACTIVITY).setTag(ADD_TAG).setDragEnable(false).setSidePattern(SidePattern.BOTTOM), 0x800055, 0, 0, 6, null).setAnimator(null).registerCallback((Function1<? super FloatCallbacks.Builder, Unit>)((Function1)showAdd.1.INSTANCE)).show();
    }

    @JvmOverloads
    public final void registerDragClose(@NotNull MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId, @NotNull ShowPattern showPattern, @Nullable OnFloatAnimator appFloatAnimator) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)showPattern), (String)"showPattern");
        this.showClose(layoutId, showPattern, appFloatAnimator);
        BaseSwitchView baseSwitchView = closeView;
        if (baseSwitchView != null) {
            baseSwitchView.setTouchRangeListener(event, listener);
        }
        if (event.getAction() == 1 || event.getAction() == 3) {
            this.dismissClose();
        }
    }

    public static /* synthetic */ void registerDragClose$default(DragUtils dragUtils, MotionEvent motionEvent, OnTouchRangeListener onTouchRangeListener, int n, ShowPattern showPattern, OnFloatAnimator onFloatAnimator, int n2, Object object) {
        if ((n2 & 2) != 0) {
            onTouchRangeListener = null;
        }
        if ((n2 & 4) != 0) {
            n = R.layout.default_close_layout;
        }
        if ((n2 & 8) != 0) {
            showPattern = ShowPattern.CURRENT_ACTIVITY;
        }
        if ((n2 & 0x10) != 0) {
            onFloatAnimator = new DefaultAnimator();
        }
        dragUtils.registerDragClose(motionEvent, onTouchRangeListener, n, showPattern, onFloatAnimator);
    }

    private final void showClose(int layoutId, ShowPattern showPattern, OnFloatAnimator appFloatAnimator) {
        if (EasyFloat.Companion.isShow(CLOSE_TAG)) {
            return;
        }
        EasyFloat.Builder.setGravity$default(EasyFloat.Builder.setMatchParent$default(EasyFloat.Builder.setLayout$default(EasyFloat.Companion.with((Context)LifecycleUtils.INSTANCE.getApplication()), layoutId, null, 2, null).setShowPattern(showPattern), true, false, 2, null).setTag(CLOSE_TAG).setSidePattern(SidePattern.BOTTOM), 80, 0, 0, 6, null).setAnimator(appFloatAnimator).registerCallback((Function1<? super FloatCallbacks.Builder, Unit>)((Function1)showClose.1.INSTANCE)).show();
    }

    private final Unit dismissAdd() {
        return EasyFloat.Companion.dismiss$default(EasyFloat.Companion, ADD_TAG, false, 2, null);
    }

    private final Unit dismissClose() {
        return EasyFloat.Companion.dismiss$default(EasyFloat.Companion, CLOSE_TAG, false, 2, null);
    }

    @JvmOverloads
    public final void registerSwipeAdd(@Nullable MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId, float slideOffset, float start) {
        DragUtils.registerSwipeAdd$default(this, event, listener, layoutId, slideOffset, start, 0.0f, 32, null);
    }

    @JvmOverloads
    public final void registerSwipeAdd(@Nullable MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId, float slideOffset) {
        DragUtils.registerSwipeAdd$default(this, event, listener, layoutId, slideOffset, 0.0f, 0.0f, 48, null);
    }

    @JvmOverloads
    public final void registerSwipeAdd(@Nullable MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId) {
        DragUtils.registerSwipeAdd$default(this, event, listener, layoutId, 0.0f, 0.0f, 0.0f, 56, null);
    }

    @JvmOverloads
    public final void registerSwipeAdd(@Nullable MotionEvent event, @Nullable OnTouchRangeListener listener) {
        DragUtils.registerSwipeAdd$default(this, event, listener, 0, 0.0f, 0.0f, 0.0f, 60, null);
    }

    @JvmOverloads
    public final void registerSwipeAdd(@Nullable MotionEvent event) {
        DragUtils.registerSwipeAdd$default(this, event, null, 0, 0.0f, 0.0f, 0.0f, 62, null);
    }

    @JvmOverloads
    public final void registerDragClose(@NotNull MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId, @NotNull ShowPattern showPattern) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)showPattern), (String)"showPattern");
        DragUtils.registerDragClose$default(this, event, listener, layoutId, showPattern, null, 16, null);
    }

    @JvmOverloads
    public final void registerDragClose(@NotNull MotionEvent event, @Nullable OnTouchRangeListener listener, int layoutId) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DragUtils.registerDragClose$default(this, event, listener, layoutId, null, null, 24, null);
    }

    @JvmOverloads
    public final void registerDragClose(@NotNull MotionEvent event, @Nullable OnTouchRangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DragUtils.registerDragClose$default(this, event, listener, 0, null, null, 28, null);
    }

    @JvmOverloads
    public final void registerDragClose(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DragUtils.registerDragClose$default(this, event, null, 0, null, null, 30, null);
    }

    public static final /* synthetic */ void access$setAddView$p(BaseSwitchView baseSwitchView) {
        addView = baseSwitchView;
    }

    public static final /* synthetic */ void access$setCloseView$p(BaseSwitchView baseSwitchView) {
        closeView = baseSwitchView;
    }
}

