/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.lzf.easyfloat.R;
import com.lzf.easyfloat.interfaces.OnTouchRangeListener;
import com.lzf.easyfloat.utils.DisplayUtils;
import com.lzf.easyfloat.widget.BaseSwitchView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J(\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0014J\u001a\u0010+\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/lzf/easyfloat/widget/DefaultCloseView;", "Lcom/lzf/easyfloat/widget/BaseSwitchView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "height", "", "inRange", "", "inRangeColor", "listener", "Lcom/lzf/easyfloat/interfaces/OnTouchRangeListener;", "normalColor", "paint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "rectF", "Landroid/graphics/RectF;", "region", "Landroid/graphics/Region;", "shapeType", "totalRegion", "width", "zoomSize", "initAttrs", "", "initPaint", "initTouchRange", "event", "Landroid/view/MotionEvent;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "setTouchRangeListener", "easyfloat_release"})
public final class DefaultCloseView
extends BaseSwitchView {
    private int normalColor;
    private int inRangeColor;
    private int shapeType;
    private Paint paint;
    @NotNull
    private Path path;
    private float width;
    private float height;
    @NotNull
    private RectF rectF;
    @NotNull
    private Region region;
    @NotNull
    private final Region totalRegion;
    private boolean inRange;
    private float zoomSize;
    @Nullable
    private OnTouchRangeListener listener;

    @JvmOverloads
    public DefaultCloseView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.normalColor = Color.parseColor((String)"#99000000");
        this.inRangeColor = Color.parseColor((String)"#99FF0000");
        this.path = new Path();
        this.rectF = new RectF();
        this.region = new Region();
        this.totalRegion = new Region();
        this.zoomSize = DisplayUtils.INSTANCE.dp2px(context, 4.0f);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet $this$_init__u24lambda_u2d0 = attributeSet2;
            boolean bl3 = false;
            this.initAttrs($this$_init__u24lambda_u2d0);
        }
        this.initPaint();
        this.setWillNotDraw(false);
    }

    public /* synthetic */ DefaultCloseView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.DefaultCloseView, 0, 0);
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$initAttrs_u24lambda_u2d1 = typedArray;
        boolean bl3 = false;
        this.normalColor = $this$initAttrs_u24lambda_u2d1.getColor(R.styleable.DefaultCloseView_normalColor, this.normalColor);
        this.inRangeColor = $this$initAttrs_u24lambda_u2d1.getColor(R.styleable.DefaultCloseView_inRangeColor, this.inRangeColor);
        this.shapeType = $this$initAttrs_u24lambda_u2d1.getInt(R.styleable.DefaultCloseView_closeShapeType, this.shapeType);
        this.zoomSize = $this$initAttrs_u24lambda_u2d1.getDimension(R.styleable.DefaultCloseView_zoomSize, this.zoomSize);
        typedArray.recycle();
    }

    /*
     * WARNING - void declaration
     */
    private final void initPaint() {
        void $this$initPaint_u24lambda_u2d2;
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        DefaultCloseView defaultCloseView = this;
        boolean bl3 = false;
        $this$initPaint_u24lambda_u2d2.setColor(this.normalColor);
        $this$initPaint_u24lambda_u2d2.setStrokeWidth(10.0f);
        $this$initPaint_u24lambda_u2d2.setStyle(Paint.Style.FILL);
        $this$initPaint_u24lambda_u2d2.setAntiAlias(true);
        Unit unit = Unit.INSTANCE;
        defaultCloseView.paint = paint;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.width = w;
        this.height = h;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        int n;
        this.path.reset();
        if (this.inRange) {
            Paint paint;
            Paint paint2 = this.paint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint = null;
            } else {
                paint = paint2;
            }
            paint.setColor(this.inRangeColor);
            n = this.shapeType;
            switch (n) {
                case 0: {
                    this.rectF.set((float)this.getPaddingLeft(), 0.0f, this.width - (float)this.getPaddingRight(), this.height * (float)2);
                    this.path.addOval(this.rectF, Path.Direction.CW);
                    break;
                }
                case 1: {
                    this.rectF.set((float)this.getPaddingLeft(), 0.0f, this.width - (float)this.getPaddingRight(), this.height);
                    this.path.addRect(this.rectF, Path.Direction.CW);
                    break;
                }
                case 2: {
                    this.path.addCircle(this.width / (float)2, this.height, this.height, Path.Direction.CW);
                }
            }
        } else {
            Paint paint;
            Paint paint3 = this.paint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint = null;
            } else {
                paint = paint3;
            }
            paint.setColor(this.normalColor);
            n = this.shapeType;
            switch (n) {
                case 0: {
                    this.rectF.set((float)this.getPaddingLeft() + this.zoomSize, this.zoomSize, this.width - (float)this.getPaddingRight() - this.zoomSize, (this.height - this.zoomSize) * (float)2);
                    this.path.addOval(this.rectF, Path.Direction.CW);
                    this.totalRegion.set(this.getPaddingLeft() + (int)this.zoomSize, (int)this.zoomSize, (int)(this.width - (float)this.getPaddingRight() - this.zoomSize), (int)this.height);
                    break;
                }
                case 1: {
                    this.rectF.set((float)this.getPaddingLeft(), this.zoomSize, this.width - (float)this.getPaddingRight(), this.height);
                    this.path.addRect(this.rectF, Path.Direction.CW);
                    this.totalRegion.set(this.getPaddingLeft(), (int)this.zoomSize, (int)this.width - this.getPaddingRight(), (int)this.height);
                    break;
                }
                case 2: {
                    this.path.addCircle(this.width / (float)2, this.height, this.height - this.zoomSize, Path.Direction.CW);
                    this.totalRegion.set(0, (int)this.zoomSize, (int)this.width, (int)this.height);
                }
            }
            this.region.setPath(this.path, this.totalRegion);
        }
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            Paint paint;
            Paint paint4 = this.paint;
            if (paint4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint = null;
            } else {
                paint = paint4;
            }
            canvas2.drawPath(this.path, paint);
        }
        super.onDraw(canvas);
    }

    @Override
    public void setTouchRangeListener(@NotNull MotionEvent event, @Nullable OnTouchRangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.listener = listener;
        this.initTouchRange(event);
    }

    private final boolean initTouchRange(MotionEvent event) {
        OnTouchRangeListener onTouchRangeListener;
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        boolean currentInRange = this.region.contains((int)event.getRawX() - location[0], (int)event.getRawY() - location[1]);
        if (currentInRange != this.inRange) {
            this.inRange = currentInRange;
            this.invalidate();
        }
        if ((onTouchRangeListener = this.listener) != null) {
            onTouchRangeListener.touchInRange(currentInRange, this);
        }
        if (event.getAction() == 1 && currentInRange && (onTouchRangeListener = this.listener) != null) {
            onTouchRangeListener.touchUpInRange();
        }
        return currentInRange;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
    }

    @JvmOverloads
    public DefaultCloseView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DefaultCloseView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

