/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.collect;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

final class SortedLists {
    public static <E, K extends Comparable> int binarySearch(List<E> list, Function<? super E, K> function, K k, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        return SortedLists.binarySearch(list, function, k, Ordering.natural(), keyPresentBehavior, keyAbsentBehavior);
    }

    public static <E, K> int binarySearch(List<E> list, Function<? super E, K> function, K k, Comparator<? super K> comparator, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        return SortedLists.binarySearch(Lists.transform(list, function), k, comparator, keyPresentBehavior, keyAbsentBehavior);
    }

    public static <E> int binarySearch(List<? extends E> list, E e, Comparator<? super E> comparator, KeyPresentBehavior keyPresentBehavior, KeyAbsentBehavior keyAbsentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull(keyPresentBehavior);
        Preconditions.checkNotNull(keyAbsentBehavior);
        if (!(list instanceof RandomAccess)) {
            list = Lists.newArrayList(list);
        }
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            int n4 = comparator.compare(e, list.get(n3));
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n + keyPresentBehavior.resultIndex(comparator, e, list.subList(n, n2 + 1), n3 - n);
        }
        return keyAbsentBehavior.resultIndex(n);
    }

    public static abstract class KeyAbsentBehavior
    extends Enum<KeyAbsentBehavior> {
        public static final /* enum */ KeyAbsentBehavior NEXT_LOWER = new KeyAbsentBehavior(){

            @Override
            int resultIndex(int n) {
                return n - 1;
            }
        };
        public static final /* enum */ KeyAbsentBehavior NEXT_HIGHER = new KeyAbsentBehavior(){

            @Override
            public int resultIndex(int n) {
                return n;
            }
        };
        public static final /* enum */ KeyAbsentBehavior INVERTED_INSERTION_INDEX = new KeyAbsentBehavior(){

            @Override
            public int resultIndex(int n) {
                return ~n;
            }
        };
        private static final /* synthetic */ KeyAbsentBehavior[] $VALUES;

        abstract int resultIndex(int var1);

        static {
            $VALUES = new KeyAbsentBehavior[]{NEXT_LOWER, NEXT_HIGHER, INVERTED_INSERTION_INDEX};
        }
    }

    public static abstract class KeyPresentBehavior
    extends Enum<KeyPresentBehavior> {
        public static final /* enum */ KeyPresentBehavior ANY_PRESENT = new KeyPresentBehavior(){

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E e, List<? extends E> list, int n) {
                return n;
            }
        };
        public static final /* enum */ KeyPresentBehavior LAST_PRESENT = new KeyPresentBehavior(){

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E e, List<? extends E> list, int n) {
                int n2 = n;
                int n3 = list.size() - 1;
                while (n2 < n3) {
                    int n4 = n2 + n3 + 1 >>> 1;
                    int n5 = comparator.compare(list.get(n4), e);
                    if (n5 > 0) {
                        n3 = n4 - 1;
                        continue;
                    }
                    n2 = n4;
                }
                return n2;
            }
        };
        public static final /* enum */ KeyPresentBehavior FIRST_PRESENT = new KeyPresentBehavior(){

            @Override
            <E> int resultIndex(Comparator<? super E> comparator, E e, List<? extends E> list, int n) {
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int n4 = n2 + n3 >>> 1;
                    int n5 = comparator.compare(list.get(n4), e);
                    if (n5 < 0) {
                        n2 = n4 + 1;
                        continue;
                    }
                    n3 = n4;
                }
                return n2;
            }
        };
        public static final /* enum */ KeyPresentBehavior FIRST_AFTER = new KeyPresentBehavior(){

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, E e, List<? extends E> list, int n) {
                return LAST_PRESENT.resultIndex(comparator, e, list, n) + 1;
            }
        };
        public static final /* enum */ KeyPresentBehavior LAST_BEFORE = new KeyPresentBehavior(){

            @Override
            public <E> int resultIndex(Comparator<? super E> comparator, E e, List<? extends E> list, int n) {
                return FIRST_PRESENT.resultIndex(comparator, e, list, n) - 1;
            }
        };
        private static final /* synthetic */ KeyPresentBehavior[] $VALUES;

        abstract <E> int resultIndex(Comparator<? super E> var1, E var2, List<? extends E> var3, int var4);

        static {
            $VALUES = new KeyPresentBehavior[]{ANY_PRESENT, LAST_PRESENT, FIRST_PRESENT, FIRST_AFTER, LAST_BEFORE};
        }
    }
}

