/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.AccessFlags;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import java.util.Collection;

public final class MethodUtil {
    private static int directMask = AccessFlags.STATIC.getValue() | AccessFlags.PRIVATE.getValue() | AccessFlags.CONSTRUCTOR.getValue();
    public static Predicate<Method> METHOD_IS_DIRECT = new Predicate<Method>(){

        @Override
        public boolean apply(Method method) {
            return method != null && MethodUtil.isDirect(method);
        }
    };
    public static Predicate<Method> METHOD_IS_VIRTUAL = new Predicate<Method>(){

        @Override
        public boolean apply(Method method) {
            return method != null && !MethodUtil.isDirect(method);
        }
    };

    public static boolean isDirect(Method method) {
        return (method.getAccessFlags() & directMask) != 0;
    }

    public static int getParameterRegisterCount(MethodReference methodReference, boolean bl) {
        return MethodUtil.getParameterRegisterCount(methodReference.getParameterTypes(), bl);
    }

    public static int getParameterRegisterCount(Collection<? extends CharSequence> collection, boolean bl) {
        int n = 0;
        for (CharSequence charSequence : collection) {
            char c = charSequence.charAt(0);
            if (c == 'J' || c == 'D') {
                n += 2;
                continue;
            }
            ++n;
        }
        if (!bl) {
            ++n;
        }
        return n;
    }

    private static char getShortyType(CharSequence charSequence) {
        if (charSequence.length() > 1) {
            return 'L';
        }
        return charSequence.charAt(0);
    }

    public static String getShorty(Collection<? extends CharSequence> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder(collection.size() + 1);
        stringBuilder.append(MethodUtil.getShortyType(string));
        for (CharSequence charSequence : collection) {
            stringBuilder.append(MethodUtil.getShortyType(charSequence));
        }
        return stringBuilder.toString();
    }
}

