/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.util.Hex;

public final class Utf8Utils {
    private static final ThreadLocal<char[]> localBuffer = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };

    public static String utf8BytesWithUtf16LengthToString(byte[] byArray, int n, int n2, int[] nArray) {
        char[] cArray = localBuffer.get();
        if (cArray == null || cArray.length < n2) {
            cArray = new char[n2];
            localBuffer.set(cArray);
        }
        int n3 = 0;
        int n4 = 0;
        n4 = n;
        while (n2 > 0) {
            char c;
            int n5 = byArray[n4] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n5 == 0) {
                        return Utf8Utils.throwBadUtf8(n5, n4);
                    }
                    c = (char)n5;
                    ++n4;
                    break;
                }
                case 12: 
                case 13: {
                    int n6 = byArray[n4 + 1] & 0xFF;
                    if ((n6 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n6, n4 + 1);
                    }
                    int n7 = (n5 & 0x1F) << 6 | n6 & 0x3F;
                    if (n7 != 0 && n7 < 128) {
                        return Utf8Utils.throwBadUtf8(n6, n4 + 1);
                    }
                    c = (char)n7;
                    n4 += 2;
                    break;
                }
                case 14: {
                    int n6 = byArray[n4 + 1] & 0xFF;
                    if ((n6 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n6, n4 + 1);
                    }
                    int n7 = byArray[n4 + 2] & 0xFF;
                    if ((n7 & 0xC0) != 128) {
                        return Utf8Utils.throwBadUtf8(n7, n4 + 2);
                    }
                    int n8 = (n5 & 0xF) << 12 | (n6 & 0x3F) << 6 | n7 & 0x3F;
                    if (n8 < 2048) {
                        return Utf8Utils.throwBadUtf8(n7, n4 + 2);
                    }
                    c = (char)n8;
                    n4 += 3;
                    break;
                }
                default: {
                    return Utf8Utils.throwBadUtf8(n5, n4);
                }
            }
            cArray[n3] = c;
            ++n3;
            --n2;
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n4 - n;
            nArray[0] = n4 - n;
        }
        return new String(cArray, 0, n3);
    }

    private static String throwBadUtf8(int n, int n2) {
        throw new IllegalArgumentException("bad utf-8 byte " + Hex.u1(n) + " at offset " + Hex.u4(n2));
    }
}

