/*
 * Decompiled with CFR 0.152.
 */
package com.udevel.widgetlab;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import com.udevel.widgetlab.DotView;
import java.util.ArrayList;

public class GrowDotView
extends DotView {
    private final Paint paint = new Paint();
    private final RectF ovalRectF = new RectF();
    private int centerX;
    private int centerY;
    private float radius;
    private float targetScale;
    private float scale = this.targetScale = 0.7f;
    private AnimatorSet animatorSet;

    public GrowDotView(Context context) {
        super(context);
    }

    @Override
    protected void init() {
    }

    @Override
    public void startDotAnimation() {
        this.stopDotAnimation();
        if (this.animatorSet == null) {
            this.animatorSet = new AnimatorSet();
            ArrayList<ValueAnimator> animations = new ArrayList<ValueAnimator>(2);
            ValueAnimator growAnimator = ValueAnimator.ofFloat((float[])new float[]{this.targetScale, 1.0f});
            growAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    GrowDotView.this.scale = ((Float)animation.getAnimatedValue()).floatValue();
                    GrowDotView.this.updateOvalRecF();
                    GrowDotView.this.invalidate();
                }
            });
            growAnimator.setDuration(this.animationTotalDuration / 2L);
            growAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
            growAnimator.setRepeatCount(1);
            growAnimator.setRepeatMode(2);
            animations.add(growAnimator);
            if (this.dotFirstColor != this.dotSecondColor) {
                ValueAnimator colorAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.dotFirstColor, this.dotSecondColor});
                colorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        GrowDotView.this.dotColor = (Integer)animator.getAnimatedValue();
                    }
                });
                colorAnimator.setDuration(this.animationTotalDuration / 2L);
                colorAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
                colorAnimator.setRepeatCount(1);
                colorAnimator.setRepeatMode(2);
                animations.add(colorAnimator);
            }
            this.animatorSet.playTogether(animations);
            this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    GrowDotView.this.dotColor = GrowDotView.this.dotFirstColor;
                    GrowDotView.this.scale = GrowDotView.this.targetScale;
                    GrowDotView.this.updateOvalRecF();
                    GrowDotView.this.invalidate();
                }
            });
        }
        this.animatorSet.start();
    }

    @Override
    public void stopDotAnimation() {
        if (this.isAnimating()) {
            this.animatorSet.cancel();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animatorSet != null && this.animatorSet.isStarted();
    }

    @Override
    public void setMaxCompressRatio(@FloatRange(from=0.0, to=1.0) float compressRatio) {
        this.scale = this.targetScale = compressRatio;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.dotColor);
        canvas.drawOval(this.ovalRectF, this.paint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.radius = Math.min(this.getWidth(), this.getHeight()) / 2;
        this.updateOvalRecF();
    }

    private void updateOvalRecF() {
        this.ovalRectF.left = (float)this.centerX - this.radius * this.scale;
        this.ovalRectF.top = (float)this.centerY - this.radius * this.scale;
        this.ovalRectF.right = (float)this.centerX + this.radius * this.scale;
        this.ovalRectF.bottom = (float)this.centerY + this.radius * this.scale;
    }
}

