/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.common.internal.zzy;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.dynamic.zzg;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mColor;
    private View zzPb;
    private View.OnClickListener zzPc = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        zzv.zza(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        zzv.zza(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.zzS(this.getContext());
    }

    private void zzS(Context context) {
        if (this.zzPb != null) {
            this.removeView(this.zzPb);
        }
        try {
            this.zzPb = zzy.zzb(context, this.mSize, this.mColor);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzPb = SignInButton.zza(context, this.mSize, this.mColor);
        }
        this.addView(this.zzPb);
        this.zzPb.setEnabled(this.isEnabled());
        this.zzPb.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2) {
        zzz zzz2 = new zzz(context);
        zzz2.zza(context.getResources(), n, n2);
        return zzz2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.zzPc = listener;
        if (this.zzPb != null) {
            this.zzPb.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.zzPb.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.zzPc != null && view == this.zzPb) {
            this.zzPc.onClick((View)this);
        }
    }
}

