/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.AbstractPendingResult;
import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends AbstractPendingResult<BatchResult> {
    private int zzPr;
    private boolean zzPs;
    private boolean zzPt;
    private final PendingResult<?>[] zzPu;
    private final Object zzoe = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, Looper looper) {
        super(new AbstractPendingResult.CallbackHandler(looper));
        this.zzPr = pendingResultList.size();
        this.zzPu = new PendingResult[this.zzPr];
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzPu[i] = pendingResult;
            pendingResult.addBatchCallback(new PendingResult.BatchCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzl(Status status) {
                    Object object = Batch.this.zzoe;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzPt = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzPs = true;
                        }
                        Batch.this.zzPr--;
                        if (Batch.this.zzPr == 0) {
                            if (Batch.this.zzPt) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzPs ? new Status(13) : Status.zzQU;
                                Batch.this.setResult(new BatchResult(status2, Batch.this.zzPu));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzPu) {
            pendingResult.cancel();
        }
    }

    @Override
    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzPu);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzPw = new ArrayList();
        private Looper zzPx;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzPx = googleApiClient.getLooper();
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzPw.size());
            this.zzPw.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzPw, this.zzPx);
        }
    }
}

