/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzQU = new Status(0);
    public static final Status zzQV = new Status(14);
    public static final Status zzQW = new Status(8);
    public static final Status zzQX = new Status(15);
    public static final Status zzQY = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int zzzH;
    private final int zzOJ;
    private final String zzQZ;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.zzzH = versionCode;
        this.zzOJ = statusCode;
        this.zzQZ = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent zzlf() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzQZ;
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzOJ <= 0;
    }

    public boolean isCanceled() {
        return this.zzOJ == 16;
    }

    public boolean isInterrupted() {
        return this.zzOJ == 14;
    }

    public int getStatusCode() {
        return this.zzOJ;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzu.hashCode(this.zzzH, this.zzOJ, this.zzQZ, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.zzzH == status.zzzH && this.zzOJ == status.zzOJ && zzu.equal(this.zzQZ, status.zzQZ) && zzu.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzkv() {
        if (this.zzQZ != null) {
            return this.zzQZ;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzOJ);
    }

    public String toString() {
        return zzu.zzq(this).zzg("statusCode", this.zzkv()).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

