/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.signin.internal.AuthAccountResult;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class zze
implements zzh {
    private final zzg zzPQ;
    private final Lock zzPR;
    private final Context mContext;
    private ConnectionResult zzPS;
    private int zzPT;
    private int zzPU = 0;
    private boolean zzPV = false;
    private int zzPW;
    private final Bundle zzPX = new Bundle();
    private final Set<Api.zzc> zzPY = new HashSet<Api.zzc>();
    private zzmd zzPZ;
    private int zzQa;
    private boolean zzQb;
    private boolean zzQc;
    private zzo zzQd;
    private boolean zzQe;
    private boolean zzQf;
    private final com.google.android.gms.common.internal.zze zzQg;
    private final Map<Api<?>, Integer> zzQh;
    private final Api.zzb<? extends zzmd, zzme> zzPK;

    public zze(zzg zzg2, com.google.android.gms.common.internal.zze zze2, Map<Api<?>, Integer> map, Api.zzb<? extends zzmd, zzme> zzb2, Lock lock, Context context) {
        this.zzPQ = zzg2;
        this.zzQg = zze2;
        this.zzQh = map;
        this.zzPK = zzb2;
        this.zzPR = lock;
        this.mContext = context;
    }

    @Override
    public String getName() {
        return "CONNECTING";
    }

    @Override
    public void begin() {
        this.zzPQ.zzQs.zzmg();
        this.zzPQ.zzQA.clear();
        this.zzPV = false;
        this.zzQb = false;
        this.zzPS = null;
        this.zzPU = 0;
        this.zzQa = 2;
        this.zzQc = false;
        this.zzQe = false;
        boolean bl = false;
        for (Api<?> object : this.zzQh.keySet()) {
            Api.zza zza2 = this.zzPQ.zzQz.get(object.zzkF());
            int n = this.zzQh.get(object);
            zza2.zza(new zzc(this, object, n));
            bl |= object.zzkC().getPriority() == 1;
            if (!zza2.zzjM()) continue;
            this.zzQb = true;
            if (n < this.zzQa) {
                this.zzQa = n;
            }
            if (n == 0) continue;
            this.zzPY.add(object.zzkF());
        }
        if (bl) {
            this.zzQb = false;
        }
        if (this.zzQb) {
            this.zzQg.zza(this.zzPQ.getSessionId());
            zzd zzd2 = new zzd();
            this.zzPZ = this.zzPK.zza(this.mContext, this.zzPQ.getLooper(), this.zzQg, this.zzQg.zzlM(), zzd2, zzd2);
            this.zzPZ.connect();
        }
        this.zzPW = this.zzPQ.zzQz.size();
        for (Api.zza zza3 : this.zzPQ.zzQz.values()) {
            zza3.connect();
        }
    }

    private boolean zzkP() {
        --this.zzPW;
        if (this.zzPW > 0) {
            return false;
        }
        if (this.zzPS != null) {
            this.zzf(this.zzPS);
            return false;
        }
        return true;
    }

    private void zzkQ() {
        if (this.zzQb) {
            this.zzkR();
        } else {
            this.zzkT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(ResolveAccountResponse resolveAccountResponse) {
        ConnectionResult connectionResult = resolveAccountResponse.zzmn();
        this.zzPR.lock();
        try {
            if (!this.zzat(0)) {
                return;
            }
            if (connectionResult.isSuccess()) {
                this.zzQd = resolveAccountResponse.zzmm();
                this.zzQc = true;
                this.zzQe = resolveAccountResponse.zzmo();
                this.zzQf = resolveAccountResponse.zzmp();
                this.zzkR();
            } else if (this.zze(connectionResult)) {
                this.zzkV();
                if (this.zzPW == 0) {
                    this.zzkT();
                }
            } else {
                this.zzf(connectionResult);
            }
        }
        finally {
            this.zzPR.unlock();
        }
    }

    private void zzkR() {
        if (this.zzQc && this.zzPW == 0) {
            this.zzPU = 1;
            this.zzPW = this.zzPQ.zzQz.size();
            for (Api.zzc<?> zzc2 : this.zzPQ.zzQz.keySet()) {
                if (this.zzPQ.zzQA.containsKey(zzc2)) {
                    if (!this.zzkP()) continue;
                    this.zzkS();
                    continue;
                }
                this.zzPQ.zzQz.get(zzc2).zza(this.zzQd);
            }
        }
    }

    private void zzkS() {
        this.zzPU = 2;
        this.zzPQ.zzQB = this.zzkW();
        this.zzPZ.zza(this.zzQd, this.zzPQ.zzQB, new zza(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(ConnectionResult connectionResult) {
        this.zzPR.lock();
        try {
            if (!this.zzat(2)) {
                return;
            }
            if (connectionResult.isSuccess()) {
                this.zzkT();
            } else if (this.zze(connectionResult)) {
                this.zzkV();
                this.zzkT();
            } else {
                this.zzf(connectionResult);
            }
        }
        finally {
            this.zzPR.unlock();
        }
    }

    private void zzkT() {
        Set<Scope> set = this.zzPQ.zzQB;
        if (set.isEmpty()) {
            set = this.zzkW();
        }
        this.zzPU = 3;
        this.zzPW = this.zzPQ.zzQz.size();
        for (Api.zzc<?> zzc2 : this.zzPQ.zzQz.keySet()) {
            if (this.zzPQ.zzQA.containsKey(zzc2)) {
                if (!this.zzkP()) continue;
                this.zzkU();
                continue;
            }
            this.zzPQ.zzQz.get(zzc2).zza(this.zzQd, set);
        }
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (!this.zzat(3)) {
            return;
        }
        if (connectionHint != null) {
            this.zzPX.putAll(connectionHint);
        }
        if (this.zzkP()) {
            this.zzkU();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzat(3)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzkP()) {
            this.zzkU();
        }
    }

    private void zzkU() {
        this.zzPQ.zzla();
        if (this.zzPZ != null) {
            if (this.zzQe) {
                this.zzPZ.zza(this.zzQd, this.zzQf);
            }
            this.zzO(false);
        }
        for (Api.zzc<?> zzc2 : this.zzPQ.zzQA.keySet()) {
            Api.zza zza2 = this.zzPQ.zzQz.get(zzc2);
            zza2.disconnect();
        }
        if (this.zzPV) {
            this.zzPV = false;
            this.zzas(-1);
        } else {
            Bundle bundle = this.zzPX.isEmpty() ? null : this.zzPX;
            this.zzPQ.zzQs.zzg(bundle);
        }
    }

    @Override
    public <A extends Api.zza, R extends Result, T extends zza.zza<R, A>> T zza(T t) {
        this.zzPQ.zzQt.add(t);
        return t;
    }

    @Override
    public <A extends Api.zza, T extends zza.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
        this.zzPV = false;
    }

    @Override
    public void zzas(int n) {
        if (n == -1) {
            Iterator iterator = this.zzPQ.zzQt.iterator();
            while (iterator.hasNext()) {
                zzg.zze zze2 = (zzg.zze)iterator.next();
                if (zze2.zzkI() == 1) continue;
                zze2.cancel();
                iterator.remove();
            }
            this.zzPQ.zzkX();
            if (this.zzPS == null && !this.zzPQ.zzQt.isEmpty()) {
                this.zzPV = true;
                return;
            }
            this.zzPQ.zzQA.clear();
            this.zzPS = null;
            this.zzO(true);
        }
        this.zzPQ.zzg(this.zzPS);
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzkC().getPriority(), n, connectionResult)) {
            this.zzPS = connectionResult;
            this.zzPT = n2;
        }
        this.zzPQ.zzQA.put(api.zzkF(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !zze.zzd(connectionResult)) {
            return false;
        }
        return this.zzPS == null || n < this.zzPT;
    }

    private static boolean zzd(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return GooglePlayServicesUtil.zzar(connectionResult.getErrorCode()) != null;
    }

    private void zzkV() {
        this.zzQb = false;
        this.zzPQ.zzQB.clear();
        for (Api.zzc zzc2 : this.zzPY) {
            if (this.zzPQ.zzQA.containsKey(zzc2)) continue;
            this.zzPQ.zzQA.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zze(ConnectionResult connectionResult) {
        return this.zzQa == 2 || this.zzQa == 1 && !connectionResult.hasResolution();
    }

    private void zzf(ConnectionResult connectionResult) {
        this.zzPV = false;
        this.zzPQ.zzQB.clear();
        this.zzO(!connectionResult.hasResolution());
        this.zzas(3);
        if (!this.zzPQ.zzlb() || !GooglePlayServicesUtil.zze(this.mContext, connectionResult.getErrorCode())) {
            this.zzPQ.zzld();
            this.zzPQ.zzQs.zzj(connectionResult);
        }
        this.zzPQ.zzQs.zzmf();
    }

    private void zzO(boolean bl) {
        if (this.zzPZ != null) {
            if (this.zzPZ.isConnected()) {
                if (bl) {
                    this.zzPZ.zzwe();
                }
                this.zzPZ.disconnect();
            }
            this.zzQd = null;
        }
    }

    private Set<Scope> zzkW() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzQg.zzlG());
        Map<Api<?>, zze.zza> map = this.zzQg.zzlI();
        for (Api<?> api : map.keySet()) {
            if (this.zzPQ.zzQA.containsKey(api.zzkF())) continue;
            hashSet.addAll(map.get(api).zzPP);
        }
        return hashSet;
    }

    private boolean zzat(int n) {
        if (this.zzPU != n) {
            Log.wtf((String)"GoogleApiClientConnecting", (String)("GoogleApiClient connecting is in step " + this.zzau(this.zzPU) + " but received callback for step " + this.zzau(n)));
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzau(int n) {
        switch (n) {
            case 0: {
                return "STEP_GETTING_SERVICE_BINDINGS";
            }
            case 1: {
                return "STEP_VALIDATING_ACCOUNT";
            }
            case 2: {
                return "STEP_AUTHENTICATING";
            }
            case 3: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zza
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zze> zzQi;

        zza(zze zze2) {
            this.zzQi = new WeakReference<zze>(zze2);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, AuthAccountResult authAccountResult) {
            final zze zze2 = (zze)this.zzQi.get();
            if (zze2 == null) {
                return;
            }
            ((zze)zze2).zzPQ.zzQx.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zzc(connectionResult);
                }
            });
        }
    }

    private static class zzc
    implements GoogleApiClient.zza {
        private final WeakReference<zze> zzQi;
        private final Api<?> zzQo;
        private final int zzQp;

        public zzc(zze zze2, Api<?> api, int n) {
            this.zzQi = new WeakReference<zze>(zze2);
            this.zzQo = api;
            this.zzQp = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ConnectionResult connectionResult) {
            zze zze2 = (zze)this.zzQi.get();
            if (zze2 == null) {
                return;
            }
            zzv.zza(Looper.myLooper() == zze2.zzPQ.getLooper(), (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zze2.zzPR.lock();
            try {
                if (!zze2.zzat(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zze2.zzb(connectionResult, this.zzQo, this.zzQp);
                }
                if (zze2.zzkP()) {
                    zze2.zzkQ();
                }
            }
            finally {
                zze2.zzPR.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzb(ConnectionResult connectionResult) {
            zze zze2 = (zze)this.zzQi.get();
            if (zze2 == null) {
                return;
            }
            zzv.zza(Looper.myLooper() == zze2.zzPQ.getLooper(), (Object)"onReportAccountValidation must be called on the GoogleApiClient handler thread");
            zze2.zzPR.lock();
            try {
                if (!zze2.zzat(1)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zze2.zzb(connectionResult, this.zzQo, this.zzQp);
                }
                if (zze2.zzkP()) {
                    zze2.zzkS();
                }
            }
            finally {
                zze2.zzPR.unlock();
            }
        }
    }

    private class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzd() {
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            zze.this.zzPZ.zza(new zzb(zze.this));
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zze.this.zzPR.lock();
            try {
                if (zze.this.zze(result)) {
                    zze.this.zzkV();
                    zze.this.zzkT();
                } else {
                    zze.this.zzf(result);
                }
            }
            finally {
                zze.this.zzPR.unlock();
            }
        }
    }

    private static class zzb
    extends zzr.zza {
        private final WeakReference<zze> zzQi;

        zzb(zze zze2) {
            this.zzQi = new WeakReference<zze>(zze2);
        }

        @Override
        public void zzb(final ResolveAccountResponse resolveAccountResponse) {
            final zze zze2 = (zze)this.zzQi.get();
            if (zze2 == null) {
                return;
            }
            ((zze)zze2).zzPQ.zzQx.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(resolveAccountResponse);
                }
            });
        }
    }
}

