/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzv;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzj
implements Handler.Callback {
    private final zza zzTD;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzTE = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzTF = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzTG = new ArrayList();
    private volatile boolean zzTH = false;
    private final AtomicInteger zzTI = new AtomicInteger(0);
    private boolean zzTJ = false;
    private final Handler mHandler;
    private final Object zzoe = new Object();

    public zzj(Looper looper, zza zza2) {
        this.zzTD = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzmf() {
        this.zzTH = false;
        this.zzTI.incrementAndGet();
    }

    public void zzmg() {
        this.zzTH = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzmh() {
        Object object = this.zzoe;
        synchronized (object) {
            this.zzg(this.zzTD.zzjZ());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Bundle bundle) {
        Object object = this.zzoe;
        synchronized (object) {
            zzv.zzP(!this.zzTJ);
            this.mHandler.removeMessages(1);
            this.zzTJ = true;
            zzv.zzP(this.zzTF.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzTE);
            int n = this.zzTI.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzTH || !this.zzTD.isConnected() || this.zzTI.get() != n) break;
                if (this.zzTF.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzTF.clear();
            this.zzTJ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaP(int n) {
        this.mHandler.removeMessages(1);
        Object object = this.zzoe;
        synchronized (object) {
            this.zzTJ = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzTE);
            int n2 = this.zzTI.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzTH || this.zzTI.get() != n2) break;
                if (!this.zzTE.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzTF.clear();
            this.zzTJ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzj(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(1);
        Object object = this.zzoe;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzTG);
            int n = this.zzTI.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzTH || this.zzTI.get() != n) {
                    return;
                }
                if (!this.zzTG.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzv.zzr(listener);
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzTE.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzTE.add(listener);
            }
        }
        if (this.zzTD.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        zzv.zzr(listener);
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzTE.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzv.zzr(listener);
        Object object = this.zzoe;
        synchronized (object) {
            boolean bl = this.zzTE.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzTJ) {
                this.zzTF.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzv.zzr(listener);
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzTG.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzTG.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        zzv.zzr(listener);
        Object object = this.zzoe;
        synchronized (object) {
            return this.zzTG.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzv.zzr(listener);
        Object object = this.zzoe;
        synchronized (object) {
            boolean bl = this.zzTG.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            Object object = this.zzoe;
            synchronized (object) {
                if (this.zzTH && this.zzTD.isConnected() && this.zzTE.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzTD.zzjZ();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)"Don't know how to handle this message.");
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzjZ();
    }
}

