/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzacd;
    private Bundle zzace;
    private LinkedList<zza> zzacf;
    private final zzf<T> zzacg = new zzf<T>(){

        @Override
        public void zza(T t) {
            zza.this.zzacd = t;
            for (zza zza2 : zza.this.zzacf) {
                zza2.zzb(zza.this.zzacd);
            }
            zza.this.zzacf.clear();
            zza.this.zzace = null;
        }
    };

    public T zzou() {
        return this.zzacd;
    }

    private void zzdu(int n) {
        while (!this.zzacf.isEmpty() && this.zzacf.getLast().getState() >= n) {
            this.zzacf.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzacd != null) {
            zza2.zzb((LifecycleDelegate)this.zzacd);
            return;
        }
        if (this.zzacf == null) {
            this.zzacf = new LinkedList();
        }
        this.zzacf.add(zza2);
        if (bundle != null) {
            if (this.zzace == null) {
                this.zzace = (Bundle)bundle.clone();
            } else {
                this.zzace.putAll(bundle);
            }
        }
        this.zza(this.zzacg);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle attrs, final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzacd.onInflate(activity, attrs, savedInstanceState);
            }
        });
    }

    public void onCreate(final Bundle savedInstanceState) {
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzacd.onCreate(savedInstanceState);
            }
        });
    }

    public View onCreateView(final LayoutInflater inflater, final ViewGroup container, final Bundle savedInstanceState) {
        final FrameLayout frameLayout = new FrameLayout(inflater.getContext());
        this.zza(savedInstanceState, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzacd.onCreateView(inflater, container, savedInstanceState));
            }
        });
        if (this.zzacd == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = com.google.android.gms.common.internal.zzf.zzh(context, n);
        String string3 = com.google.android.gms.common.internal.zzf.zzi(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    context.startActivity(GooglePlayServicesUtil.zzar(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzacd.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzacd.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzacd != null) {
            this.zzacd.onPause();
        } else {
            this.zzdu(5);
        }
    }

    public void onStop() {
        if (this.zzacd != null) {
            this.zzacd.onStop();
        } else {
            this.zzdu(4);
        }
    }

    public void onDestroyView() {
        if (this.zzacd != null) {
            this.zzacd.onDestroyView();
        } else {
            this.zzdu(2);
        }
    }

    public void onDestroy() {
        if (this.zzacd != null) {
            this.zzacd.onDestroy();
        } else {
            this.zzdu(1);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.zzacd != null) {
            this.zzacd.onSaveInstanceState(outState);
        } else if (this.zzace != null) {
            outState.putAll(this.zzace);
        }
    }

    public void onLowMemory() {
        if (this.zzacd != null) {
            this.zzacd.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

