/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T zzaBY;
    private Bundle zzaBZ;
    private LinkedList<zza> zzaCa;
    private final zzf<T> zzaCb = new zzf<T>(){

        public void zza(T t) {
            zza.this.zzaBY = t;
            for (zza zza2 : zza.this.zzaCa) {
                zza2.zzb(zza.this.zzaBY);
            }
            zza.this.zzaCa.clear();
            zza.this.zzaBZ = null;
        }
    };

    public T zzxd() {
        return this.zzaBY;
    }

    private void zzeZ(int n) {
        while (!this.zzaCa.isEmpty() && this.zzaCa.getLast().getState() >= n) {
            this.zzaCa.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.zzaBY != null) {
            zza2.zzb((LifecycleDelegate)this.zzaBY);
            return;
        }
        if (this.zzaCa == null) {
            this.zzaCa = new LinkedList();
        }
        this.zzaCa.add(zza2);
        if (bundle != null) {
            if (this.zzaBZ == null) {
                this.zzaBZ = (Bundle)bundle.clone();
            } else {
                this.zzaBZ.putAll(bundle);
            }
        }
        this.zza(this.zzaCb);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle bundle, final Bundle bundle2) {
        this.zza(bundle2, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaBY.onInflate(activity, bundle, bundle2);
            }
        });
    }

    public void onCreate(final Bundle bundle) {
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaBY.onCreate(bundle);
            }
        });
    }

    public View onCreateView(final LayoutInflater layoutInflater, final ViewGroup viewGroup, final Bundle bundle) {
        final FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.zzaBY.onCreateView(layoutInflater, viewGroup, bundle));
            }
        });
        if (this.zzaBY == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzh.zzb(context, n, GooglePlayServicesUtil.zzam((Context)context));
        String string3 = zzh.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    context.startActivity(GooglePlayServicesUtil.zzbC(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaBY.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.zzaBY.onResume();
            }
        });
    }

    public void onPause() {
        if (this.zzaBY != null) {
            this.zzaBY.onPause();
        } else {
            this.zzeZ(5);
        }
    }

    public void onStop() {
        if (this.zzaBY != null) {
            this.zzaBY.onStop();
        } else {
            this.zzeZ(4);
        }
    }

    public void onDestroyView() {
        if (this.zzaBY != null) {
            this.zzaBY.onDestroyView();
        } else {
            this.zzeZ(2);
        }
    }

    public void onDestroy() {
        if (this.zzaBY != null) {
            this.zzaBY.onDestroy();
        } else {
            this.zzeZ(1);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.zzaBY != null) {
            this.zzaBY.onSaveInstanceState(bundle);
        } else if (this.zzaBZ != null) {
            bundle.putAll(this.zzaBZ);
        }
    }

    public void onLowMemory() {
        if (this.zzaBY != null) {
            this.zzaBY.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

