/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzop;
import com.google.android.gms.internal.zzoq;
import com.google.android.gms.internal.zzor;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zznr
extends zznu {
    private final SparseArray<zza> zzalH = new SparseArray();

    public static zznr zza(zzop zzop2) {
        zzor zzor2 = zznr.zzc((zzop)zzop2);
        zznr zznr2 = (zznr)zzor2.zza("AutoManageHelper", zznr.class);
        if (zznr2 != null) {
            return zznr2;
        }
        return new zznr(zzor2);
    }

    private zznr(zzor zzor2) {
        super(zzor2);
        this.zzaop.zza("AutoManageHelper", (zzoq)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzaa.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzaa.zza((this.zzalH.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.zzalQ;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzalH.put(n, (Object)zza2);
        if (this.mStarted && !this.zzalQ) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzbG(int n) {
        zza zza2 = (zza)this.zzalH.get(n);
        this.zzalH.remove(n);
        if (zza2 != null) {
            zza2.zzrB();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzalH);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.zzalQ) {
            for (n = 0; n < this.zzalH.size(); ++n) {
                object = (zza)this.zzalH.valueAt(n);
                ((zza)object).zzalJ.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzalH.size(); ++i) {
            zza zza2 = (zza)this.zzalH.valueAt(i);
            zza2.zzalJ.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzalH.size(); ++i) {
            zza zza2 = (zza)this.zzalH.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzalH.get(n);
        if (zza2 != null) {
            this.zzbG(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzalK;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzrA() {
        for (int i = 0; i < this.zzalH.size(); ++i) {
            zza zza2 = (zza)this.zzalH.valueAt(i);
            zza2.zzalJ.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzalI;
        public final GoogleApiClient zzalJ;
        public final GoogleApiClient.OnConnectionFailedListener zzalK;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzalI = n;
            this.zzalJ = googleApiClient;
            this.zzalK = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zznr.this.zzb(connectionResult, this.zzalI);
        }

        public void zzrB() {
            this.zzalJ.unregisterConnectionFailedListener(this);
            this.zzalJ.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.zzalI);
            printWriter.println(":");
            this.zzalJ.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

