/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zznp;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zzot;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class zzoj
implements Handler.Callback {
    private long zzank = 5000L;
    private long zzanj = 120000L;
    private long zzanK = 10000L;
    private static final Object zzrs = new Object();
    private static zzoj zzanL;
    private final Context mContext;
    private final GoogleApiAvailability zzaln;
    private int zzanM = -1;
    private final AtomicInteger zzanN = new AtomicInteger(1);
    private final SparseArray<zzc<?>> zzanO = new SparseArray();
    private final Map<zznq<?>, zzc<?>> zzanP = new ConcurrentHashMap(5, 0.75f, 1);
    private zzny zzanQ = null;
    private final Set<zznq<?>> zzanR = new com.google.android.gms.common.util.zza();
    private final Handler mHandler;
    private final ReferenceQueue<com.google.android.gms.common.api.zzc<?>> zzanS = new ReferenceQueue();
    private final SparseArray<zza> zzanT = new SparseArray();
    private zzb zzanU;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<zzoj, Integer> zza(Context context, com.google.android.gms.common.api.zzc<?> zzc2) {
        Object object = zzrs;
        synchronized (object) {
            if (zzanL == null) {
                zzanL = new zzoj(context.getApplicationContext());
            }
            int n = zzanL.zza(zzc2);
            return Pair.create((Object)zzanL, (Object)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzoj zzsq() {
        Object object = zzrs;
        synchronized (object) {
            return zzanL;
        }
    }

    private zzoj(Context context) {
        this(context, GoogleApiAvailability.getInstance());
    }

    zzoj(Context context, GoogleApiAvailability googleApiAvailability) {
        this.mContext = context;
        HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper(), (Handler.Callback)this);
        this.zzaln = googleApiAvailability;
    }

    private int zza(com.google.android.gms.common.api.zzc<?> zzc2) {
        int n = this.zzanN.getAndIncrement();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, 0, zzc2));
        return n;
    }

    @WorkerThread
    private void zza(com.google.android.gms.common.api.zzc<?> zzc2, int n) {
        zznq<?> zznq2 = zzc2.zzrn();
        if (!this.zzanP.containsKey(zznq2)) {
            this.zzanP.put(zznq2, new zzc(zzc2));
        }
        zzc<?> zzc3 = this.zzanP.get(zznq2);
        zzc3.zzbL(n);
        this.zzanO.put(n, zzc3);
        ((zzc)zzc3).connect();
        this.zzanT.put(n, (Object)new zza(zzc2, n, this.zzanS));
        if (this.zzanU == null || !this.zzanU.zzanW.get()) {
            this.zzanU = new zzb(this.zzanS, this.zzanT);
            this.zzanU.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzny zzny2) {
        Object object = zzrs;
        synchronized (object) {
            if (zzny2 == null) {
                this.zzanQ = null;
                this.zzanR.clear();
            }
        }
    }

    @WorkerThread
    public void zza(zzns zzns2) {
        Set<zznq<?>> set = zzns2.zzrC();
        for (zznq<?> zznq2 : set) {
            zzc<?> zzc2 = this.zzanP.get(zznq2);
            if (zzc2 == null) {
                zzns2.cancel();
                return;
            }
            if (zzc2.isConnected()) {
                zzns2.zza(zznq2, ConnectionResult.zzakj);
                continue;
            }
            if (zzc2.zzsw() != null) {
                zzns2.zza(zznq2, zzc2.zzsw());
                continue;
            }
            zzc2.zzb(zzns2);
        }
    }

    public void zzrA() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3));
    }

    @WorkerThread
    private void zzsr() {
        for (zzc<?> zzc2 : this.zzanP.values()) {
            zzc2.zzsv();
            ((zzc)zzc2).connect();
        }
    }

    public void zzd(int n, boolean bl) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n, bl ? 1 : 2));
    }

    @WorkerThread
    private void zze(int n, boolean bl) {
        zzc zzc2 = (zzc)this.zzanO.get(n);
        if (zzc2 != null) {
            if (!bl) {
                this.zzanO.delete(n);
            }
            zzc2.zzf(n, bl);
        } else {
            Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(52).append("onRelease received for unknown instance: ").append(n).toString(), (Throwable)new Exception());
        }
    }

    public <O extends Api.ApiOptions> void zza(com.google.android.gms.common.api.zzc<O> zzc2, int n, zznt.zza<? extends Result, Api.zzb> zza2) {
        zznp.zza zza3 = new zznp.zza(zzc2.getInstanceId(), n, zza2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)zza3));
    }

    public <O extends Api.ApiOptions, TResult> void zza(com.google.android.gms.common.api.zzc<O> zzc2, int n, zzpd<Api.zzb, TResult> zzpd2, TaskCompletionSource<TResult> taskCompletionSource) {
        zznp.zzb<TResult> zzb2 = new zznp.zzb<TResult>(zzc2.getInstanceId(), n, zzpd2, taskCompletionSource);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, zzb2));
    }

    @WorkerThread
    private void zza(zznp zznp2) {
        ((zzc)this.zzanO.get(zznp2.zzalC)).zzb(zznp2);
    }

    @WorkerThread
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.zza((zzns)message.obj);
                break;
            }
            case 6: {
                this.zza((com.google.android.gms.common.api.zzc)message.obj, message.arg1);
                break;
            }
            case 3: {
                this.zzsr();
                break;
            }
            case 2: 
            case 7: {
                this.zze(message.arg1, message.arg2 == 1);
                break;
            }
            case 4: {
                this.zza((zznp)message.obj);
                break;
            }
            case 5: {
                if (this.zzanO.get(message.arg1) == null) break;
                ((zzc)this.zzanO.get(message.arg1)).zzz(new Status(17, "Error resolution was canceled by the user."));
                break;
            }
            case 8: {
                if (!this.zzanP.containsKey(message.obj)) break;
                ((zzc)this.zzanP.get(message.obj)).resume();
                break;
            }
            case 9: {
                if (!this.zzanP.containsKey(message.obj)) break;
                ((zzc)this.zzanP.get(message.obj)).zzsh();
                break;
            }
            case 10: {
                if (!this.zzanP.containsKey(message.obj)) break;
                ((zzc)this.zzanP.get(message.obj)).zzsz();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    boolean zzc(ConnectionResult connectionResult, int n) {
        if (connectionResult.hasResolution() || this.zzaln.isUserResolvableError(connectionResult.getErrorCode())) {
            this.zzaln.zza(this.mContext, connectionResult, n);
            return true;
        }
        return false;
    }

    public void zza(ConnectionResult connectionResult, int n) {
        if (!this.zzc(connectionResult, n)) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n, 0));
        }
    }

    static /* synthetic */ zzny zzd(zzoj zzoj2) {
        return null;
    }

    private static final class zzb
    extends Thread {
        private final ReferenceQueue<com.google.android.gms.common.api.zzc<?>> zzanS;
        private final SparseArray<zza> zzanT;
        private final AtomicBoolean zzanW = new AtomicBoolean();

        public zzb(ReferenceQueue<com.google.android.gms.common.api.zzc<?>> referenceQueue, SparseArray<zza> sparseArray) {
            super("GoogleApiCleanup");
            this.zzanS = referenceQueue;
            this.zzanT = sparseArray;
        }

        @Override
        public void run() {
            this.zzanW.set(true);
            Process.setThreadPriority((int)10);
            try {
                while (this.zzanW.get()) {
                    zza zza2 = (zza)this.zzanS.remove();
                    this.zzanT.remove(zza2.zzalC);
                    zza2.zzst();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.zzanW.set(false);
            }
        }
    }

    private final class zza
    extends PhantomReference<com.google.android.gms.common.api.zzc<?>> {
        private final int zzalC;

        public zza(com.google.android.gms.common.api.zzc zzc2, int n, ReferenceQueue<com.google.android.gms.common.api.zzc<?>> referenceQueue) {
            super(zzc2, referenceQueue);
            this.zzalC = n;
        }

        public void zzst() {
            zzoj.this.mHandler.sendMessage(zzoj.this.mHandler.obtainMessage(2, this.zzalC, 2));
        }
    }

    private class zzd
    implements zzd.zzf {
        private final Api.zze zzanY;
        private final zznq<?> zzakV;

        public zzd(Api.zze zze2, zznq<?> zznq2) {
            this.zzanY = zze2;
            this.zzakV = zznq2;
        }

        @WorkerThread
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                this.zzanY.zza(null, Collections.emptySet());
            } else {
                ((zzc)zzoj.this.zzanP.get(this.zzakV)).onConnectionFailed(connectionResult);
            }
        }
    }

    private class zzc<O extends Api.ApiOptions>
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private final Queue<zznp> zzanX = new LinkedList<zznp>();
        private final Api.zze zzanY;
        private final Api.zzb zzanZ;
        private final zznq<O> zzakV;
        private final SparseArray<zzpf> zzaoa = new SparseArray();
        private final Set<zzns> zzaob = new HashSet<zzns>();
        private final SparseArray<Map<Object, zznt.zza>> zzaoc = new SparseArray();
        private boolean zzani;
        private ConnectionResult zzaod = null;

        @WorkerThread
        public zzc(com.google.android.gms.common.api.zzc<O> zzc2) {
            this.zzanY = this.zzb(zzc2);
            this.zzanZ = this.zzanY instanceof zzag ? ((zzag)this.zzanY).zztX() : this.zzanY;
            this.zzakV = zzc2.zzrn();
        }

        @Override
        @WorkerThread
        public void onConnected(@Nullable Bundle bundle) {
            this.zzsv();
            this.zzj(ConnectionResult.zzakj);
            this.zzsx();
            for (int i = 0; i < this.zzaoc.size(); ++i) {
                Map map = (Map)this.zzaoc.get(this.zzaoc.keyAt(i));
                for (zznt.zza zza2 : map.values()) {
                    try {
                        zza2.zzb(this.zzanZ);
                    }
                    catch (DeadObjectException deadObjectException) {
                        this.zzanY.disconnect();
                        this.onConnectionSuspended(1);
                    }
                }
            }
            this.zzsu();
            this.zzsy();
        }

        @Override
        @WorkerThread
        public void onConnectionSuspended(int n) {
            this.zzsv();
            this.zzani = true;
            zzoj.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzoj.this.mHandler, (int)8, this.zzakV), zzoj.this.zzank);
            zzoj.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzoj.this.mHandler, (int)9, this.zzakV), zzoj.this.zzanj);
            zzoj.this.zzanM = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            this.zzsv();
            zzoj.this.zzanM = -1;
            this.zzj(connectionResult);
            int n = this.zzaoa.keyAt(0);
            if (this.zzanX.isEmpty()) {
                this.zzaod = connectionResult;
                return;
            }
            Object object = zzrs;
            synchronized (object) {
                if (zzoj.zzd(zzoj.this) != null && zzoj.this.zzanR.contains(this.zzakV)) {
                    zzoj.zzd(zzoj.this).zzb(connectionResult, n);
                    return;
                }
            }
            if (!zzoj.this.zzc(connectionResult, n)) {
                if (connectionResult.getErrorCode() == 18) {
                    this.zzani = true;
                }
                if (this.zzani) {
                    zzoj.this.mHandler.sendMessageDelayed(Message.obtain((Handler)zzoj.this.mHandler, (int)8, this.zzakV), zzoj.this.zzank);
                } else {
                    object = String.valueOf(this.zzakV.zzrz());
                    this.zzz(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
                }
            }
        }

        @WorkerThread
        public void zzsu() {
            while (this.zzanY.isConnected() && !this.zzanX.isEmpty()) {
                zznp zznp2 = this.zzanX.remove();
                this.zzc(zznp2);
            }
        }

        @WorkerThread
        public void zzb(zznp zznp2) {
            if (this.zzanY.isConnected()) {
                this.zzc(zznp2);
                this.zzsy();
            } else {
                this.zzanX.add(zznp2);
                if (this.zzaod != null && this.zzaod.hasResolution()) {
                    this.onConnectionFailed(this.zzaod);
                } else {
                    this.connect();
                }
            }
        }

        @WorkerThread
        public void zzbL(int n) {
            this.zzaoa.put(n, (Object)new zzpf(this.zzakV.zzre(), this.zzanY));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzf(int n, boolean bl) {
            Object object;
            Iterator iterator = this.zzanX.iterator();
            while (iterator.hasNext()) {
                object = (zznp)iterator.next();
                if (((zznp)object).zzalC != n || ((zznp)object).zzagd == 1 || !((zznp)object).cancel()) continue;
                iterator.remove();
            }
            ((zzpf)this.zzaoa.get(n)).release();
            this.zzaoc.delete(n);
            if (!bl) {
                this.zzaoa.remove(n);
                zzoj.this.zzanT.remove(n);
                if (this.zzaoa.size() == 0 && this.zzanX.isEmpty()) {
                    this.zzsx();
                    this.zzanY.disconnect();
                    zzoj.this.zzanP.remove(this.zzakV);
                    object = zzrs;
                    synchronized (object) {
                        zzoj.this.zzanR.remove(this.zzakV);
                    }
                }
            }
        }

        @WorkerThread
        public void zzsv() {
            this.zzaod = null;
        }

        ConnectionResult zzsw() {
            return this.zzaod;
        }

        @WorkerThread
        private void zzc(zznp zznp2) {
            zznp2.zza(this.zzaoa);
            if (zznp2.zzagd == 3) {
                try {
                    Map map = (Map)this.zzaoc.get(zznp2.zzalC);
                    if (map == null) {
                        map = new ArrayMap(1);
                        this.zzaoc.put(zznp2.zzalC, (Object)map);
                    }
                    zznt.zza<? extends Result, Api.zzb> zza2 = ((zznp.zza)zznp2).zzalD;
                    zzot zzot2 = (zzot)((Object)zza2);
                    map.put(zzot2.zzsG(), zza2);
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Listener registration methods must implement ListenerApiMethod");
                }
            }
            if (zznp2.zzagd == 4) {
                try {
                    Map map = (Map)this.zzaoc.get(zznp2.zzalC);
                    zzot zzot3 = (zzot)((Object)((zznp.zza)zznp2).zzalD);
                    if (map != null) {
                        map.remove(zzot3.zzsG());
                    } else {
                        Log.w((String)"GoogleApiManager", (String)"Received call to unregister a listener without a matching registration call.");
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Listener unregistration methods must implement ListenerApiMethod");
                }
            }
            try {
                zznp2.zzb(this.zzanZ);
            }
            catch (DeadObjectException deadObjectException) {
                this.zzanY.disconnect();
                this.onConnectionSuspended(1);
            }
        }

        @WorkerThread
        private void zzz(Status status) {
            for (zznp zznp2 : this.zzanX) {
                zznp2.zzv(status);
            }
            this.zzanX.clear();
        }

        @WorkerThread
        private void resume() {
            if (this.zzani) {
                this.connect();
            }
        }

        @WorkerThread
        private void zzsx() {
            if (this.zzani) {
                zzoj.this.mHandler.removeMessages(9, this.zzakV);
                zzoj.this.mHandler.removeMessages(8, this.zzakV);
                this.zzani = false;
            }
        }

        @WorkerThread
        private void zzsh() {
            if (this.zzani) {
                this.zzsx();
                int n = zzoj.this.zzaln.isGooglePlayServicesAvailable(zzoj.this.mContext);
                Status status = n == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
                this.zzz(status);
                this.zzanY.disconnect();
            }
        }

        private void zzsy() {
            zzoj.this.mHandler.removeMessages(10, this.zzakV);
            zzoj.this.mHandler.sendMessageDelayed(zzoj.this.mHandler.obtainMessage(10, this.zzakV), zzoj.this.zzanK);
        }

        private void zzsz() {
            if (this.zzanY.isConnected() && this.zzaoc.size() == 0) {
                for (int i = 0; i < this.zzaoa.size(); ++i) {
                    zzpf zzpf2 = (zzpf)this.zzaoa.get(this.zzaoa.keyAt(i));
                    if (!zzpf2.zzsM()) continue;
                    this.zzsy();
                    return;
                }
                this.zzanY.disconnect();
            }
        }

        @WorkerThread
        private Api.zze zzb(com.google.android.gms.common.api.zzc zzc2) {
            Api api = zzc2.zzrl();
            if (api.zzrf()) {
                Api.zzh zzh2 = api.zzrd();
                return new zzag(zzc2.getApplicationContext(), zzoj.this.mHandler.getLooper(), zzh2.zzri(), this, this, zzg.zzau(zzc2.getApplicationContext()), zzh2.zzr(zzc2.zzrm()));
            }
            return zzc2.zzrl().zzrc().zza(zzc2.getApplicationContext(), zzoj.this.mHandler.getLooper(), zzg.zzau(zzc2.getApplicationContext()), zzc2.zzrm(), this, this);
        }

        @WorkerThread
        private void connect() {
            if (this.zzanY.isConnected() || this.zzanY.isConnecting()) {
                return;
            }
            if (this.zzanY.zzrg() && zzoj.this.zzanM != 0) {
                zzoj.this.zzanM = zzoj.this.zzaln.isGooglePlayServicesAvailable(zzoj.this.mContext);
                if (zzoj.this.zzanM != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(zzoj.this.zzanM, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
            this.zzanY.zza(new zzd(this.zzanY, this.zzakV));
        }

        @WorkerThread
        public void zzb(zzns zzns2) {
            this.zzaob.add(zzns2);
        }

        @WorkerThread
        private void zzj(ConnectionResult connectionResult) {
            for (zzns zzns2 : this.zzaob) {
                zzns2.zza(this.zzakV, connectionResult);
            }
            this.zzaob.clear();
        }

        boolean isConnected() {
            return this.zzanY.isConnected();
        }
    }
}

