/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqz;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzab.zzb((Object)status, (Object)"Result must not be null");
        zzqz zzqz2 = new zzqz(Looper.getMainLooper());
        zzqz2.zzc(status);
        return zzqz2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzab.zzb((Object)status, (Object)"Result must not be null");
        zzqz zzqz2 = new zzqz(googleApiClient);
        zzqz2.zzc(status);
        return zzqz2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzab.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zzc(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zzc(r);
        return new zzqv(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zzc(r);
        return new zzqv(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzqz zzqz2 = new zzqz(Looper.getMainLooper());
        zzqz2.cancel();
        return zzqz2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzab.zzb(r, (Object)"Result must not be null");
        zzab.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends zzpt<R> {
        private final R sb;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.sb = r;
        }

        @Override
        protected R zzc(Status status) {
            if (status.getStatusCode() != this.sb.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.sb;
        }
    }

    private static final class zzb<R extends Result>
    extends zzpt<R> {
        private final R sc;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.sc = r;
        }

        @Override
        protected R zzc(Status status) {
            return this.sc;
        }
    }

    private static final class zzc<R extends Result>
    extends zzpt<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzc(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

