/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzf;
import java.util.LinkedList;

public abstract class zza<T extends LifecycleDelegate> {
    private T LQ;
    private Bundle LR;
    private LinkedList<zza> LS;
    private final zzf<T> LT = new zzf<T>(){

        public void zza(T t) {
            zza.this.LQ = t;
            for (zza zza2 : zza.this.LS) {
                zza2.zzb(zza.this.LQ);
            }
            zza.this.LS.clear();
            zza.this.LR = null;
        }
    };

    public T zzbcr() {
        return this.LQ;
    }

    private void zzmz(int n) {
        while (!this.LS.isEmpty() && this.LS.getLast().getState() >= n) {
            this.LS.removeLast();
        }
    }

    private void zza(Bundle bundle, zza zza2) {
        if (this.LQ != null) {
            zza2.zzb((LifecycleDelegate)this.LQ);
            return;
        }
        if (this.LS == null) {
            this.LS = new LinkedList();
        }
        this.LS.add(zza2);
        if (bundle != null) {
            if (this.LR == null) {
                this.LR = (Bundle)bundle.clone();
            } else {
                this.LR.putAll(bundle);
            }
        }
        this.zza(this.LT);
    }

    protected abstract void zza(zzf<T> var1);

    public void onInflate(final Activity activity, final Bundle bundle, final Bundle bundle2) {
        this.zza(bundle2, new zza(){

            @Override
            public int getState() {
                return 0;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.LQ.onInflate(activity, bundle, bundle2);
            }
        });
    }

    public void onCreate(final Bundle bundle) {
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.LQ.onCreate(bundle);
            }
        });
    }

    public View onCreateView(final LayoutInflater layoutInflater, final ViewGroup viewGroup, final Bundle bundle) {
        final FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zza(bundle, new zza(){

            @Override
            public int getState() {
                return 2;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                frameLayout.removeAllViews();
                frameLayout.addView(zza.this.LQ.onCreateView(layoutInflater, viewGroup, bundle));
            }
        });
        if (this.LQ == null) {
            this.zza(frameLayout);
        }
        return frameLayout;
    }

    protected void zza(FrameLayout frameLayout) {
        zza.zzb(frameLayout);
    }

    public static void zzb(FrameLayout frameLayout) {
        final Context context = frameLayout.getContext();
        final int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
        String string2 = zzh.zzc(context, n, GooglePlayServicesUtil.zzbv((Context)context));
        String string3 = zzh.zzh(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        if (string3 != null) {
            Button button = new Button(context);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    context.startActivity(GooglePlayServicesUtil.zzfb(n));
                }
            });
        }
    }

    public void onStart() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 4;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.LQ.onStart();
            }
        });
    }

    public void onResume() {
        this.zza(null, new zza(){

            @Override
            public int getState() {
                return 5;
            }

            @Override
            public void zzb(LifecycleDelegate lifecycleDelegate) {
                zza.this.LQ.onResume();
            }
        });
    }

    public void onPause() {
        if (this.LQ != null) {
            this.LQ.onPause();
        } else {
            this.zzmz(5);
        }
    }

    public void onStop() {
        if (this.LQ != null) {
            this.LQ.onStop();
        } else {
            this.zzmz(4);
        }
    }

    public void onDestroyView() {
        if (this.LQ != null) {
            this.LQ.onDestroyView();
        } else {
            this.zzmz(2);
        }
    }

    public void onDestroy() {
        if (this.LQ != null) {
            this.LQ.onDestroy();
        } else {
            this.zzmz(1);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.LQ != null) {
            this.LQ.onSaveInstanceState(bundle);
        } else if (this.LR != null) {
            bundle.putAll(this.LR);
        }
    }

    public void onLowMemory() {
        if (this.LQ != null) {
            this.LQ.onLowMemory();
        }
    }

    private static interface zza {
        public int getState();

        public void zzb(LifecycleDelegate var1);
    }
}

