/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzqn;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzpp
extends zzps {
    private final SparseArray<zza> ss = new SparseArray();

    public static zzpp zza(zzqn zzqn2) {
        zzqp zzqp2 = zzpp.zzc((zzqn)zzqn2);
        zzpp zzpp2 = (zzpp)zzqp2.zza("AutoManageHelper", zzpp.class);
        if (zzpp2 != null) {
            return zzpp2;
        }
        return new zzpp(zzqp2);
    }

    private zzpp(zzqp zzqp2) {
        super(zzqp2);
        this.va.zza("AutoManageHelper", (zzqo)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzab.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzab.zza((this.ss.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.sB;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.ss.put(n, (Object)zza2);
        if (this.mStarted && !this.sB) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzff(int n) {
        zza zza2 = (zza)this.ss.get(n);
        this.ss.remove(n);
        if (zza2 != null) {
            zza2.zzaom();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.ss);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.sB) {
            for (n = 0; n < this.ss.size(); ++n) {
                object = (zza)this.ss.valueAt(n);
                ((zza)object).su.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.ss.size(); ++i) {
            zza zza2 = (zza)this.ss.valueAt(i);
            zza2.su.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.ss.size(); ++i) {
            zza zza2 = (zza)this.ss.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.ss.get(n);
        if (zza2 != null) {
            this.zzff(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.sv;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzaol() {
        for (int i = 0; i < this.ss.size(); ++i) {
            zza zza2 = (zza)this.ss.valueAt(i);
            zza2.su.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int st;
        public final GoogleApiClient su;
        public final GoogleApiClient.OnConnectionFailedListener sv;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.st = n;
            this.su = googleApiClient;
            this.sv = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzpp.this.zzb(connectionResult, this.st);
        }

        public void zzaom() {
            this.su.unregisterConnectionFailedListener(this);
            this.su.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.st);
            printWriter.println(":");
            this.su.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

