/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzrc;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zzpt<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> sI = new ThreadLocal<Boolean>(){

        protected Boolean zzaov() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzaov();
        }
    };
    private final Object sJ = new Object();
    protected final zza<R> sK;
    protected final WeakReference<GoogleApiClient> sL;
    private final CountDownLatch zzalc = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> sM = new ArrayList();
    private ResultCallback<? super R> sN;
    private R sc;
    private zzb sO;
    private volatile boolean sP;
    private boolean zzak;
    private boolean sQ;
    private zzr sR;
    private volatile zzrc<R> sS;
    private boolean sT = false;

    @Deprecated
    zzpt() {
        this.sK = new zza(Looper.getMainLooper());
        this.sL = new WeakReference<Object>(null);
    }

    protected zzpt(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.sK = new zza(looper);
        this.sL = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzpt(Looper looper) {
        this.sK = new zza(looper);
        this.sL = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzalc.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzab.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzab.zza((this.sS == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzalc.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzaa(Status.sh);
        }
        zzab.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzab.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzab.zza((this.sS == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzalc.await(l, timeUnit);
            if (!bl) {
                this.zzaa(Status.sj);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzaa(Status.sh);
        }
        zzab.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.sJ;
        synchronized (object) {
            if (resultCallback == null) {
                this.sN = null;
                return;
            }
            zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzab.zza((this.sS == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.sK.zza(resultCallback, (R)this.get());
            } else {
                this.sN = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.sJ;
        synchronized (object) {
            if (resultCallback == null) {
                this.sN = null;
                return;
            }
            zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzab.zza((this.sS == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.sK.zza(resultCallback, (R)this.get());
            } else {
                this.sN = resultCallback;
                this.sK.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzab.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.sJ;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzv(this.sc.getStatus());
            } else {
                this.sM.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.sJ;
        synchronized (object) {
            if (this.zzak || this.sP) {
                return;
            }
            if (this.sR != null) {
                try {
                    this.sR.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzpt.zze(this.sc);
            this.zzak = true;
            this.zzd(this.zzc(Status.sk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzaos() {
        Object object = this.sJ;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.sL.get();
            if (googleApiClient == null || !this.sT) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.sJ;
        synchronized (object) {
            return this.zzak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.sJ;
        synchronized (object) {
            zzab.zza((this.sS == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzab.zza((this.sN == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            this.sT = true;
            this.sS = new zzrc(this.sL);
            TransformedResult<? extends S> transformedResult = this.sS.then(resultTransform);
            if (this.isReady()) {
                this.sK.zza(this.sS, this.get());
            } else {
                this.sN = this.sS;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(R r) {
        Object object = this.sJ;
        synchronized (object) {
            if (this.sQ || this.zzak || this.isReady() && this.zzaou()) {
                zzpt.zze(r);
                return;
            }
            zzab.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzd(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzaa(Status status) {
        Object object = this.sJ;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzc(this.zzc(status));
                this.sQ = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    protected void zzaop() {
    }

    @Override
    public Integer zzaog() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzr zzr2) {
        Object object = this.sJ;
        synchronized (object) {
            this.sR = zzr2;
        }
    }

    public void zzaot() {
        this.sT = this.sT || sI.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.sJ;
        synchronized (object) {
            zzab.zza((!this.sP ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzab.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.sc;
            this.sc = null;
            this.sN = null;
            this.sP = true;
        }
        this.zzaop();
        return r;
    }

    boolean zzaou() {
        return false;
    }

    private void zzd(R r) {
        this.sc = r;
        this.sR = null;
        this.zzalc.countDown();
        Status status = this.sc.getStatus();
        if (this.zzak) {
            this.sN = null;
        } else if (this.sN == null) {
            if (this.sc instanceof Releasable) {
                this.sO = new zzb();
            }
        } else {
            this.sK.zzaow();
            this.sK.zza(this.sN, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.sM) {
            zza2.zzv(status);
        }
        this.sM.clear();
    }

    public static void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zzpt.zze(zzpt.this.sc);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzpt<R> zzpt2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzpt2), l);
        }

        public void zzaow() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzpt zzpt2 = (zzpt)message.obj;
                    zzpt2.zzaa(Status.sj);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzpt.zze(r);
                throw runtimeException;
            }
        }
    }
}

