/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzaca;
import com.google.android.gms.internal.measurement.zzacb;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzjr;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjt;
import com.google.android.gms.internal.measurement.zzkd;
import com.google.android.gms.internal.measurement.zzkm;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzko;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.IOException;
import java.util.Map;

public final class zzgh
extends zzjs
implements zzej {
    @VisibleForTesting
    private static int zzane = 65535;
    @VisibleForTesting
    private static int zzanf = 2;
    private final Map<String, Map<String, String>> zzang = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzanh = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzani = new ArrayMap();
    private final Map<String, zzkn> zzanj = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzank;
    private final Map<String, String> zzanl = new ArrayMap();

    zzgh(zzjt zzjt2) {
        super(zzjt2);
        this.zzank = new ArrayMap();
    }

    @WorkerThread
    private final void zzbw(String string) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzanj.get(string) == null) {
            byte[] byArray = ((zzjr)this).zzjh().zzbh(string);
            if (byArray == null) {
                this.zzang.put(string, null);
                this.zzanh.put(string, null);
                this.zzani.put(string, null);
                this.zzanj.put(string, null);
                this.zzanl.put(string, null);
                this.zzank.put(string, null);
                return;
            }
            zzkn zzkn2 = this.zza(string, byArray);
            this.zzang.put(string, zzgh.zza(zzkn2));
            this.zza(string, zzkn2);
            this.zzanj.put(string, zzkn2);
            this.zzanl.put(string, null);
        }
    }

    @WorkerThread
    protected final zzkn zzbx(String string) {
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        this.zzbw(string);
        return this.zzanj.get(string);
    }

    @WorkerThread
    protected final String zzby(String string) {
        this.zzab();
        return this.zzanl.get(string);
    }

    @WorkerThread
    protected final void zzbz(String string) {
        this.zzab();
        this.zzanl.put(string, null);
    }

    @WorkerThread
    final void zzca(String string) {
        this.zzab();
        this.zzanj.remove(string);
    }

    @WorkerThread
    public final String zze(String string, String string2) {
        this.zzab();
        this.zzbw(string);
        Map<String, String> map = this.zzang.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzkn zzkn2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzkn2 != null && zzkn2.zzauo != null) {
            zzko[] zzkoArray = zzkn2.zzauo;
            int n = zzkn2.zzauo.length;
            for (int i = 0; i < n; ++i) {
                zzko zzko2 = zzkoArray[i];
                if (zzko2 == null) continue;
                arrayMap.put(zzko2.zzny, zzko2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzkn zzkn2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzkn2 != null && zzkn2.zzaup != null) {
            zzkm[] zzkmArray = zzkn2.zzaup;
            int n = zzkn2.zzaup.length;
            for (int i = 0; i < n; ++i) {
                zzkm zzkm2 = zzkmArray[i];
                if (TextUtils.isEmpty((CharSequence)zzkm2.name)) {
                    this.zzgi().zziy().log("EventConfig contained null event name");
                    continue;
                }
                String string2 = AppMeasurement.Event.zzal((String)zzkm2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzkm2.name = string2;
                }
                arrayMap.put(zzkm2.name, zzkm2.zzauj);
                arrayMap2.put(zzkm2.name, zzkm2.zzauk);
                if (zzkm2.zzaul == null) continue;
                if (zzkm2.zzaul < zzanf || zzkm2.zzaul > zzane) {
                    this.zzgi().zziy().zze("Invalid sampling rate. Event name, sample rate", (Object)zzkm2.name, (Object)zzkm2.zzaul);
                    continue;
                }
                arrayMap3.put(zzkm2.name, zzkm2.zzaul);
            }
        }
        this.zzanh.put(string, (Map<String, Boolean>)arrayMap);
        this.zzani.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzank.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        Object object;
        this.zzch();
        this.zzab();
        Preconditions.checkNotEmpty((String)string);
        zzkn zzkn2 = this.zza(string, byArray);
        if (zzkn2 == null) {
            return false;
        }
        this.zza(string, zzkn2);
        this.zzanj.put(string, zzkn2);
        this.zzanl.put(string, string2);
        this.zzang.put(string, zzgh.zza(zzkn2));
        ((zzjr)this).zzjg().zza(string, zzkn2.zzauq);
        try {
            zzkn2.zzauq = null;
            byte[] byArray2 = new byte[zzkn2.zzwb()];
            object = byArray2;
            zzacb zzacb2 = zzacb.zzb((byte[])byArray2, (int)0, (int)((byte[])object).length);
            zzkn2.zza(zzacb2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzgi().zziy().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzfi.zzbp((String)string), (Object)iOException);
        }
        byte[] byArray3 = byArray;
        String string3 = string;
        object = (Object)((zzjr)this).zzjh();
        Preconditions.checkNotEmpty((String)string3);
        object.zzab();
        ((zzjs)((Object)object)).zzch();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray3);
        try {
            if ((long)((zzek)((Object)object)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object.zzgi().zziv().zzg("Failed to update remote config (got 0). appId", zzfi.zzbp((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object.zzgi().zziv().zze("Error storing remote config. appId", zzfi.zzbp((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzn(String string, String string2) {
        this.zzab();
        this.zzbw(string);
        if (this.zzcb(string) && zzkd.zzcm((String)string2)) {
            return true;
        }
        if (this.zzcc(string) && zzkd.zzcg((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzanh.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        this.zzab();
        this.zzbw(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzani.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzp(String string, String string2) {
        this.zzab();
        this.zzbw(string);
        Map<String, Integer> map = this.zzank.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    private final zzkn zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzkn();
        }
        byte[] byArray2 = byArray;
        zzaca zzaca2 = zzaca.zza((byte[])byArray, (int)0, (int)byArray2.length);
        zzkn zzkn2 = new zzkn();
        try {
            zzkn2.zzb(zzaca2);
            this.zzgi().zzjc().zze("Parsed config. version, gmp_app_id", (Object)zzkn2.zzaum, (Object)zzkn2.zzafa);
        }
        catch (IOException iOException) {
            this.zzgi().zziy().zze("Unable to merge remote config. appId", zzfi.zzbp((String)string), (Object)iOException);
            return new zzkn();
        }
        return zzkn2;
    }

    final boolean zzcb(String string) {
        return "1".equals(this.zze(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzcc(String string) {
        return "1".equals(this.zze(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzgn() {
        return false;
    }
}

