/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzgg;
import com.google.android.gms.internal.measurement.zzgh;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzyy;
import com.google.android.gms.internal.measurement.zzza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzfg
extends zzez {
    zzfg(zzfa zzfa2) {
        super(zzfa2);
    }

    @Override
    protected final boolean zzgt() {
        return false;
    }

    final void zza(zzgl zzgl2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgl2.zzamp = null;
        zzgl2.zzawx = null;
        zzgl2.zzauh = null;
        if (object instanceof String) {
            zzgl2.zzamp = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzgl2.zzawx = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzgl2.zzauh = (Double)object;
            return;
        }
        this.zzgo().zzjd().zzg("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzgg zzgg2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzgg2.zzamp = null;
        zzgg2.zzawx = null;
        zzgg2.zzauh = null;
        if (object instanceof String) {
            zzgg2.zzamp = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzgg2.zzawx = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzgg2.zzauh = (Double)object;
            return;
        }
        this.zzgo().zzjd().zzg("Ignoring invalid (type) event param value", object);
    }

    final byte[] zza(zzgh zzgh2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzgh2.zzvu()];
            zzyy zzyy2 = zzyy.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgh2.zza(zzyy2);
            zzyy2.zzyt();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zzg("Data loss. Failed to serialize batch", (Object)iOException);
            return null;
        }
    }

    static zzgg zza(zzgf zzgf2, String string) {
        zzgg[] zzggArray = zzgf2.zzawt;
        int n = zzgf2.zzawt.length;
        for (int i = 0; i < n; ++i) {
            zzgg zzgg2 = zzggArray[i];
            if (!zzgg2.name.equals(string)) continue;
            return zzgg2;
        }
        return null;
    }

    static Object zzb(zzgf zzgf2, String string) {
        zzgg zzgg2 = zzfg.zza(zzgf2, string);
        if (zzgg2 != null) {
            if (zzgg2.zzamp != null) {
                return zzgg2.zzamp;
            }
            if (zzgg2.zzawx != null) {
                return zzgg2.zzawx;
            }
            if (zzgg2.zzauh != null) {
                return zzgg2.zzauh;
            }
        }
        return null;
    }

    static zzgg[] zza(zzgg[] zzggArray, String string, Object object) {
        zzgg[] zzggArray2 = zzggArray;
        int n = zzggArray.length;
        for (int i = 0; i < n; ++i) {
            zzgg zzgg2 = zzggArray2[i];
            if (!string.equals(zzgg2.name)) continue;
            zzgg2.zzawx = null;
            zzgg2.zzamp = null;
            zzgg2.zzauh = null;
            if (object instanceof Long) {
                zzgg2.zzawx = (Long)object;
            } else if (object instanceof String) {
                zzgg2.zzamp = (String)object;
            } else if (object instanceof Double) {
                zzgg2.zzauh = (Double)object;
            }
            return zzggArray;
        }
        zzggArray2 = new zzgg[zzggArray.length + 1];
        System.arraycopy(zzggArray, 0, zzggArray2, 0, zzggArray.length);
        zzgg zzgg3 = new zzgg();
        new zzgg().name = string;
        if (object instanceof Long) {
            zzgg3.zzawx = (Long)object;
        } else if (object instanceof String) {
            zzgg3.zzamp = (String)object;
        } else if (object instanceof Double) {
            zzgg3.zzauh = (Double)object;
        }
        zzggArray2[zzggArray.length] = zzgg3;
        return zzggArray2;
    }

    final String zzb(zzgh zzgh2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzgh2.zzawy != null) {
            zzgi[] zzgiArray = zzgh2.zzawy;
            int n = zzgh2.zzawy.length;
            for (int i = 0; i < n; ++i) {
                zzgl zzgl2;
                int n2;
                int n3;
                zzgl[] zzglArray;
                zzgi zzgi2 = zzgiArray[i];
                if (zzgi2 == null) continue;
                zzgi zzgi3 = zzgi2;
                StringBuilder stringBuilder2 = stringBuilder;
                zzfg zzfg2 = this;
                if (zzgi3 == null) continue;
                zzfg.zza(stringBuilder2, 1);
                stringBuilder2.append("bundle {\n");
                zzfg.zza(stringBuilder2, 1, "protocol_version", zzgi3.zzaxa);
                zzfg.zza(stringBuilder2, 1, "platform", zzgi3.zzaxi);
                zzfg.zza(stringBuilder2, 1, "gmp_version", zzgi3.zzaxm);
                zzfg.zza(stringBuilder2, 1, "uploading_gmp_version", zzgi3.zzaxn);
                zzfg.zza(stringBuilder2, 1, "config_version", zzgi3.zzaxy);
                zzfg.zza(stringBuilder2, 1, "gmp_app_id", zzgi3.zzafx);
                zzfg.zza(stringBuilder2, 1, "admob_app_id", zzgi3.zzawj);
                zzfg.zza(stringBuilder2, 1, "app_id", zzgi3.zztt);
                zzfg.zza(stringBuilder2, 1, "app_version", zzgi3.zzts);
                zzfg.zza(stringBuilder2, 1, "app_version_major", zzgi3.zzaxu);
                zzfg.zza(stringBuilder2, 1, "firebase_instance_id", zzgi3.zzafz);
                zzfg.zza(stringBuilder2, 1, "dev_cert_hash", zzgi3.zzaxq);
                zzfg.zza(stringBuilder2, 1, "app_store", zzgi3.zzage);
                zzfg.zza(stringBuilder2, 1, "upload_timestamp_millis", zzgi3.zzaxd);
                zzfg.zza(stringBuilder2, 1, "start_timestamp_millis", zzgi3.zzaxe);
                zzfg.zza(stringBuilder2, 1, "end_timestamp_millis", zzgi3.zzaxf);
                zzfg.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzgi3.zzaxg);
                zzfg.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzgi3.zzaxh);
                zzfg.zza(stringBuilder2, 1, "app_instance_id", zzgi3.zzafw);
                zzfg.zza(stringBuilder2, 1, "resettable_device_id", zzgi3.zzaxo);
                zzfg.zza(stringBuilder2, 1, "device_id", zzgi3.zzaxx);
                zzfg.zza(stringBuilder2, 1, "ds_id", zzgi3.zzaya);
                zzfg.zza(stringBuilder2, 1, "limited_ad_tracking", zzgi3.zzaxp);
                zzfg.zza(stringBuilder2, 1, "os_version", zzgi3.zzaxj);
                zzfg.zza(stringBuilder2, 1, "device_model", zzgi3.zzaxk);
                zzfg.zza(stringBuilder2, 1, "user_default_language", zzgi3.zzaia);
                zzfg.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzgi3.zzaxl);
                zzfg.zza(stringBuilder2, 1, "bundle_sequential_index", zzgi3.zzaxr);
                zzfg.zza(stringBuilder2, 1, "service_upload", zzgi3.zzaxs);
                zzfg.zza(stringBuilder2, 1, "health_monitor", zzgi3.zzagv);
                if (zzgi3.zzaxz != null && zzgi3.zzaxz != 0L) {
                    zzfg.zza(stringBuilder2, 1, "android_id", zzgi3.zzaxz);
                }
                if (zzgi3.zzayc != null) {
                    zzfg.zza(stringBuilder2, 1, "retry_counter", zzgi3.zzayc);
                }
                zzza[] zzzaArray = zzgi3.zzaxc;
                StringBuilder stringBuilder3 = stringBuilder2;
                zzfg zzfg3 = zzfg2;
                if (zzzaArray != null) {
                    zzglArray = zzzaArray;
                    n3 = zzzaArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzgl2 = zzglArray[n2];
                        if (zzgl2 == null) continue;
                        zzfg.zza(stringBuilder3, 2);
                        stringBuilder3.append("user_property {\n");
                        zzfg.zza(stringBuilder3, 2, "set_timestamp_millis", zzgl2.zzayl);
                        zzfg.zza(stringBuilder3, 2, "name", zzfg3.zzgl().zzbu(zzgl2.name));
                        zzfg.zza(stringBuilder3, 2, "string_value", zzgl2.zzamp);
                        zzfg.zza(stringBuilder3, 2, "int_value", zzgl2.zzawx);
                        zzfg.zza(stringBuilder3, 2, "double_value", zzgl2.zzauh);
                        zzfg.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzzaArray = zzgi3.zzaxt;
                stringBuilder3 = stringBuilder2;
                if (zzzaArray != null) {
                    zzglArray = zzzaArray;
                    n3 = zzzaArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzgl2 = zzglArray[n2];
                        if (zzgl2 == null) continue;
                        zzfg.zza(stringBuilder3, 2);
                        stringBuilder3.append("audience_membership {\n");
                        zzfg.zza(stringBuilder3, 2, "audience_id", ((zzgd)((Object)zzgl2)).zzauy);
                        zzfg.zza(stringBuilder3, 2, "new_audience", ((zzgd)((Object)zzgl2)).zzawo);
                        zzfg.zza(stringBuilder3, 2, "current_data", ((zzgd)((Object)zzgl2)).zzawm);
                        zzfg.zza(stringBuilder3, 2, "previous_data", ((zzgd)((Object)zzgl2)).zzawn);
                        zzfg.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzzaArray = zzgi3.zzaxb;
                stringBuilder3 = stringBuilder2;
                zzfg3 = zzfg2;
                if (zzzaArray != null) {
                    zzglArray = zzzaArray;
                    n3 = zzzaArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzgl2 = zzglArray[n2];
                        if (zzgl2 == null) continue;
                        zzfg.zza(stringBuilder3, 2);
                        stringBuilder3.append("event {\n");
                        zzfg.zza(stringBuilder3, 2, "name", zzfg3.zzgl().zzbs(((zzgf)((Object)zzgl2)).name));
                        zzfg.zza(stringBuilder3, 2, "timestamp_millis", ((zzgf)((Object)zzgl2)).zzawu);
                        zzfg.zza(stringBuilder3, 2, "previous_timestamp_millis", ((zzgf)((Object)zzgl2)).zzawv);
                        zzfg.zza(stringBuilder3, 2, "count", ((zzgf)((Object)zzgl2)).count);
                        zzgg[] zzggArray = ((zzgf)((Object)zzgl2)).zzawt;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        zzfg zzfg4 = zzfg3;
                        if (zzggArray != null) {
                            zzgg[] zzggArray2 = zzggArray;
                            int n4 = zzggArray.length;
                            for (int j = 0; j < n4; ++j) {
                                zzgg zzgg2 = zzggArray2[j];
                                if (zzgg2 == null) continue;
                                zzfg.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzfg.zza(stringBuilder4, 3, "name", zzfg4.zzgl().zzbt(zzgg2.name));
                                zzfg.zza(stringBuilder4, 3, "string_value", zzgg2.zzamp);
                                zzfg.zza(stringBuilder4, 3, "int_value", zzgg2.zzawx);
                                zzfg.zza(stringBuilder4, 3, "double_value", zzgg2.zzauh);
                                zzfg.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                        zzfg.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzfg.zza(stringBuilder2, 1);
                stringBuilder2.append("}\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfv zzfv2) {
        if (zzfv2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzfg.zza(stringBuilder, 0, "filter_id", zzfv2.zzave);
        zzfg.zza(stringBuilder, 0, "event_name", this.zzgl().zzbs(zzfv2.zzavf));
        this.zza(stringBuilder, 1, "event_count_filter", zzfv2.zzavi);
        stringBuilder.append("  filters {\n");
        zzfw[] zzfwArray = zzfv2.zzavg;
        int n = zzfv2.zzavg.length;
        for (int i = 0; i < n; ++i) {
            zzfw zzfw2 = zzfwArray[i];
            this.zza(stringBuilder, 2, zzfw2);
        }
        zzfg.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfy zzfy2) {
        if (zzfy2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzfg.zza(stringBuilder, 0, "filter_id", zzfy2.zzave);
        zzfg.zza(stringBuilder, 0, "property_name", this.zzgl().zzbu(zzfy2.zzavu));
        this.zza(stringBuilder, 1, zzfy2.zzavv);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzgj zzgj2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzgj2 == null) {
            return;
        }
        zzfg.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzgj2.zzayf != null) {
            zzfg.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzgj2.zzayf;
            n3 = zzgj2.zzayf.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzgj2.zzaye != null) {
            zzfg.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzgj2.zzaye;
            n3 = zzgj2.zzaye.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzfg.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzfx zzfx2) {
        if (zzfx2 == null) {
            return;
        }
        zzfg.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzfx2.zzavo != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzfx2.zzavo) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzfg.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzfg.zza(stringBuilder, n, "match_as_float", zzfx2.zzavp);
        zzfg.zza(stringBuilder, n, "comparison_value", zzfx2.zzavq);
        zzfg.zza(stringBuilder, n, "min_comparison_value", zzfx2.zzavr);
        zzfg.zza(stringBuilder, n, "max_comparison_value", zzfx2.zzavs);
        zzfg.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfw zzfw2) {
        if (zzfw2 == null) {
            return;
        }
        zzfg.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzfg.zza(stringBuilder, n, "complement", zzfw2.zzavm);
        zzfg.zza(stringBuilder, n, "param_name", this.zzgl().zzbt(zzfw2.zzavn));
        zzfz zzfz2 = zzfw2.zzavk;
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        if (zzfz2 != null) {
            String[] stringArray;
            zzfg.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zzfz2.zzavw != null) {
                stringArray = "UNKNOWN_MATCH_TYPE";
                switch (zzfz2.zzavw) {
                    case 1: {
                        stringArray = "REGEXP";
                        break;
                    }
                    case 2: {
                        stringArray = "BEGINS_WITH";
                        break;
                    }
                    case 3: {
                        stringArray = "ENDS_WITH";
                        break;
                    }
                    case 4: {
                        stringArray = "PARTIAL";
                        break;
                    }
                    case 5: {
                        stringArray = "EXACT";
                        break;
                    }
                    case 6: {
                        stringArray = "IN_LIST";
                    }
                }
                zzfg.zza(stringBuilder2, n2, "match_type", stringArray);
            }
            zzfg.zza(stringBuilder2, n2, "expression", zzfz2.zzavx);
            zzfg.zza(stringBuilder2, n2, "case_sensitive", zzfz2.zzavy);
            if (zzfz2.zzavz.length > 0) {
                zzfg.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                stringArray = zzfz2.zzavz;
                int n3 = zzfz2.zzavz.length;
                for (int i = 0; i < n3; ++i) {
                    String string2 = stringArray[i];
                    zzfg.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzfg.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzfw2.zzavl);
        zzfg.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzfg.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzgo().zzjd().zzbx("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zze(zzad zzad2, zzh zzh2) {
        Preconditions.checkNotNull((Object)zzad2);
        Preconditions.checkNotNull((Object)zzh2);
        if (TextUtils.isEmpty((CharSequence)zzh2.zzafx) && TextUtils.isEmpty((CharSequence)zzh2.zzagk)) {
            zzk zzk2 = this.zzgr();
            return false;
        }
        return true;
    }

    static boolean zzcp(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    final boolean zzb(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzbx().currentTimeMillis() - l) > l2;
    }

    final byte[] zza(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zzg("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgo().zzjd().zzg("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }
}

