/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgd;
import com.google.android.gms.internal.measurement.zzge;
import com.google.android.gms.internal.measurement.zzgf;
import com.google.android.gms.internal.measurement.zzzi;
import com.google.android.gms.internal.measurement.zzzj;
import com.google.android.gms.internal.measurement.zzzl;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import java.io.IOException;
import java.util.Map;

public final class zzbo
extends zzfj
implements zzq {
    @VisibleForTesting
    private static int zzaot = 65535;
    @VisibleForTesting
    private static int zzaou = 2;
    private final Map<String, Map<String, String>> zzaov = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaow = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaox = new ArrayMap();
    private final Map<String, zzge> zzaoy = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzaoz;
    private final Map<String, String> zzapa = new ArrayMap();

    zzbo(zzfk zzfk2) {
        super(zzfk2);
        this.zzaoz = new ArrayMap();
    }

    @WorkerThread
    private final void zzch(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzaoy.get(string) == null) {
            byte[] byArray = ((zzfi)this).zzjt().zzbq(string);
            if (byArray == null) {
                this.zzaov.put(string, null);
                this.zzaow.put(string, null);
                this.zzaox.put(string, null);
                this.zzaoy.put(string, null);
                this.zzapa.put(string, null);
                this.zzaoz.put(string, null);
                return;
            }
            zzge zzge2 = this.zza(string, byArray);
            this.zzaov.put(string, zzbo.zza(zzge2));
            this.zza(string, zzge2);
            this.zzaoy.put(string, zzge2);
            this.zzapa.put(string, null);
        }
    }

    @WorkerThread
    protected final zzge zzci(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        this.zzch(string);
        return this.zzaoy.get(string);
    }

    @WorkerThread
    protected final String zzcj(String string) {
        this.zzaf();
        return this.zzapa.get(string);
    }

    @WorkerThread
    protected final void zzck(String string) {
        this.zzaf();
        this.zzapa.put(string, null);
    }

    @WorkerThread
    final void zzcl(String string) {
        this.zzaf();
        this.zzaoy.remove(string);
    }

    @WorkerThread
    public final String zzf(String string, String string2) {
        this.zzaf();
        this.zzch(string);
        Map<String, String> map = this.zzaov.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzge zzge2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzge2 != null && zzge2.zzawz != null) {
            zzgf[] zzgfArray = zzge2.zzawz;
            int n = zzge2.zzawz.length;
            for (int i = 0; i < n; ++i) {
                zzgf zzgf2 = zzgfArray[i];
                if (zzgf2 == null) continue;
                arrayMap.put(zzgf2.zzoj, zzgf2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzge zzge2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzge2 != null && zzge2.zzaxa != null) {
            zzgd[] zzgdArray = zzge2.zzaxa;
            int n = zzge2.zzaxa.length;
            for (int i = 0; i < n; ++i) {
                zzgd zzgd2 = zzgdArray[i];
                if (TextUtils.isEmpty((CharSequence)zzgd2.name)) {
                    this.zzgt().zzjj().zzca("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzcs.zzcq((String)zzgd2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzgd2.name = string2;
                }
                arrayMap.put(zzgd2.name, zzgd2.zzawu);
                arrayMap2.put(zzgd2.name, zzgd2.zzawv);
                if (zzgd2.zzaww == null) continue;
                if (zzgd2.zzaww < zzaou || zzgd2.zzaww > zzaot) {
                    this.zzgt().zzjj().zze("Invalid sampling rate. Event name, sample rate", (Object)zzgd2.name, (Object)zzgd2.zzaww);
                    continue;
                }
                arrayMap3.put(zzgd2.name, zzgd2.zzaww);
            }
        }
        this.zzaow.put(string, (Map<String, Boolean>)arrayMap);
        this.zzaox.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzaoz.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        zzge zzge2 = this.zza(string, byArray);
        if (zzge2 == null) {
            return false;
        }
        this.zza(string, zzge2);
        this.zzaoy.put(string, zzge2);
        this.zzapa.put(string, string2);
        this.zzaov.put(string, zzbo.zza(zzge2));
        Object object = zzge2.zzaxb;
        String string3 = string;
        Object object2 = ((zzfi)this).zzjs();
        Preconditions.checkNotNull((Object)object);
        for (zzfx zzfx2 : object) {
            String string4;
            zzfy zzfy2;
            int n;
            zzzl[] zzzlArray = zzfx2.zzavt;
            int n2 = zzfx2.zzavt.length;
            for (n = 0; n < n2; ++n) {
                zzfy2 = zzzlArray[n];
                string4 = zzcs.zzcq((String)zzfy2.zzavy);
                if (string4 != null) {
                    zzfy2.zzavy = string4;
                }
                zzfz[] zzfzArray = zzfy2.zzavz;
                int n3 = zzfy2.zzavz.length;
                for (int i = 0; i < n3; ++i) {
                    zzfz zzfz2 = zzfzArray[i];
                    String string5 = zzct.zzcq((String)zzfz2.zzawg);
                    if (string5 == null) continue;
                    zzfz2.zzawg = string5;
                }
            }
            zzzlArray = zzfx2.zzavs;
            n2 = zzfx2.zzavs.length;
            for (n = 0; n < n2; ++n) {
                zzfy2 = zzzlArray[n];
                string4 = zzcu.zzcq((String)((zzgb)((Object)zzfy2)).zzawn);
                if (string4 == null) continue;
                ((zzgb)((Object)zzfy2)).zzawn = string4;
            }
        }
        ((zzfi)((Object)object2)).zzjt().zza(string3, (zzfx[])object);
        try {
            zzge2.zzaxb = null;
            byte[] byArray2 = new byte[zzge2.zzwe()];
            object2 = byArray2;
            zzzj zzzj2 = zzzj.zzk((byte[])byArray2, (int)0, (int)((zzk)object2).length);
            zzge2.zza(zzzj2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzgt().zzjj().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzaq.zzby((String)string), (Object)iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzfi)this).zzjt();
        Preconditions.checkNotEmpty((String)string3);
        object2.zzaf();
        ((zzfj)((Object)object2)).zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzr)((Object)object2)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object2.zzgt().zzjg().zzg("Failed to update remote config (got 0). appId", zzaq.zzby((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object2.zzgt().zzjg().zze("Error storing remote config. appId", zzaq.zzby((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        this.zzaf();
        this.zzch(string);
        if (this.zzcn(string) && zzfu.zzda((String)string2)) {
            return true;
        }
        if (this.zzco(string) && zzfu.zzcv((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaow.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzp(String string, String string2) {
        this.zzaf();
        this.zzch(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaox.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzq(String string, String string2) {
        this.zzaf();
        this.zzch(string);
        Map<String, Integer> map = this.zzaoz.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzcm(String string) {
        String string2 = this.zzf(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgt().zzjj().zze("Unable to parse timezone offset. appId", zzaq.zzby((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzge zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzge();
        }
        byte[] byArray2 = byArray;
        zzzi zzzi2 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray2.length);
        zzge zzge2 = new zzge();
        try {
            zzge2.zza(zzzi2);
            this.zzgt().zzjo().zze("Parsed config. version, gmp_app_id", (Object)zzge2.zzawx, (Object)zzge2.zzafx);
        }
        catch (IOException iOException) {
            this.zzgt().zzjj().zze("Unable to merge remote config. appId", zzaq.zzby((String)string), (Object)iOException);
            return new zzge();
        }
        return zzge2;
    }

    final boolean zzcn(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzco(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }
}

