/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzl;

public final class zzeu<T extends Context> {
    private final T zzaby;

    public zzeu(T t) {
        Preconditions.checkNotNull(t);
        this.zzaby = t;
    }

    @MainThread
    public final void onCreate() {
        zzbu zzbu2 = zzbu.zza(this.zzaby, null);
        zzaq zzaq2 = zzbu2.zzgt();
        zzl zzl2 = zzbu2.zzgw();
        zzaq2.zzjo().zzca("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzbu zzbu2 = zzbu.zza(this.zzaby, null);
        zzaq zzaq2 = zzbu2.zzgt();
        zzl zzl2 = zzbu2.zzgw();
        zzaq2.zzjo().zzca("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzbu zzbu2 = zzbu.zza(this.zzaby, null);
        zzaq zzaq2 = zzbu2.zzgt();
        if (intent == null) {
            zzaq2.zzjj().zzca("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzl zzl2 = zzbu2.zzgw();
        zzaq2.zzjo().zze("Local AppMeasurementService called. startId, action", (Object)n2, (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzev(this, n2, zzaq2, intent));
        }
        return 2;
    }

    private final void zzb(Runnable runnable) {
        zzfk zzfk2 = zzfk.zzn(this.zzaby);
        zzfk2.zzgs().zzc((Runnable)new zzex(this, zzfk2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzgt().zzjg().zzca("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzbw(zzfk.zzn(this.zzaby));
        }
        this.zzgt().zzjj().zzg("onBind received unknown action", (Object)string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzgt().zzjg().zzca("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzgt().zzjo().zzg("onUnbind called for intent. action", (Object)string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzbu zzbu2 = zzbu.zza(this.zzaby, null);
        zzaq zzaq2 = zzbu2.zzgt();
        String string = jobParameters.getExtras().getString("action");
        zzl zzl2 = zzbu2.zzgw();
        zzaq2.zzjo().zzg("Local AppMeasurementJobService called. action", (Object)string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzb(new zzew(this, zzaq2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzgt().zzjg().zzca("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzgt().zzjo().zzg("onRebind called. action", (Object)string);
    }

    private final zzaq zzgt() {
        return zzbu.zza(this.zzaby, null).zzgt();
    }

    final /* synthetic */ void zza(zzaq zzaq2, JobParameters jobParameters) {
        zzaq2.zzjo().zzca("AppMeasurementJobService processed last upload request.");
        ((zzey)this.zzaby).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzaq zzaq2, Intent intent) {
        if (((zzey)this.zzaby).callServiceStopSelfResult(n)) {
            zzaq2.zzjo().zzg("Local AppMeasurementService processed last upload request. StartId", (Object)n);
            this.zzgt().zzjo().zzca("Completed wakeful intent.");
            ((zzey)this.zzaby).zzb(intent);
        }
    }
}

