/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzge;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgk;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgo;
import com.google.android.gms.internal.measurement.zzzi;
import com.google.android.gms.internal.measurement.zzzl;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbb;
import com.google.android.gms.measurement.internal.zzbo;
import com.google.android.gms.measurement.internal.zzbp;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzdt;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzz;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzfk
implements zzcr {
    private static volatile zzfk zzatt;
    private zzbo zzatu;
    private zzau zzatv;
    private zzr zzatw;
    private zzaz zzatx;
    private zzfg zzaty;
    private zzk zzatz;
    private final zzfq zzaua;
    private zzdt zzaub;
    private final zzbu zzadp;
    private boolean zzvz = false;
    private boolean zzauc;
    private boolean zzaud;
    @VisibleForTesting
    private long zzaue;
    private List<Runnable> zzauf;
    private int zzaug;
    private int zzauh;
    private boolean zzaui;
    private boolean zzauj;
    private boolean zzauk;
    private FileLock zzaul;
    private FileChannel zzaum;
    private List<Long> zzaun;
    private List<Long> zzauo;
    private long zzaup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzfk zzn(Context context) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzatt != null) return zzatt;
        Class<zzfk> clazz = zzfk.class;
        synchronized (zzfk.class) {
            if (zzatt != null) return zzatt;
            zzfp zzfp2 = new zzfp(context);
            zzatt = new zzfk(zzfp2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzatt;
        }
    }

    private zzfk(zzfp zzfp2) {
        this(zzfp2, null);
    }

    private zzfk(zzfp zzfp2, zzbu zzbu2) {
        Preconditions.checkNotNull((Object)zzfp2);
        this.zzadp = zzbu2 = zzbu.zza((Context)zzfp2.zzri, null);
        this.zzaup = -1L;
        zzfk zzfk2 = this;
        zzfq zzfq2 = new zzfq(zzfk2);
        zzfq2.zzq();
        this.zzaua = zzfq2;
        zzfk2 = this;
        zzau zzau2 = new zzau(zzfk2);
        zzau2.zzq();
        this.zzatv = zzau2;
        zzfk2 = this;
        zzbo zzbo2 = new zzbo(zzfk2);
        zzbo2.zzq();
        this.zzatu = zzbo2;
        this.zzadp.zzgs().zzc((Runnable)new zzfl(this, zzfp2));
    }

    @WorkerThread
    private final void zza(zzfp zzfp2) {
        this.zzadp.zzgs().zzaf();
        zzfk zzfk2 = this;
        zzr zzr2 = new zzr(zzfk2);
        zzr2.zzq();
        this.zzatw = zzr2;
        this.zzadp.zzgv().zza((zzq)this.zzatu);
        zzfk2 = this;
        zzk zzk2 = new zzk(zzfk2);
        zzk2.zzq();
        this.zzatz = zzk2;
        zzfk2 = this;
        zzdt zzdt2 = new zzdt(zzfk2);
        zzdt2.zzq();
        this.zzaub = zzdt2;
        zzfk2 = this;
        zzfg zzfg2 = new zzfg(zzfk2);
        zzfg2.zzq();
        this.zzaty = zzfg2;
        zzfk2 = this;
        this.zzatx = new zzaz(zzfk2);
        if (this.zzaug != this.zzauh) {
            this.zzadp.zzgt().zzjg().zze("Not all upload components initialized", (Object)this.zzaug, (Object)this.zzauh);
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        this.zzadp.zzgs().zzaf();
        this.zzjt().zzij();
        if (this.zzadp.zzgu().zzanl.get() == 0L) {
            this.zzadp.zzgu().zzanl.set(this.zzadp.zzbx().currentTimeMillis());
        }
        this.zzmb();
    }

    public final zzl zzgw() {
        return this.zzadp.zzgw();
    }

    public final zzo zzgv() {
        return this.zzadp.zzgv();
    }

    public final zzaq zzgt() {
        return this.zzadp.zzgt();
    }

    public final zzbp zzgs() {
        return this.zzadp.zzgs();
    }

    private final zzbo zzls() {
        zzfk.zza(this.zzatu);
        return this.zzatu;
    }

    public final zzau zzlt() {
        zzfk.zza(this.zzatv);
        return this.zzatv;
    }

    public final zzr zzjt() {
        zzfk.zza(this.zzatw);
        return this.zzatw;
    }

    private final zzaz zzlu() {
        if (this.zzatx == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzatx;
    }

    private final zzfg zzlv() {
        zzfk.zza(this.zzaty);
        return this.zzaty;
    }

    public final zzk zzjs() {
        zzfk.zza(this.zzatz);
        return this.zzatz;
    }

    public final zzdt zzlw() {
        zzfk.zza(this.zzaub);
        return this.zzaub;
    }

    public final zzfq zzjr() {
        zzfk.zza(this.zzaua);
        return this.zzaua;
    }

    public final zzao zzgq() {
        return this.zzadp.zzgq();
    }

    public final Context getContext() {
        return this.zzadp.getContext();
    }

    public final Clock zzbx() {
        return this.zzadp.zzbx();
    }

    public final zzfu zzgr() {
        return this.zzadp.zzgr();
    }

    @WorkerThread
    private final void zzaf() {
        this.zzadp.zzgs().zzaf();
    }

    final void zzlx() {
        if (!this.zzvz) {
            throw new IllegalStateException("UploadController is not initialized");
        }
    }

    private static void zza(zzfj zzfj2) {
        if (zzfj2 == null) {
            throw new IllegalStateException("Upload Component not created");
        }
        if (!zzfj2.isInitialized()) {
            String string = String.valueOf(((Object)((Object)zzfj2)).getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    final void zze(zzi zzi2) {
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotEmpty((String)zzi2.packageName);
        this.zzg(zzi2);
    }

    private final long zzly() {
        long l = this.zzadp.zzbx().currentTimeMillis();
        zzbb zzbb2 = this.zzadp.zzgu();
        zzbb2.zzcl();
        zzbb2.zzaf();
        long l2 = zzbb2.zzanp.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzbb2.zzgr().zzmk().nextInt(86400000);
            zzbb2.zzanp.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    final void zzd(zzae zzae2, String string) {
        zzg zzg2 = this.zzjt().zzbo(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzak())) {
            this.zzadp.zzgt().zzjn().zzg("No app data available; dropping event", (Object)string);
            return;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl == null) {
            if (!"_ui".equals(zzae2.name)) {
                this.zzadp.zzgt().zzjj().zzg("Could not find package. appId", zzaq.zzby((String)string));
            }
        } else if (!bl.booleanValue()) {
            this.zzadp.zzgt().zzjg().zzg("App version does not match; dropping event. appId", zzaq.zzby((String)string));
            return;
        }
        zzi zzi2 = new zzi(string, zzg2.getGmpAppId(), zzg2.zzak(), zzg2.zzhf(), zzg2.zzhg(), zzg2.zzhh(), zzg2.zzhi(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzhv(), 0L, 0, zzg2.zzhw(), zzg2.zzhx(), false, zzg2.zzhb());
        this.zzc(zzae2, zzi2);
    }

    @WorkerThread
    final void zzc(zzae zzae2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzi2);
        Preconditions.checkNotEmpty((String)zzi2.packageName);
        this.zzaf();
        this.zzlx();
        String string = zzi2.packageName;
        long l = zzae2.zzais;
        if (!this.zzjr().zze(zzae2, zzi2)) {
            return;
        }
        if (!zzi2.zzagg) {
            this.zzg(zzi2);
            return;
        }
        this.zzjt().beginTransaction();
        try {
            zzm zzm2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzr zzr2 = this.zzjt();
            Preconditions.checkNotEmpty((String)string3);
            zzr2.zzaf();
            zzr2.zzcl();
            if (l2 < 0L) {
                zzr2.zzgt().zzjj().zze("Invalid time querying timed out conditional properties", zzaq.zzby((String)string3), (Object)l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzr2.zzb(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzadp.zzgt().zzjn().zzd("User property timed out", (Object)((zzm)object22).packageName, (Object)this.zzadp.zzgq().zzbx(((zzm)object22).zzahe.name), ((zzm)object22).zzahe.getValue());
                if (((zzm)object22).zzahf != null) {
                    this.zzd(new zzae(((zzm)object22).zzahf, l), zzi2);
                }
                this.zzjt().zzk(string, ((zzm)object22).zzahe.name);
            }
            l2 = l;
            string3 = string;
            zzr2 = this.zzjt();
            Preconditions.checkNotEmpty((String)string3);
            zzr2.zzaf();
            zzr2.zzcl();
            if (l2 < 0L) {
                zzr2.zzgt().zzjj().zze("Invalid time querying expired conditional properties", zzaq.zzby((String)string3), (Object)l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzr2.zzb(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzm)object4.next();
                if (object == null) continue;
                this.zzadp.zzgt().zzjn().zzd("User property expired", (Object)((zzm)object).packageName, (Object)this.zzadp.zzgq().zzbx(((zzm)object).zzahe.name), ((zzm)object).zzahe.getValue());
                this.zzjt().zzh(string, ((zzm)object).zzahe.name);
                if (((zzm)object).zzahh != null) {
                    object22.add(((zzm)object).zzahh);
                }
                this.zzjt().zzk(string, ((zzm)object).zzahe.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzae)e;
                this.zzd(new zzae((zzae)object, l), zzi2);
            }
            long l3 = l;
            String string4 = zzae2.name;
            string3 = string;
            zzr2 = this.zzjt();
            Preconditions.checkNotEmpty((String)string3);
            Preconditions.checkNotEmpty((String)string4);
            zzr2.zzaf();
            zzr2.zzcl();
            if (l3 < 0L) {
                zzr2.zzgt().zzjj().zzd("Invalid time querying triggered conditional properties", zzaq.zzby((String)string3), (Object)zzr2.zzgq().zzbv(string4), (Object)l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzr2.zzb((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzm2 = (zzm)iterator.next();
                if (zzm2 == null) continue;
                zzfr zzfr2 = zzm2.zzahe;
                zzft zzft2 = new zzft(zzm2.packageName, zzm2.origin, zzfr2.name, l, zzfr2.getValue());
                if (this.zzjt().zza(zzft2)) {
                    this.zzadp.zzgt().zzjn().zzd("User property triggered", (Object)zzm2.packageName, (Object)this.zzadp.zzgq().zzbx(zzft2.name), zzft2.value);
                } else {
                    this.zzadp.zzgt().zzjg().zzd("Too many active user properties, ignoring", zzaq.zzby((String)zzm2.packageName), (Object)this.zzadp.zzgq().zzbx(zzft2.name), zzft2.value);
                }
                if (zzm2.zzahg != null) {
                    object.add(zzm2.zzahg);
                }
                zzm2.zzahe = new zzfr(zzft2);
                zzm2.active = true;
                this.zzjt().zza(zzm2);
            }
            this.zzd(zzae2, zzi2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzm2 = (zzae)e;
                this.zzd(new zzae((zzae)zzm2, l), zzi2);
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    private final void zzd(zzae var1_1, zzi var2_2) {
        Preconditions.checkNotNull((Object)var2_2);
        Preconditions.checkNotEmpty((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzaf();
        this.zzlx();
        var5_4 = var2_2.packageName;
        if (!this.zzjr().zze(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzagg) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzls().zzo(var5_4, var1_1.name)) {
            this.zzadp.zzgt().zzjj().zze("Dropping blacklisted event. appId", zzaq.zzby((String)var5_4), (Object)this.zzadp.zzgq().zzbv(var1_1.name));
            var6_5 = this.zzls().zzcn(var5_4) != false || this.zzls().zzco(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzadp.zzgr().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzjt().zzbo(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzhl(), var7_7.zzhk());
                if (Math.abs(this.zzadp.zzbx().currentTimeMillis() - var8_9) > (Long)zzag.zzakf.get()) {
                    this.zzadp.zzgt().zzjn().zzca("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzadp.zzgt().isLoggable(2)) {
            this.zzadp.zzgt().zzjo().zzg("Logging event", (Object)this.zzadp.zzgq().zzb(var1_1));
        }
        this.zzjt().beginTransaction();
        try {
            block54: {
                block55: {
                    block57: {
                        block61: {
                            block60: {
                                block58: {
                                    block59: {
                                        this.zzg(var2_2);
                                        if (!"_iap".equals(var1_1.name) && !"ecommerce_purchase".equals(var1_1.name)) break block57;
                                        var20_11 = var1_1;
                                        var19_14 = var5_4;
                                        var18_15 = this;
                                        var21_16 /* !! */  = var20_11.zzaig.getString("currency");
                                        if (!"ecommerce_purchase".equals(var20_11.name)) break block58;
                                        var24_17 = var20_11.zzaig.zzbt("value") * 1000000.0;
                                        if (var24_17 == 0.0) {
                                            var24_17 = (double)var20_11.zzaig.getLong("value").longValue() * 1000000.0;
                                        }
                                        if (!(var24_17 <= 9.223372036854776E18) || !(var24_17 >= -9.223372036854776E18)) break block59;
                                        var22_20 = Math.round(var24_17);
                                        break block60;
                                    }
                                    var18_15.zzadp.zzgt().zzjj().zze("Data lost. Currency value is too big. appId", zzaq.zzby((String)var19_14), (Object)var24_17);
                                    v0 = false;
                                    break block61;
                                }
                                var22_20 = var20_11.zzaig.getLong("value");
                            }
                            if (!TextUtils.isEmpty((CharSequence)var21_16 /* !! */ ) && (var21_16 /* !! */  = var21_16 /* !! */ .toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                                v1 = String.valueOf("_ltv_");
                                v2 = String.valueOf(var21_16 /* !! */ );
                                var24_18 = v2.length() != 0 ? v1.concat(v2) : new String(v1);
                                var25_22 = var18_15.zzjt().zzi(var19_14, var24_18);
                                if (var25_22 == null || !(var25_22.value instanceof Long)) {
                                    var29_25 = var19_14;
                                    var34_26 = var18_15.zzadp.zzgv().zzb(var29_25, zzag.zzakk) - 1;
                                    var33_27 = var19_14;
                                    var32_28 = var18_15.zzjt();
                                    Preconditions.checkNotEmpty((String)var33_27);
                                    var32_28.zzaf();
                                    var32_28.zzcl();
                                    try {
                                        var32_28.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{var33_27, var33_27, String.valueOf(var34_26)});
                                    }
                                    catch (SQLiteException var35_29) {
                                        var32_28.zzgt().zzjg().zze("Error pruning currencies. appId", zzaq.zzby((String)var33_27), (Object)var35_29);
                                    }
                                    var25_22 = new zzft(var19_14, var20_11.origin, var24_18, var18_15.zzadp.zzbx().currentTimeMillis(), (Object)var22_20);
                                } else {
                                    var26_30 = (Long)var25_22.value;
                                    var25_22 = new zzft(var19_14, var20_11.origin, var24_18, var18_15.zzadp.zzbx().currentTimeMillis(), (Object)(var26_30 + var22_20));
                                }
                                if (!var18_15.zzjt().zza(var25_22)) {
                                    var18_15.zzadp.zzgt().zzjg().zzd("Too many unique user properties are set. Ignoring user property. appId", zzaq.zzby((String)var19_14), (Object)var18_15.zzadp.zzgq().zzbx(var25_22.name), var25_22.value);
                                    var18_15.zzadp.zzgr().zza(var19_14, 9, null, null, 0);
                                }
                            }
                            v0 = true;
                        }
                        if (!v0) {
                            this.zzjt().setTransactionSuccessful();
                            return;
                        }
                    }
                    var6_6 = zzfu.zzcv((String)var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzjt().zza(this.zzly(), var5_4, true, var6_6, false, var7_8, false);
                    var9_32 = var8_10.zzahu - (long)((Integer)zzag.zzajq.get()).intValue();
                    if (var9_32 > 0L) {
                        if (var9_32 % 1000L == 1L) {
                            this.zzadp.zzgt().zzjg().zze("Data loss. Too many events logged. appId, count", zzaq.zzby((String)var5_4), (Object)var8_10.zzahu);
                        }
                        this.zzjt().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_32 = var8_10.zzaht - (long)((Integer)zzag.zzajs.get()).intValue()) > 0L) {
                        if (var9_32 % 1000L == 1L) {
                            this.zzadp.zzgt().zzjg().zze("Data loss. Too many public events logged. appId, count", zzaq.zzby((String)var5_4), (Object)var8_10.zzaht);
                        }
                        this.zzadp.zzgr().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzjt().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_14 = var2_2.packageName;
                        var20_12 = this.zzadp.zzgv().zzb(var19_14, zzag.zzajr);
                        var9_32 = var8_10.zzahw - (long)Math.max(0, var20_12 = Math.min(1000000, var20_12));
                        if (var9_32 > 0L) {
                            if (var9_32 == 1L) {
                                this.zzadp.zzgt().zzjg().zze("Too many error events logged. appId, count", zzaq.zzby((String)var5_4), (Object)var8_10.zzahw);
                            }
                            this.zzjt().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_33 = var1_1.zzaig.zziy();
                    this.zzadp.zzgr().zza(var11_33, "_o", (Object)var1_1.origin);
                    if (this.zzadp.zzgr().zzdb(var5_4)) {
                        this.zzadp.zzgr().zza(var11_33, "_dbg", (Object)1L);
                        this.zzadp.zzgr().zza(var11_33, "_r", (Object)1L);
                    }
                    if (this.zzadp.zzgv().zzbj(var2_2.packageName) && "_s".equals(var1_1.name) && (var12_34 = this.zzjt().zzi(var2_2.packageName, "_sno")) != null && var12_34.value instanceof Long) {
                        this.zzadp.zzgr().zza(var11_33, "_sno", var12_34.value);
                    }
                    if ((var12_35 = this.zzjt().zzbp(var5_4)) > 0L) {
                        this.zzadp.zzgt().zzjj().zze("Data lost. Too many events stored on disk, deleted. appId", zzaq.zzby((String)var5_4), (Object)var12_35);
                    }
                    var14_36 = new zzz(this.zzadp, var1_1.origin, var5_4, var1_1.name, var1_1.zzais, 0L, var11_33);
                    var15_37 = this.zzjt().zzg(var5_4, var14_36.name);
                    if (var15_37 == null) {
                        if (this.zzjt().zzbs(var5_4) >= 500L && var6_6) {
                            this.zzadp.zzgt().zzjg().zzd("Too many event names used, ignoring event. appId, name, supported count", zzaq.zzby((String)var5_4), (Object)this.zzadp.zzgq().zzbv(var14_36.name), (Object)500);
                            this.zzadp.zzgr().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_38 = new zzaa(var5_4, var14_36.name, 0L, 0L, var14_36.timestamp, 0L, null, null, null, null);
                    } else {
                        var14_36 = var14_36.zza(this.zzadp, var15_37.zzaij);
                        var16_38 = var15_37.zzai(var14_36.timestamp);
                    }
                    this.zzjt().zza(var16_38);
                    var20_13 = var2_2;
                    var19_14 = var14_36;
                    var18_15 = this;
                    var18_15.zzaf();
                    var18_15.zzlx();
                    Preconditions.checkNotNull((Object)var19_14);
                    Preconditions.checkNotNull((Object)var20_13);
                    Preconditions.checkNotEmpty((String)var19_14.zztt);
                    Preconditions.checkArgument((boolean)var19_14.zztt.equals(var20_13.packageName));
                    var21_16 /* !! */  = new zzgl();
                    new zzgl().zzaxt = 1;
                    var21_16 /* !! */ .zzayb = "android";
                    var21_16 /* !! */ .zztt = var20_13.packageName;
                    var21_16 /* !! */ .zzage = var20_13.zzage;
                    var21_16 /* !! */ .zzts = var20_13.zzts;
                    var21_16 /* !! */ .zzayn = var20_13.zzagd == -2147483648L ? null : Integer.valueOf((int)var20_13.zzagd);
                    var21_16 /* !! */ .zzayf = var20_13.zzadt;
                    var21_16 /* !! */ .zzafx = var20_13.zzafx;
                    var21_16 /* !! */ .zzaxc = var20_13.zzagk;
                    v3 = var21_16 /* !! */ .zzayj = var20_13.zzagf == 0L ? null : Long.valueOf(var20_13.zzagf);
                    if (var18_15.zzadp.zzgv().zze(var20_13.packageName, zzag.zzalq)) {
                        var21_16 /* !! */ .zzayx = var18_15.zzjr().zzmi();
                    }
                    if ((var22_21 = var18_15.zzadp.zzgu().zzcb(var20_13.packageName)) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_21.first))) {
                        if (var20_13.zzagi) {
                            var21_16 /* !! */ .zzayh = (String)var22_21.first;
                            var21_16 /* !! */ .zzayi = (Boolean)var22_21.second;
                        }
                    } else if (!var18_15.zzadp.zzgp().zzl(var18_15.zzadp.getContext()) && var20_13.zzagj) {
                        var23_39 = Settings.Secure.getString((ContentResolver)var18_15.zzadp.getContext().getContentResolver(), (String)"android_id");
                        if (var23_39 == null) {
                            var18_15.zzadp.zzgt().zzjj().zzg("null secure ID. appId", zzaq.zzby((String)var21_16 /* !! */ .zztt));
                            var23_39 = "null";
                        } else if (var23_39.isEmpty()) {
                            var18_15.zzadp.zzgt().zzjj().zzg("empty secure ID. appId", zzaq.zzby((String)var21_16 /* !! */ .zztt));
                        }
                        var21_16 /* !! */ .zzayq = var23_39;
                    }
                    var18_15.zzadp.zzgp().zzcl();
                    var21_16 /* !! */ .zzayd = Build.MODEL;
                    var18_15.zzadp.zzgp().zzcl();
                    var21_16 /* !! */ .zzayc = Build.VERSION.RELEASE;
                    var21_16 /* !! */ .zzaye = (int)var18_15.zzadp.zzgp().zziw();
                    var21_16 /* !! */ .zzaid = var18_15.zzadp.zzgp().zzix();
                    var21_16 /* !! */ .zzayg = null;
                    var21_16 /* !! */ .zzaxw = null;
                    var21_16 /* !! */ .zzaxx = null;
                    var21_16 /* !! */ .zzaxy = null;
                    var21_16 /* !! */ .zzays = var20_13.zzagh;
                    if (var18_15.zzadp.isEnabled() && zzo.zzie()) {
                        var21_16 /* !! */ .zzayt = null;
                    }
                    if ((var23_39 = var18_15.zzjt().zzbo(var20_13.packageName)) == null) {
                        var23_39 = new zzg(var18_15.zzadp, var20_13.packageName);
                        var23_39.zzal(var18_15.zzadp.zzgr().zzmm());
                        var23_39.zzap(var20_13.zzafz);
                        var23_39.zzam(var20_13.zzafx);
                        var23_39.zzao(var18_15.zzadp.zzgu().zzcc(var20_13.packageName));
                        var23_39.zzx(0L);
                        var23_39.zzs(0L);
                        var23_39.zzt(0L);
                        var23_39.setAppVersion(var20_13.zzts);
                        var23_39.zzu(var20_13.zzagd);
                        var23_39.zzaq(var20_13.zzage);
                        var23_39.zzv(var20_13.zzadt);
                        var23_39.zzw(var20_13.zzagf);
                        var23_39.setMeasurementEnabled(var20_13.zzagg);
                        var23_39.zzag(var20_13.zzagh);
                        var18_15.zzjt().zza((zzg)var23_39);
                    }
                    var21_16 /* !! */ .zzafw = var23_39.getAppInstanceId();
                    var21_16 /* !! */ .zzafz = var23_39.getFirebaseInstanceId();
                    var24_19 = var18_15.zzjt().zzbn(var20_13.packageName);
                    var21_16 /* !! */ .zzaxv = new zzgo[var24_19.size()];
                    for (var25_23 = 0; var25_23 < var24_19.size(); ++var25_23) {
                        var21_16 /* !! */ .zzaxv[var25_23] = var26_31 = new zzgo();
                        var26_31.name = var24_19.get((int)var25_23).name;
                        var26_31.zzazg = var24_19.get((int)var25_23).zzaux;
                        var18_15.zzjr().zza(var26_31, var24_19.get((int)var25_23).value);
                    }
                    try {
                        var25_24 = var18_15.zzjt().zza((zzgl)var21_16 /* !! */ );
                    }
                    catch (IOException var27_40) {
                        var18_15.zzadp.zzgt().zzjg().zze("Data loss. Failed to insert raw event metadata. appId", zzaq.zzby((String)var21_16 /* !! */ .zztt), (Object)var27_40);
                        break block54;
                    }
                    v4 = var18_15.zzjt();
                    var29_25 = var19_14;
                    var28_41 = var18_15;
                    if (var29_25.zzaig == null) ** GOTO lbl-1000
                    for (Object var31_44 : var29_25.zzaig) {
                        if (!"_r".equals(var31_44)) continue;
                        v5 = true;
                        break block55;
                    }
                    var30_43 = var28_41.zzls().zzp(var29_25.zztt, var29_25.name);
                    var31_44 = var28_41.zzjt().zza(var28_41.zzly(), var29_25.zztt, false, false, false, false, false);
                    if (var30_43 && var31_44.zzahx < (long)var28_41.zzadp.zzgv().zzas(var29_25.zztt)) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                }
                if (v4.zza((zzz)var19_14, var25_24, v5)) {
                    var18_15.zzaue = 0L;
                }
            }
            this.zzjt().setTransactionSuccessful();
            if (this.zzadp.zzgt().isLoggable(2)) {
                this.zzadp.zzgt().zzjo().zzg("Event recorded", (Object)this.zzadp.zzgq().zza(var14_36));
            }
        }
        finally {
            this.zzjt().endTransaction();
        }
        this.zzmb();
        this.zzadp.zzgt().zzjo().zzg("Background event processing time, ms", (Object)((System.nanoTime() - var3_3 + 500000L) / 1000000L));
    }

    @WorkerThread
    final void zzlz() {
        this.zzaf();
        this.zzlx();
        this.zzauk = true;
        try {
            String string;
            zzl zzl2 = this.zzadp.zzgw();
            Boolean bl = this.zzadp.zzgl().zzli();
            if (bl == null) {
                this.zzadp.zzgt().zzjj().zzca("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzadp.zzgt().zzjg().zzca("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzaue > 0L) {
                this.zzmb();
                return;
            }
            zzcr zzcr2 = this;
            zzcr2.zzaf();
            if (zzcr2.zzaun != null) {
                this.zzadp.zzgt().zzjo().zzca("Uploading requested multiple times");
                return;
            }
            if (!this.zzlt().zzfb()) {
                this.zzadp.zzgt().zzjo().zzca("Network not connected, ignoring upload request");
                this.zzmb();
                return;
            }
            long l = this.zzadp.zzbx().currentTimeMillis();
            long l2 = l - zzo.zzic();
            this.zzd(null, l2);
            long l3 = this.zzadp.zzgu().zzanl.get();
            if (l3 != 0L) {
                this.zzadp.zzgt().zzjn().zzg("Uploading events. Elapsed time since last upload attempt (ms)", (Object)Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzjt().zzih()))) {
                if (this.zzaup == -1L) {
                    this.zzaup = this.zzjt().zzio();
                }
                Object object = string;
                int n = this.zzadp.zzgv().zzb((String)object, zzag.zzajm);
                object = string;
                zzcr2 = this.zzadp.zzgv();
                int n2 = Math.max(0, zzcr2.zzb((String)object, zzag.zzajn));
                List<Pair<zzgl, Long>> list = this.zzjt().zzb(string, n, n2);
                if (!list.isEmpty()) {
                    Object object2;
                    String string2 = null;
                    Object object3 = list.iterator();
                    while (object3.hasNext()) {
                        zzgl zzgl2 = (zzgl)((Object)object3.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzgl2.zzayh)) continue;
                        string2 = zzgl2.zzayh;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object2 = (zzgl)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzgl)((Object)object2)).zzayh) || ((zzgl)((Object)object2)).zzayh.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object3 = new zzgk();
                    new zzgk().zzaxr = new zzgl[list.size()];
                    object2 = new ArrayList(list.size());
                    boolean bl2 = zzo.zzie() && this.zzadp.zzgv().zzau(string);
                    for (int i = 0; i < ((zzgk)((Object)object3)).zzaxr.length; ++i) {
                        ((zzgk)((Object)object3)).zzaxr[i] = (zzgl)((Object)list.get((int)i).first);
                        object2.add((Long)list.get((int)i).second);
                        ((zzgk)((Object)object3)).zzaxr[i].zzayg = this.zzadp.zzgv().zzhh();
                        ((zzgk)((Object)object3)).zzaxr[i].zzaxw = l;
                        zzl2 = this.zzadp.zzgw();
                        ((zzgk)((Object)object3)).zzaxr[i].zzayl = false;
                        if (bl2) continue;
                        ((zzgk)((Object)object3)).zzaxr[i].zzayt = null;
                    }
                    String string3 = null;
                    if (this.zzadp.zzgt().isLoggable(2)) {
                        string3 = this.zzjr().zzb((zzgk)((Object)object3));
                    }
                    byte[] byArray = this.zzjr().zza((zzgk)((Object)object3));
                    String string4 = (String)zzag.zzajw.get();
                    try {
                        URL uRL = new URL(string4);
                        object = object2;
                        zzcr2 = this;
                        Preconditions.checkArgument((!object.isEmpty() ? 1 : 0) != 0);
                        if (zzcr2.zzaun != null) {
                            zzcr2.zzadp.zzgt().zzjg().zzca("Set uploading progress before finishing the previous upload");
                        } else {
                            zzcr2.zzaun = new ArrayList<Long>((Collection<Long>)object);
                        }
                        this.zzadp.zzgu().zzanm.set(l);
                        String string5 = "?";
                        if (((zzgk)((Object)object3)).zzaxr.length > 0) {
                            string5 = ((zzgk)((Object)object3)).zzaxr[0].zztt;
                        }
                        this.zzadp.zzgt().zzjo().zzd("Uploading data. app, uncompressed size, data", (Object)string5, (Object)byArray.length, (Object)string3);
                        this.zzauj = true;
                        zzfm zzfm2 = new zzfm(this, string);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object = string;
                        zzcr2 = this.zzlt();
                        zzcr2.zzaf();
                        zzcr2.zzcl();
                        Preconditions.checkNotNull((Object)uRL2);
                        Preconditions.checkNotNull((Object)byArray2);
                        Preconditions.checkNotNull((Object)zzfm2);
                        zzcr2.zzgs().zzd((Runnable)new zzay((zzau)zzcr2, (String)object, uRL2, byArray2, null, zzfm2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzadp.zzgt().zzjg().zze("Failed to parse upload URL. Not uploading. appId", zzaq.zzby((String)string), (Object)string4);
                    }
                }
            } else {
                zzg zzg2;
                this.zzaup = -1L;
                String string6 = this.zzjt().zzah(l - zzo.zzic());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzg2 = this.zzjt().zzbo(string6)) != null) {
                    this.zzb(zzg2);
                }
            }
            return;
        }
        finally {
            this.zzauk = false;
            this.zzmc();
        }
    }

    @WorkerThread
    private final boolean zzd(String string, long l) {
        this.zzjt().beginTransaction();
        try {
            block143: {
                Object object;
                int n;
                zzgj zzgj2;
                zzzl zzzl2;
                int n3;
                Object object2;
                Object object3;
                zza zza2;
                block141: {
                    zza zza3 = zza2 = new zza(null);
                    long l2 = this.zzaup;
                    long l3 = l;
                    object3 = null;
                    object2 = this.zzjt();
                    Preconditions.checkNotNull((Object)zza3);
                    object2.zzaf();
                    object2.zzcl();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string2;
                        String string3;
                        String string4;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = object2.getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string4 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string4).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string4).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block141;
                            object3 = cursor.getString(0);
                            string3 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string4 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string4).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string4).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block141;
                            string3 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{object3, string3}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            object2.zzgt().zzjg().zzg("Raw event metadata record is missing. appId", zzaq.zzby((String)object3));
                            break block141;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string4 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray.length);
                        zzgl zzgl2 = new zzgl();
                        try {
                            zzgl2.zza((zzzi)string4);
                        }
                        catch (IOException iOException) {
                            object2.zzgt().zzjg().zze("Data loss. Failed to merge raw event metadata. appId", zzaq.zzby((String)object3), (Object)iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block141;
                        }
                        if (cursor.moveToNext()) {
                            object2.zzgt().zzjj().zzg("Get multiple raw event metadata records, expected one. appId", zzaq.zzby((String)object3));
                        }
                        cursor.close();
                        zza3.zzb(zzgl2);
                        if (l2 != -1L) {
                            string2 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{object3, string3, String.valueOf(l2)};
                        } else {
                            string2 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{object3, string3};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string2, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            object2.zzgt().zzjj().zzg("Raw event data disappeared while in transaction. appId", zzaq.zzby((String)object3));
                            break block141;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string4 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray.length);
                            zzgi zzgi2 = new zzgi();
                            try {
                                zzgi2.zza((zzzi)string4);
                            }
                            catch (IOException iOException) {
                                object2.zzgt().zzjg().zze("Data loss. Failed to merge raw event. appId", zzaq.zzby((String)object3), (Object)iOException);
                                continue;
                            }
                            zzgi2.name = cursor.getString(1);
                            zzgi2.zzaxn = cursor.getLong(2);
                            if (!zza3.zza(l4, zzgi2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzauv == null || ((zza)object2).zzauv.isEmpty()) break block143;
                boolean bl = false;
                zzgl zzgl3 = zza2.zzaut;
                zza2.zzaut.zzaxu = new zzgi[zza2.zzauv.size()];
                int n4 = 0;
                long l5 = 0L;
                boolean bl2 = this.zzadp.zzgv().zzaw(zzgl3.zztt);
                boolean bl3 = this.zzadp.zzgv().zze(zza2.zzaut.zztt, zzag.zzalm);
                zzzl zzzl3 = null;
                zzzl zzzl4 = null;
                for (n3 = 0; n3 < zza2.zzauv.size(); ++n3) {
                    boolean bl4;
                    block145: {
                        int zzgjArray2;
                        boolean bl5;
                        block144: {
                            boolean bl6;
                            bl5 = bl;
                            zzzl2 = zza2.zzauv.get(n3);
                            if (this.zzls().zzo(zza2.zzaut.zztt, zzzl2.name)) {
                                this.zzadp.zzgt().zzjj().zze("Dropping blacklisted raw event. appId", zzaq.zzby((String)zza2.zzaut.zztt), (Object)this.zzadp.zzgq().zzbv(zzzl2.name));
                                if (this.zzls().zzcn(zza2.zzaut.zztt) || this.zzls().zzco(zza2.zzaut.zztt) || "_err".equals(zzzl2.name)) continue;
                                this.zzadp.zzgr().zza(zza2.zzaut.zztt, 11, "_ev", zzzl2.name, 0);
                                continue;
                            }
                            bl4 = this.zzls().zzp(zza2.zzaut.zztt, zzzl2.name);
                            if (bl4) break block144;
                            this.zzjr();
                            object2 = zzzl2.name;
                            Preconditions.checkNotEmpty((String)object2);
                            switch (object2) {
                                case "_in": 
                                case "_ui": 
                                case "_ug": {
                                    bl6 = true;
                                    break;
                                }
                                default: {
                                    bl6 = false;
                                }
                            }
                            if (!bl6) break block145;
                        }
                        boolean bl7 = false;
                        boolean n2 = false;
                        if (zzzl2.zzaxm == null) {
                            zzzl2.zzaxm = new zzgj[0];
                        }
                        zzgj[] i = zzzl2.zzaxm;
                        int zzgj3 = zzzl2.zzaxm.length;
                        for (zzgjArray2 = 0; zzgjArray2 < zzgj3; ++zzgjArray2) {
                            zzgj2 = i[zzgjArray2];
                            if ("_c".equals(zzgj2.name)) {
                                zzgj2.zzaxq = 1L;
                                bl7 = true;
                                continue;
                            }
                            if (!"_r".equals(zzgj2.name)) continue;
                            zzgj2.zzaxq = 1L;
                            n2 = true;
                        }
                        if (!bl7 && bl4) {
                            this.zzadp.zzgt().zzjo().zzg("Marking event as conversion", (Object)this.zzadp.zzgq().zzbv(zzzl2.name));
                            i = Arrays.copyOf(zzzl2.zzaxm, zzzl2.zzaxm.length + 1);
                            zzgj zzgj4 = new zzgj();
                            new zzgj().name = "_c";
                            zzgj4.zzaxq = 1L;
                            i[i.length - 1] = zzgj4;
                            zzzl2.zzaxm = i;
                        }
                        if (!n2) {
                            this.zzadp.zzgt().zzjo().zzg("Marking event as real-time", (Object)this.zzadp.zzgq().zzbv(zzzl2.name));
                            i = Arrays.copyOf(zzzl2.zzaxm, zzzl2.zzaxm.length + 1);
                            zzgj zzgi4 = new zzgj();
                            new zzgj().name = "_r";
                            zzgi4.zzaxq = 1L;
                            i[i.length - 1] = zzgi4;
                            zzzl2.zzaxm = i;
                        }
                        bl = true;
                        if (this.zzjt().zza((long)this.zzly(), (String)zza2.zzaut.zztt, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzahx > (long)this.zzadp.zzgv().zzas(zza2.zzaut.zztt)) {
                            for (zzgj3 = 0; zzgj3 < zzzl2.zzaxm.length; ++zzgj3) {
                                if (!"_r".equals(zzzl2.zzaxm[zzgj3].name)) continue;
                                zzgj[] string6 = new zzgj[zzzl2.zzaxm.length - 1];
                                if (zzgj3 > 0) {
                                    System.arraycopy(zzzl2.zzaxm, 0, string6, 0, zzgj3);
                                }
                                if (zzgj3 < string6.length) {
                                    System.arraycopy(zzzl2.zzaxm, zzgj3 + 1, string6, zzgj3, string6.length - zzgj3);
                                }
                                zzzl2.zzaxm = string6;
                                break;
                            }
                            bl = bl5;
                        }
                        if (zzfu.zzcv((String)zzzl2.name) && bl4) {
                            object3 = zza2.zzaut.zztt;
                            if (this.zzjt().zza((long)this.zzly(), (String)zza2.zzaut.zztt, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzahv > (long)this.zzadp.zzgv().zzb((String)object3, zzag.zzajt)) {
                                this.zzadp.zzgt().zzjj().zzg("Too many conversions. Not logging as conversion. appId", zzaq.zzby((String)zza2.zzaut.zztt));
                                zzgjArray2 = 0;
                                zzgj2 = null;
                                zzgj[] l9 = zzzl2.zzaxm;
                                int n5 = zzzl2.zzaxm.length;
                                for (n = 0; n < n5; ++n) {
                                    object = l9[n];
                                    if ("_c".equals(object.name)) {
                                        zzgj2 = object;
                                        continue;
                                    }
                                    if (!"_err".equals(object.name)) continue;
                                    zzgjArray2 = 1;
                                }
                                if (zzgjArray2 != 0 && zzgj2 != null) {
                                    zzzl2.zzaxm = (zzgj[])ArrayUtils.removeAll((Object[])zzzl2.zzaxm, (Object[])new zzgj[]{zzgj2});
                                } else if (zzgj2 != null) {
                                    zzgj2.name = "_err";
                                    zzgj2.zzaxq = 10L;
                                } else {
                                    this.zzadp.zzgt().zzjg().zzg("Did not find conversion parameter. appId", zzaq.zzby((String)zza2.zzaut.zztt));
                                }
                            }
                        }
                    }
                    if (this.zzadp.zzgv().zzbf(zza2.zzaut.zztt) && bl4) {
                        int n8;
                        object3 = zzzl2.zzaxm;
                        object2 = this;
                        int n9 = -1;
                        int zzgiArray = -1;
                        for (n8 = 0; n8 < ((zzgj[])object3).length; ++n8) {
                            if ("value".equals(object3[n8].name)) {
                                n9 = n8;
                                continue;
                            }
                            if (!"currency".equals(object3[n8].name)) continue;
                            zzgiArray = n8;
                        }
                        if (n9 != -1) {
                            if (object3[n9].zzaxq == null && object3[n9].zzava == null) {
                                ((zzfk)object2).zzadp.zzgt().zzjl().zzca("Value must be specified with a numeric type.");
                                object3 = zzfk.zza((zzgj[])object3, n9);
                                object3 = zzfk.zza(zzfk.zza((zzgj[])object3, "_c"), 18, "value");
                            } else {
                                n8 = 0;
                                if (zzgiArray == -1) {
                                    n8 = 1;
                                } else {
                                    String n13 = object3[zzgiArray].zzamw;
                                    if (n13 == null || n13.length() != 3) {
                                        n8 = 1;
                                    } else {
                                        int n11;
                                        for (int i = 0; i < n13.length(); i += Character.charCount(n11)) {
                                            n11 = n13.codePointAt(i);
                                            if (Character.isLetter(n11)) continue;
                                            n8 = 1;
                                            break;
                                        }
                                    }
                                }
                                if (n8 != 0) {
                                    ((zzfk)object2).zzadp.zzgt().zzjl().zzca("Value parameter discarded. You must also supply a 3-letter ISO_4217 currency code in the currency parameter.");
                                    object3 = zzfk.zza((zzgj[])object3, n9);
                                    object3 = zzfk.zza(zzfk.zza((zzgj[])object3, "_c"), 19, "currency");
                                }
                            }
                        }
                        zzzl2.zzaxm = object3;
                    }
                    if (this.zzadp.zzgv().zze(zza2.zzaut.zztt, zzag.zzall)) {
                        if ("_e".equals(zzzl2.name)) {
                            this.zzjr();
                            if (zzfq.zza((zzgi)zzzl2, "_fr") == null) {
                                if (zzzl4 != null && Math.abs(zzzl4.zzaxn - zzzl2.zzaxn) <= 1000L) {
                                    if (this.zza((zzgi)zzzl2, (zzgi)zzzl4)) {
                                        zzzl3 = null;
                                        zzzl4 = null;
                                    } else {
                                        zzzl3 = zzzl2;
                                    }
                                } else {
                                    zzzl3 = zzzl2;
                                }
                            }
                        } else if ("_vs".equals(zzzl2.name)) {
                            this.zzjr();
                            if (zzfq.zza((zzgi)zzzl2, "_et") == null) {
                                if (zzzl3 != null && Math.abs(zzzl3.zzaxn - zzzl2.zzaxn) <= 1000L) {
                                    if (this.zza((zzgi)zzzl3, (zzgi)zzzl2)) {
                                        zzzl3 = null;
                                        zzzl4 = null;
                                    } else {
                                        zzzl4 = zzzl2;
                                    }
                                } else {
                                    zzzl4 = zzzl2;
                                }
                            }
                        }
                    }
                    if (bl2 && !bl3 && "_e".equals(zzzl2.name)) {
                        if (zzzl2.zzaxm == null || zzzl2.zzaxm.length == 0) {
                            this.zzadp.zzgt().zzjj().zzg("Engagement event does not contain any parameters. appId", zzaq.zzby((String)zza2.zzaut.zztt));
                        } else {
                            this.zzjr();
                            Long l6 = (Long)zzfq.zzb((zzgi)zzzl2, "_et");
                            if (l6 == null) {
                                this.zzadp.zzgt().zzjj().zzg("Engagement event does not include duration. appId", zzaq.zzby((String)zza2.zzaut.zztt));
                            } else {
                                l5 += l6.longValue();
                            }
                        }
                    }
                    zzgl3.zzaxu[n4++] = zzzl2;
                }
                if (bl3) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        Long l7;
                        zzgi zzgi3 = zzgl3.zzaxu[n3];
                        if ("_e".equals(zzgi3.name)) {
                            this.zzjr();
                            if (zzfq.zza(zzgi3, "_fr") != null) {
                                System.arraycopy(zzgl3.zzaxu, n3 + 1, zzgl3.zzaxu, n3, n4 - n3 - 1);
                                --n4;
                                --n3;
                                continue;
                            }
                        }
                        if (!bl2) continue;
                        this.zzjr();
                        zzzl2 = zzfq.zza(zzgi3, "_et");
                        if (zzzl2 == null || (l7 = zzzl2.zzaxq) == null || l7 <= 0L) continue;
                        l5 += l7.longValue();
                    }
                }
                if (n4 < zza2.zzauv.size()) {
                    zzgl3.zzaxu = Arrays.copyOf(zzgl3.zzaxu, n4);
                }
                if (bl2) {
                    zzft zzft2 = this.zzjt().zzi(zzgl3.zztt, "_lte");
                    zzft2 = zzft2 == null || zzft2.value == null ? new zzft(zzgl3.zztt, "auto", "_lte", this.zzadp.zzbx().currentTimeMillis(), (Object)l5) : new zzft(zzgl3.zztt, "auto", "_lte", this.zzadp.zzbx().currentTimeMillis(), (Object)((Long)zzft2.value + l5));
                    zzgo zzgo2 = new zzgo();
                    new zzgo().name = "_lte";
                    zzgo2.zzazg = this.zzadp.zzbx().currentTimeMillis();
                    zzgo2.zzaxq = (Long)zzft2.value;
                    boolean bl8 = false;
                    for (int i = 0; i < zzgl3.zzaxv.length; ++i) {
                        if (!"_lte".equals(zzgl3.zzaxv[i].name)) continue;
                        zzgl3.zzaxv[i] = zzgo2;
                        bl8 = true;
                        break;
                    }
                    if (!bl8) {
                        zzgl3.zzaxv = Arrays.copyOf(zzgl3.zzaxv, zzgl3.zzaxv.length + 1);
                        zzgl3.zzaxv[zza2.zzaut.zzaxv.length - 1] = zzgo2;
                    }
                    if (l5 > 0L) {
                        this.zzjt().zza(zzft2);
                        this.zzadp.zzgt().zzjn().zzg("Updated lifetime engagement user property with value. Value", zzft2.value);
                    }
                }
                zzgi[] i = zzgl3.zzaxu;
                Object object4 = zzgl3.zzaxv;
                object3 = zzgl3.zztt;
                object2 = this;
                Preconditions.checkNotEmpty((String)object3);
                zzgl3.zzaym = ((zzfk)object2).zzjs().zza((String)object3, i, (zzgo[])object4);
                if (this.zzadp.zzgv().zzav(zza2.zzaut.zztt)) {
                    HashMap<String, zzgj> hashMap = new HashMap<String, zzgj>();
                    zzgi[] zzgiArray2 = new zzgi[zzgl3.zzaxu.length];
                    int n12 = 0;
                    SecureRandom secureRandom = this.zzadp.zzgr().zzmk();
                    zzgi[] zzgiArray3 = zzgl3.zzaxu;
                    int n6 = zzgl3.zzaxu.length;
                    for (int j = 0; j < n6; ++j) {
                        boolean bl7;
                        long l2;
                        boolean bl8;
                        long l3;
                        long l4;
                        zzgi zzgi2;
                        block142: {
                            zzgi2 = zzgiArray3[j];
                            if (zzgi2.name.equals("_ep")) {
                                this.zzjr();
                                String l10 = (String)zzfq.zzb(zzgi2, "_en");
                                zzgj2 = (zzaa)hashMap.get(l10);
                                if (zzgj2 == null) {
                                    zzgj2 = this.zzjt().zzg(zza2.zzaut.zztt, l10);
                                    hashMap.put(l10, zzgj2);
                                }
                                if (((zzaa)zzgj2).zzaim != null) continue;
                                if (((zzaa)zzgj2).zzain > 1L) {
                                    this.zzjr();
                                    zzgi2.zzaxm = zzfq.zza(zzgi2.zzaxm, "_sr", ((zzaa)zzgj2).zzain);
                                }
                                if (((zzaa)zzgj2).zzaio != null && ((zzaa)zzgj2).zzaio.booleanValue()) {
                                    this.zzjr();
                                    zzgi2.zzaxm = zzfq.zza(zzgi2.zzaxm, "_efs", 1L);
                                }
                                zzgiArray2[n12++] = zzgi2;
                                continue;
                            }
                            l4 = this.zzls().zzcm(zza2.zzaut.zztt);
                            this.zzadp.zzgr();
                            l3 = zzfu.zzc((long)zzgi2.zzaxn, (long)l4);
                            n = 1;
                            object4 = 1L;
                            object3 = "_dbg";
                            object2 = zzgi2;
                            if (TextUtils.isEmpty((CharSequence)object3) || object4 == null) {
                                bl8 = false;
                            } else {
                                zzgj[] zzgjArray = ((zzgi)((Object)((Object)object2))).zzaxm;
                                int n7 = ((zzgi)((Object)((Object)object2))).zzaxm.length;
                                for (int j2 = 0; j2 < n7; ++j2) {
                                    zzgj zzgj5 = zzgjArray[j2];
                                    if (!((String)object3).equals(zzgj5.name)) continue;
                                    bl8 = object4 instanceof Long && object4.equals(zzgj5.zzaxq) || object4 instanceof String && object4.equals(zzgj5.zzamw) || object4 instanceof Double && object4.equals(zzgj5.zzava);
                                    break block142;
                                }
                                bl8 = false;
                            }
                        }
                        if (!bl8) {
                            n = this.zzls().zzq(zza2.zzaut.zztt, zzgi2.name);
                        }
                        if (n <= 0) {
                            this.zzadp.zzgt().zzjj().zze("Sample rate must be positive. event, rate", (Object)zzgi2.name, (Object)n);
                            zzgiArray2[n12++] = zzgi2;
                            continue;
                        }
                        object = (zzaa)hashMap.get(zzgi2.name);
                        if (object == null && (object = this.zzjt().zzg(zza2.zzaut.zztt, zzgi2.name)) == null) {
                            this.zzadp.zzgt().zzjj().zze("Event being bundled has no eventAggregate. appId, eventName", (Object)zza2.zzaut.zztt, (Object)zzgi2.name);
                            object = new zzaa(zza2.zzaut.zztt, zzgi2.name, 1L, 1L, zzgi2.zzaxn.longValue(), 0L, null, null, null, null);
                        }
                        this.zzjr();
                        Long l6 = (Long)zzfq.zzb(zzgi2, "_eid");
                        Boolean bl9 = l6 != null;
                        if (n == 1) {
                            zzgiArray2[n12++] = zzgi2;
                            if (!bl9.booleanValue() || object.zzaim == null && object.zzain == null && object.zzaio == null) continue;
                            object = object.zza(null, null, null);
                            hashMap.put(zzgi2.name, (zzgj)((Object)object));
                            continue;
                        }
                        if (secureRandom.nextInt(n) == 0) {
                            this.zzjr();
                            zzgi2.zzaxm = zzfq.zza(zzgi2.zzaxm, "_sr", n);
                            zzgiArray2[n12++] = zzgi2;
                            if (bl9.booleanValue()) {
                                object = object.zza(null, Long.valueOf(n), null);
                            }
                            hashMap.put(zzgi2.name, (zzgj)object.zza(zzgi2.zzaxn.longValue(), l3));
                            continue;
                        }
                        if (this.zzadp.zzgv().zzbh(zza2.zzaut.zztt)) {
                            if (object.zzail != null) {
                                l2 = object.zzail;
                            } else {
                                this.zzadp.zzgr();
                                l2 = zzfu.zzc((long)zzgi2.zzaxo, (long)l4);
                            }
                            bl7 = l2 != l3;
                        } else {
                            l2 = object.zzaik;
                            boolean bl10 = bl7 = Math.abs(zzgi2.zzaxn - l2) >= 86400000L;
                        }
                        if (bl7) {
                            this.zzjr();
                            zzgi2.zzaxm = zzfq.zza(zzgi2.zzaxm, "_efs", 1L);
                            this.zzjr();
                            zzgi2.zzaxm = zzfq.zza(zzgi2.zzaxm, "_sr", n);
                            zzgiArray2[n12++] = zzgi2;
                            if (bl9.booleanValue()) {
                                object = object.zza(null, Long.valueOf(n), Boolean.valueOf(true));
                            }
                            hashMap.put(zzgi2.name, (zzgj)object.zza(zzgi2.zzaxn.longValue(), l3));
                            continue;
                        }
                        if (!bl9.booleanValue()) continue;
                        hashMap.put(zzgi2.name, (zzgj)object.zza(l6, null, null));
                    }
                    if (n12 < zzgl3.zzaxu.length) {
                        zzgl3.zzaxu = Arrays.copyOf(zzgiArray2, n12);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.zzjt().zza((zzaa)entry.getValue());
                    }
                }
                zzgl3.zzaxx = Long.MAX_VALUE;
                zzgl3.zzaxy = Long.MIN_VALUE;
                for (int i2 = 0; i2 < zzgl3.zzaxu.length; ++i2) {
                    zzgi zzgi5 = zzgl3.zzaxu[i2];
                    if (zzgi5.zzaxn < zzgl3.zzaxx) {
                        zzgl3.zzaxx = zzgi5.zzaxn;
                    }
                    if (zzgi5.zzaxn <= zzgl3.zzaxy) continue;
                    zzgl3.zzaxy = zzgi5.zzaxn;
                }
                String string7 = zza2.zzaut.zztt;
                zzg zzg2 = this.zzjt().zzbo(string7);
                if (zzg2 == null) {
                    this.zzadp.zzgt().zzjg().zzg("Bundling raw events w/o app info. appId", zzaq.zzby((String)zza2.zzaut.zztt));
                } else if (zzgl3.zzaxu.length > 0) {
                    long l12 = zzg2.zzhe();
                    zzgl3.zzaya = l12 != 0L ? Long.valueOf(l12) : null;
                    long l13 = zzg2.zzhd();
                    if (l13 == 0L) {
                        l13 = l12;
                    }
                    zzgl3.zzaxz = l13 != 0L ? Long.valueOf(l13) : null;
                    zzg2.zzhm();
                    zzgl3.zzayk = (int)zzg2.zzhj();
                    zzg2.zzs(zzgl3.zzaxx.longValue());
                    zzg2.zzt(zzgl3.zzaxy.longValue());
                    zzgl3.zzagy = zzg2.zzhu();
                    this.zzjt().zza(zzg2);
                }
                if (zzgl3.zzaxu.length > 0) {
                    zzl zzl2 = this.zzadp.zzgw();
                    zzge zzge2 = this.zzls().zzci(zza2.zzaut.zztt);
                    if (zzge2 == null || zzge2.zzawx == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzaut.zzafx)) {
                            zzgl3.zzayr = -1L;
                        } else {
                            this.zzadp.zzgt().zzjj().zzg("Did not find measurement config or missing version info. appId", zzaq.zzby((String)zza2.zzaut.zztt));
                        }
                    } else {
                        zzgl3.zzayr = zzge2.zzawx;
                    }
                    this.zzjt().zza(zzgl3, bl);
                }
                object3 = zza2.zzauu;
                object2 = this.zzjt();
                Preconditions.checkNotNull((Object)object3);
                object2.zzaf();
                object2.zzcl();
                object4 = new StringBuilder("rowid in (");
                for (int sQLiteException = 0; sQLiteException < object3.size(); ++sQLiteException) {
                    if (sQLiteException != 0) {
                        ((StringBuilder)object4).append(",");
                    }
                    ((StringBuilder)object4).append((Long)object3.get(sQLiteException));
                }
                ((StringBuilder)object4).append(")");
                int n14 = object2.getWritableDatabase().delete("raw_events", ((StringBuilder)object4).toString(), null);
                if (n14 != object3.size()) {
                    object2.zzgt().zzjg().zze("Deleted fewer rows from raw events table than expected", (Object)n14, (Object)object3.size());
                }
                object3 = string7;
                object2 = this.zzjt();
                object4 = object2.getWritableDatabase();
                try {
                    object4.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{object3, object3});
                }
                catch (SQLiteException sQLiteException) {
                    object2.zzgt().zzjg().zze("Failed to remove unused event metadata. appId", zzaq.zzby((String)object3), (Object)sQLiteException);
                }
                this.zzjt().setTransactionSuccessful();
                return true;
            }
            this.zzjt().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    private final boolean zza(zzgi zzgi2, zzgi zzgi3) {
        Preconditions.checkArgument((boolean)"_e".equals(zzgi2.name));
        this.zzjr();
        zzgj zzgj2 = zzfq.zza(zzgi2, "_sc");
        String string = zzgj2 == null ? null : zzgj2.zzamw;
        this.zzjr();
        zzgj zzgj3 = zzfq.zza(zzgi3, "_pc");
        String string2 = zzgj3 == null ? null : zzgj3.zzamw;
        if (string2 != null && string2.equals(string)) {
            this.zzjr();
            zzgj zzgj4 = zzfq.zza(zzgi2, "_et");
            if (zzgj4.zzaxq == null || zzgj4.zzaxq <= 0L) {
                return true;
            }
            long l = zzgj4.zzaxq;
            this.zzjr();
            zzgj4 = zzfq.zza(zzgi3, "_et");
            if (zzgj4 != null && zzgj4.zzaxq != null && zzgj4.zzaxq > 0L) {
                l += zzgj4.zzaxq.longValue();
            }
            this.zzjr();
            zzgi3.zzaxm = zzfq.zza(zzgi3.zzaxm, "_et", l);
            this.zzjr();
            zzgi2.zzaxm = zzfq.zza(zzgi2.zzaxm, "_fr", 1L);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private static zzgj[] zza(zzgj[] zzgjArray, @NonNull String string) {
        int n = -1;
        for (int i = 0; i < zzgjArray.length; ++i) {
            if (!string.equals(zzgjArray[i].name)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return zzgjArray;
        }
        return zzfk.zza(zzgjArray, n);
    }

    @VisibleForTesting
    private static zzgj[] zza(zzgj[] zzgjArray, int n) {
        zzgj[] zzgjArray2 = new zzgj[zzgjArray.length - 1];
        if (n > 0) {
            System.arraycopy(zzgjArray, 0, zzgjArray2, 0, n);
        }
        if (n < zzgjArray2.length) {
            System.arraycopy(zzgjArray, n + 1, zzgjArray2, n, zzgjArray2.length - n);
        }
        return zzgjArray2;
    }

    @VisibleForTesting
    private static zzgj[] zza(zzgj[] zzgjArray, int n, String string) {
        for (int i = 0; i < zzgjArray.length; ++i) {
            if (!"_err".equals(zzgjArray[i].name)) continue;
            return zzgjArray;
        }
        zzgj[] zzgjArray2 = new zzgj[zzgjArray.length + 2];
        System.arraycopy(zzgjArray, 0, zzgjArray2, 0, zzgjArray.length);
        zzgj zzgj2 = new zzgj();
        new zzgj().name = "_err";
        zzgj2.zzaxq = n;
        zzgj zzgj3 = new zzgj();
        new zzgj().name = "_ev";
        zzgj3.zzamw = string;
        zzgjArray2[zzgjArray2.length - 2] = zzgj2;
        zzgjArray2[zzgjArray2.length - 1] = zzgj3;
        return zzgjArray2;
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(int n, Throwable throwable, byte[] byArray, String string) {
        this.zzaf();
        this.zzlx();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzaun;
            this.zzaun = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzadp.zzgu().zzanl.set(this.zzadp.zzbx().currentTimeMillis());
                    this.zzadp.zzgu().zzanm.set(0L);
                    this.zzmb();
                    this.zzadp.zzgt().zzjo().zze("Successful upload. Got network response. code, size", (Object)n, (Object)byArray.length);
                    this.zzjt().beginTransaction();
                    try {
                        for (Long l : list) {
                            try {
                                long l2 = l;
                                zzr zzr2 = this.zzjt();
                                zzr2.zzaf();
                                zzr2.zzcl();
                                SQLiteDatabase sQLiteDatabase = zzr2.getWritableDatabase();
                                String[] stringArray = new String[]{String.valueOf(l2)};
                                try {
                                    if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                    throw new SQLiteException("Deleted fewer rows from queue than expected");
                                }
                                catch (SQLiteException sQLiteException) {
                                    zzr2.zzgt().zzjg().zzg("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                    throw sQLiteException;
                                }
                            }
                            catch (SQLiteException sQLiteException) {
                                if (this.zzauo != null && this.zzauo.contains(l)) continue;
                                throw sQLiteException;
                            }
                        }
                        this.zzjt().setTransactionSuccessful();
                    }
                    finally {
                        this.zzjt().endTransaction();
                    }
                    this.zzauo = null;
                    if (this.zzlt().zzfb() && this.zzma()) {
                        this.zzlz();
                    } else {
                        this.zzaup = -1L;
                        this.zzmb();
                    }
                    this.zzaue = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzadp.zzgt().zzjg().zzg("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzaue = this.zzadp.zzbx().elapsedRealtime();
                    this.zzadp.zzgt().zzjo().zzg("Disable upload, time", (Object)this.zzaue);
                }
            } else {
                this.zzadp.zzgt().zzjo().zze("Network upload failed. Will retry later. code, error", (Object)n, (Object)throwable);
                this.zzadp.zzgu().zzanm.set(this.zzadp.zzbx().currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzadp.zzgu().zzann.set(this.zzadp.zzbx().currentTimeMillis());
                }
                if (this.zzadp.zzgv().zzay(string)) {
                    this.zzjt().zzc(list);
                }
                this.zzmb();
            }
            return;
        }
        finally {
            this.zzauj = false;
            this.zzmc();
        }
    }

    private final boolean zzma() {
        this.zzaf();
        this.zzlx();
        return this.zzjt().zzim() || !TextUtils.isEmpty((CharSequence)this.zzjt().zzih());
    }

    @WorkerThread
    private final void zzb(zzg zzg2) {
        this.zzaf();
        if (TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && (!zzo.zzig() || TextUtils.isEmpty((CharSequence)zzg2.zzhb()))) {
            this.zzb(zzg2.zzal(), 204, null, null, null);
            return;
        }
        Object object = zzg2;
        Object object2 = this.zzadp.zzgv();
        Object object3 = new Uri.Builder();
        String string = object.getGmpAppId();
        if (TextUtils.isEmpty((CharSequence)string) && zzo.zzig()) {
            string = object.zzhb();
        }
        String string2 = String.valueOf(string);
        object3.scheme((String)zzag.zzajk.get()).encodedAuthority((String)zzag.zzajl.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", object.getAppInstanceId()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(object2.zzhh()));
        String string3 = object3.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzadp.zzgt().zzjo().zzg("Fetching remote configuration", (Object)zzg2.zzal());
            zzge zzge2 = this.zzls().zzci(zzg2.zzal());
            ArrayMap arrayMap = null;
            String string4 = this.zzls().zzcj(zzg2.zzal());
            if (zzge2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzaui = true;
            zzfn zzfn2 = new zzfn(this);
            string = arrayMap;
            object3 = uRL;
            object = zzg2.zzal();
            object2 = this.zzlt();
            object2.zzaf();
            ((zzfj)((Object)object2)).zzcl();
            Preconditions.checkNotNull((Object)object3);
            Preconditions.checkNotNull((Object)zzfn2);
            object2.zzgs().zzd((Runnable)new zzay((zzau)((Object)object2), (String)object, (URL)object3, null, (Map)((Object)string), zzfn2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzadp.zzgt().zzjg().zze("Failed to parse config URL. Not fetching. appId", zzaq.zzby((String)zzg2.zzal()), (Object)string3);
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotEmpty((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzadp.zzgt().zzjo().zzg("onConfigFetched. Response size", (Object)byArray.length);
            this.zzjt().beginTransaction();
            try {
                boolean bl;
                zzg zzg2 = this.zzjt().zzbo(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzg2 == null) {
                    this.zzadp.zzgt().zzjj().zzg("App does not exist in onConfigFetched. appId", zzaq.zzby((String)string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzls().zzci(string) == null && !this.zzls().zza(string, null, null) : !this.zzls().zza(string, byArray, string2)) {
                        return;
                    }
                    zzg2.zzy(this.zzadp.zzbx().currentTimeMillis());
                    this.zzjt().zza(zzg2);
                    if (n == 404) {
                        this.zzadp.zzgt().zzjl().zzg("Config not found. Using empty config. appId", (Object)string);
                    } else {
                        this.zzadp.zzgt().zzjo().zze("Successfully fetched config. Got network response. code, size", (Object)n, (Object)byArray.length);
                    }
                    if (this.zzlt().zzfb() && this.zzma()) {
                        this.zzlz();
                    } else {
                        this.zzmb();
                    }
                } else {
                    zzg2.zzz(this.zzadp.zzbx().currentTimeMillis());
                    this.zzjt().zza(zzg2);
                    this.zzadp.zzgt().zzjo().zze("Fetching config failed. code, error", (Object)n, (Object)throwable);
                    this.zzls().zzck(string);
                    this.zzadp.zzgu().zzanm.set(this.zzadp.zzbx().currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzadp.zzgu().zzann.set(this.zzadp.zzbx().currentTimeMillis());
                    }
                    this.zzmb();
                }
                this.zzjt().setTransactionSuccessful();
            }
            finally {
                this.zzjt().endTransaction();
            }
            return;
        }
        finally {
            this.zzaui = false;
            this.zzmc();
        }
    }

    @WorkerThread
    private final void zzmb() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzaf();
            this.zzlx();
            if (!this.zzmf() && !this.zzadp.zzgv().zza(zzag.zzalp)) {
                return;
            }
            if (this.zzaue > 0L) {
                l3 = this.zzadp.zzbx().elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzaue);
                if (l2 > 0L) {
                    this.zzadp.zzgt().zzjo().zzg("Upload has been suspended. Will update scheduling later in approximately ms", (Object)l2);
                    this.zzlu().unregister();
                    this.zzlv().cancel();
                    return;
                }
                this.zzaue = 0L;
            }
            if (!this.zzadp.zzkv() || !this.zzma()) {
                this.zzadp.zzgt().zzjo().zzca("Nothing to upload or uploading impossible");
                this.zzlu().unregister();
                this.zzlv().cancel();
                return;
            }
            zzfk zzfk2 = this;
            long l4 = zzfk2.zzadp.zzbx().currentTimeMillis();
            long l5 = Math.max(0L, (Long)zzag.zzakg.get());
            boolean bl = zzfk2.zzjt().zzin() || zzfk2.zzjt().zzii();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzfk2.zzadp.zzgv().zzid())) && !".none.".equals(string) ? Math.max(0L, (Long)zzag.zzakb.get()) : Math.max(0L, (Long)zzag.zzaka.get())) : Math.max(0L, (Long)zzag.zzajz.get());
            long l7 = zzfk2.zzadp.zzgu().zzanl.get();
            long l8 = zzfk2.zzadp.zzgu().zzanm.get();
            long l9 = zzfk2.zzjt().zzik();
            long l10 = zzfk2.zzjt().zzil();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzfk2.zzjr().zzb(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, (Integer)zzag.zzaki.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, (Long)zzag.zzakh.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzadp.zzgt().zzjo().zzca("Next upload time is 0");
            this.zzlu().unregister();
            this.zzlv().cancel();
            return;
        }
        if (!this.zzlt().zzfb()) {
            this.zzadp.zzgt().zzjo().zzca("No network");
            this.zzlu().zzey();
            this.zzlv().cancel();
            return;
        }
        l2 = this.zzadp.zzgu().zzann.get();
        long l16 = Math.max(0L, (Long)zzag.zzajx.get());
        if (!this.zzjr().zzb(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzlu().unregister();
        long l17 = l3 - this.zzadp.zzbx().currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, (Long)zzag.zzakc.get());
            this.zzadp.zzgu().zzanl.set(this.zzadp.zzbx().currentTimeMillis());
        }
        this.zzadp.zzgt().zzjo().zzg("Upload scheduled in approximately ms", (Object)l17);
        this.zzlv().zzh(l17);
    }

    @WorkerThread
    final void zzg(Runnable runnable) {
        this.zzaf();
        if (this.zzauf == null) {
            this.zzauf = new ArrayList<Runnable>();
        }
        this.zzauf.add(runnable);
    }

    @WorkerThread
    private final void zzmc() {
        this.zzaf();
        if (this.zzaui || this.zzauj || this.zzauk) {
            this.zzadp.zzgt().zzjo().zzd("Not stopping services. fetch, network, upload", (Object)this.zzaui, (Object)this.zzauj, (Object)this.zzauk);
            return;
        }
        this.zzadp.zzgt().zzjo().zzca("Stopping uploading service(s)");
        if (this.zzauf == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzauf.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzauf.clear();
    }

    @WorkerThread
    private final Boolean zzc(zzg zzg2) {
        try {
            if (zzg2.zzhf() != Integer.MIN_VALUE) {
                int n = Wrappers.packageManager((Context)this.zzadp.getContext()).getPackageInfo((String)zzg2.zzal(), (int)0).versionCode;
                if (zzg2.zzhf() == (long)n) {
                    return true;
                }
            } else {
                String string = Wrappers.packageManager((Context)this.zzadp.getContext()).getPackageInfo((String)zzg2.zzal(), (int)0).versionName;
                if (zzg2.zzak() != null && zzg2.zzak().equals(string)) {
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zzmd() {
        this.zzaf();
        String string = "google_app_measurement.db";
        File file = this.zzadp.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzaum = new RandomAccessFile(file2, "rw").getChannel();
            this.zzaul = this.zzaum.tryLock();
            if (this.zzaul != null) {
                this.zzadp.zzgt().zzjo().zzca("Storage concurrent access okay");
                return true;
            }
            this.zzadp.zzgt().zzjg().zzca("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzadp.zzgt().zzjg().zzg("Failed to acquire storage lock", (Object)fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzadp.zzgt().zzjg().zzg("Failed to access storage lock file", (Object)iOException);
        }
        return false;
    }

    @VisibleForTesting
    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzaf();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzadp.zzgt().zzjg().zzca("Bad channel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzadp.zzgt().zzjj().zzg("Unexpected data length. Bytes read", (Object)n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzadp.zzgt().zzjg().zzg("Failed to read from channel", (Object)iOException);
        }
        return n;
    }

    @VisibleForTesting
    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzaf();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzadp.zzgt().zzjg().zzca("Bad channel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzadp.zzgt().zzjg().zzg("Error writing to channel. Bytes written", (Object)fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzadp.zzgt().zzjg().zzg("Failed to write to channel", (Object)iOException);
            return false;
        }
    }

    @WorkerThread
    final void zzme() {
        this.zzaf();
        this.zzlx();
        if (!this.zzaud) {
            this.zzaud = true;
            zzfk zzfk2 = this;
            zzfk2.zzaf();
            zzfk2.zzlx();
            if ((zzfk2.zzadp.zzgv().zza(zzag.zzalp) || zzfk2.zzmf()) && zzfk2.zzmd()) {
                int n;
                int n2 = zzfk2.zza(zzfk2.zzaum);
                int n3 = n = zzfk2.zzadp.zzgk().zzjd();
                int n4 = n2;
                zzfk zzfk3 = zzfk2;
                zzfk3.zzaf();
                if (n4 > n3) {
                    zzfk3.zzadp.zzgt().zzjg().zze("Panic: can't downgrade version. Previous, current version", (Object)n4, (Object)n3);
                } else if (n4 < n3) {
                    if (zzfk3.zza(n3, zzfk3.zzaum)) {
                        zzfk3.zzadp.zzgt().zzjo().zze("Storage version upgraded. Previous, current version", (Object)n4, (Object)n3);
                    } else {
                        zzfk3.zzadp.zzgt().zzjg().zze("Storage version upgrade failed. Previous, current version", (Object)n4, (Object)n3);
                    }
                }
            }
        }
        if (!this.zzauc && !this.zzadp.zzgv().zza(zzag.zzalp)) {
            this.zzadp.zzgt().zzjm().zzca("This instance being marked as an uploader");
            this.zzauc = true;
            this.zzmb();
        }
    }

    @WorkerThread
    private final boolean zzmf() {
        this.zzaf();
        this.zzlx();
        return this.zzauc;
    }

    @VisibleForTesting
    @WorkerThread
    final void zzd(zzi zzi2) {
        if (this.zzaun != null) {
            this.zzauo = new ArrayList<Long>();
            this.zzauo.addAll(this.zzaun);
        }
        String string = zzi2.packageName;
        zzr zzr2 = this.zzjt();
        Preconditions.checkNotEmpty((String)string);
        zzr2.zzaf();
        zzr2.zzcl();
        try {
            SQLiteDatabase sQLiteDatabase = zzr2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray) + sQLiteDatabase.delete("main_event_params", "app_id=?", stringArray);
            if (n > 0) {
                zzr2.zzgt().zzjo().zze("Reset analytics data. app, records", (Object)string, (Object)n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzr2.zzgt().zzjg().zze("Error resetting analytics data. appId, error", zzaq.zzby((String)string), (Object)sQLiteException);
        }
        zzi zzi3 = this.zza(this.zzadp.getContext(), zzi2.packageName, zzi2.zzafx, zzi2.zzagg, zzi2.zzagi, zzi2.zzagj, zzi2.zzaha, zzi2.zzagk);
        if (!this.zzadp.zzgv().zzbc(zzi2.packageName) || zzi2.zzagg) {
            this.zzf(zzi3);
        }
    }

    private final zzi zza(Context context, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, String string3) {
        String string4 = "Unknown";
        String string5 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string6 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzadp.zzgt().zzjg().zzca("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string4 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzadp.zzgt().zzjg().zzg("Error retrieving installer package name. appId", zzaq.zzby((String)string));
        }
        if (string4 == null) {
            string4 = "manual_install";
        } else if ("com.android.vending".equals(string4)) {
            string4 = "";
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = Wrappers.packageManager((Context)context).getApplicationLabel(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string6 = charSequence.toString();
                }
                string5 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzadp.zzgt().zzjg().zze("Error retrieving newly installed package info. appId, appName", zzaq.zzby((String)string), (Object)string6);
            return null;
        }
        long l2 = 0L;
        zzl zzl2 = this.zzadp.zzgw();
        long l3 = 0L;
        if (this.zzadp.zzgv().zzbe(string)) {
            l3 = l;
        }
        return new zzi(string, string2, string5, (long)n, string4, this.zzadp.zzgv().zzhh(), this.zzadp.zzgr().zzd(context, string), null, bl, false, "", l2, l3, 0, bl2, bl3, false, string3);
    }

    @WorkerThread
    final void zzb(zzfr zzfr2, zzi zzi2) {
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzi2.zzafx) && TextUtils.isEmpty((CharSequence)zzi2.zzagk)) {
            return;
        }
        if (!zzi2.zzagg) {
            this.zzg(zzi2);
            return;
        }
        int n = this.zzadp.zzgr().zzcx(zzfr2.name);
        if (n != 0) {
            this.zzadp.zzgr();
            String string = zzfu.zza((String)zzfr2.name, (int)24, (boolean)true);
            int n2 = zzfr2.name != null ? zzfr2.name.length() : 0;
            this.zzadp.zzgr().zza(zzi2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzadp.zzgr().zzi(zzfr2.name, zzfr2.getValue());
        if (n != 0) {
            this.zzadp.zzgr();
            String string = zzfu.zza((String)zzfr2.name, (int)24, (boolean)true);
            Object object = zzfr2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzadp.zzgr().zza(zzi2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzadp.zzgr().zzj(zzfr2.name, zzfr2.getValue());
        if (object == null) {
            return;
        }
        if (this.zzadp.zzgv().zzbj(zzi2.packageName) && "_sno".equals(zzfr2.name)) {
            long l = 0L;
            zzft zzft2 = this.zzjt().zzi(zzi2.packageName, "_sno");
            if (zzft2 != null && zzft2.value instanceof Long) {
                l = (Long)zzft2.value;
            } else {
                zzaa zzaa2 = this.zzjt().zzg(zzi2.packageName, "_s");
                if (zzaa2 != null) {
                    l = zzaa2.zzaih;
                    this.zzadp.zzgt().zzjo().zzg("Backfill the session number. Last used session number", (Object)l);
                }
            }
            object = l + 1L;
        }
        zzft zzft3 = new zzft(zzi2.packageName, zzfr2.origin, zzfr2.name, zzfr2.zzaux, object);
        this.zzadp.zzgt().zzjn().zze("Setting user property", (Object)this.zzadp.zzgq().zzbx(zzft3.name), object);
        this.zzjt().beginTransaction();
        try {
            this.zzg(zzi2);
            boolean bl = this.zzjt().zza(zzft3);
            this.zzjt().setTransactionSuccessful();
            if (bl) {
                this.zzadp.zzgt().zzjn().zze("User property set", (Object)this.zzadp.zzgq().zzbx(zzft3.name), zzft3.value);
            } else {
                this.zzadp.zzgt().zzjg().zze("Too many unique user properties are set. Ignoring user property", (Object)this.zzadp.zzgq().zzbx(zzft3.name), zzft3.value);
                this.zzadp.zzgr().zza(zzi2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzfr zzfr2, zzi zzi2) {
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzi2.zzafx) && TextUtils.isEmpty((CharSequence)zzi2.zzagk)) {
            return;
        }
        if (!zzi2.zzagg) {
            this.zzg(zzi2);
            return;
        }
        this.zzadp.zzgt().zzjn().zzg("Removing user property", (Object)this.zzadp.zzgq().zzbx(zzfr2.name));
        this.zzjt().beginTransaction();
        try {
            this.zzg(zzi2);
            this.zzjt().zzh(zzi2.packageName, zzfr2.name);
            this.zzjt().setTransactionSuccessful();
            this.zzadp.zzgt().zzjn().zzg("User property removed", (Object)this.zzadp.zzgq().zzbx(zzfr2.name));
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    final void zzb(zzfj zzfj2) {
        ++this.zzaug;
    }

    final void zzmg() {
        ++this.zzauh;
    }

    final zzbu zzmh() {
        return this.zzadp;
    }

    @WorkerThread
    final void zzf(zzi zzi2) {
        int n;
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotNull((Object)zzi2);
        Preconditions.checkNotEmpty((String)zzi2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzi2.zzafx) && TextUtils.isEmpty((CharSequence)zzi2.zzagk)) {
            return;
        }
        zzg zzg2 = this.zzjt().zzbo(zzi2.packageName);
        if (zzg2 != null && TextUtils.isEmpty((CharSequence)zzg2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzi2.zzafx)) {
            zzg2.zzy(0L);
            this.zzjt().zza(zzg2);
            this.zzls().zzcl(zzi2.packageName);
        }
        if (!zzi2.zzagg) {
            this.zzg(zzi2);
            return;
        }
        long l = zzi2.zzaha;
        if (l == 0L) {
            l = this.zzadp.zzbx().currentTimeMillis();
        }
        if ((n = zzi2.zzahb) != 0 && n != 1) {
            this.zzadp.zzgt().zzjj().zze("Incorrect app type, assuming installed app. appId, appType", zzaq.zzby((String)zzi2.packageName), (Object)n);
            n = 0;
        }
        this.zzjt().beginTransaction();
        try {
            zzae zzae2;
            Bundle bundle;
            long l2 = l;
            zzi zzi3 = zzi2;
            zzfk zzfk2 = this;
            zzg zzg3 = zzfk2.zzjt().zzbo(zzi3.packageName);
            if (zzg3 != null) {
                zzfk2.zzadp.zzgr();
                if (zzfu.zza((String)zzi3.zzafx, (String)zzg3.getGmpAppId(), (String)zzi3.zzagk, (String)zzg3.zzhb())) {
                    zzfk2.zzadp.zzgt().zzjj().zzg("New GMP App Id passed in. Removing cached database data. appId", zzaq.zzby((String)zzg3.zzal()));
                    String string = zzg3.zzal();
                    zzr zzr2 = zzfk2.zzjt();
                    zzr2.zzcl();
                    zzr2.zzaf();
                    Preconditions.checkNotEmpty((String)string);
                    try {
                        SQLiteDatabase sQLiteDatabase = zzr2.getWritableDatabase();
                        String[] stringArray = new String[]{string};
                        int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                        if (n2 > 0) {
                            zzr2.zzgt().zzjo().zze("Deleted application data. app, records", (Object)string, (Object)n2);
                        }
                    }
                    catch (SQLiteException sQLiteException) {
                        zzr2.zzgt().zzjg().zze("Error deleting application data. appId, error", zzaq.zzby((String)string), (Object)sQLiteException);
                    }
                    zzg3 = null;
                }
            }
            if (zzg3 != null) {
                if (zzg3.zzhf() != Integer.MIN_VALUE) {
                    if (zzg3.zzhf() != zzi3.zzagd) {
                        bundle = new Bundle();
                        bundle.putString("_pv", zzg3.zzak());
                        zzae2 = new zzae("_au", new zzab(bundle), "auto", l2);
                        zzfk2.zzc(zzae2, zzi3);
                    }
                } else if (zzg3.zzak() != null && !zzg3.zzak().equals(zzi3.zzts)) {
                    bundle = new Bundle();
                    bundle.putString("_pv", zzg3.zzak());
                    zzae2 = new zzae("_au", new zzab(bundle), "auto", l2);
                    zzfk2.zzc(zzae2, zzi3);
                }
            }
            this.zzg(zzi2);
            zzaa zzaa2 = null;
            if (n == 0) {
                zzaa2 = this.zzjt().zzg(zzi2.packageName, "_f");
            } else if (n == 1) {
                zzaa2 = this.zzjt().zzg(zzi2.packageName, "_v");
            }
            if (zzaa2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzfr zzfr2;
                    zzfr zzfr3 = new zzfr("_fot", l, (Object)l3, "auto");
                    this.zzb(zzfr3, zzi2);
                    if (this.zzadp.zzgv().zzbg(zzi2.zzafx)) {
                        zzi3 = zzi2;
                        zzfk2 = this;
                        zzfk2.zzaf();
                        zzfk2.zzadp.zzkk().zzcg(zzi3.packageName);
                    }
                    l2 = l;
                    zzi3 = zzi2;
                    zzfk2 = this;
                    zzfk2.zzaf();
                    zzfk2.zzlx();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    zzg3.putLong("_uwa", 0L);
                    zzg3.putLong("_pfo", 0L);
                    zzg3.putLong("_sys", 0L);
                    zzg3.putLong("_sysu", 0L);
                    if (zzfk2.zzadp.zzgv().zzbm(zzi3.packageName)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzfk2.zzadp.zzgv().zzbc(zzi3.packageName) && zzi3.zzahc) {
                        zzg3.putLong("_dac", 1L);
                    }
                    if (zzfk2.zzadp.getContext().getPackageManager() == null) {
                        zzfk2.zzadp.zzgt().zzjg().zzg("PackageManager is null, first open report might be inaccurate. appId", zzaq.zzby((String)zzi3.packageName));
                    } else {
                        zzae2 = null;
                        try {
                            zzae2 = Wrappers.packageManager((Context)zzfk2.zzadp.getContext()).getPackageInfo(zzi3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzfk2.zzadp.zzgt().zzjg().zze("Package info is null, first open report might be inaccurate. appId", zzaq.zzby((String)zzi3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzae2 != null && zzae2.firstInstallTime != 0L) {
                            boolean bl = false;
                            if (zzae2.firstInstallTime != zzae2.lastUpdateTime) {
                                zzg3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzfr2 = new zzfr("_fi", l2, (Object)(bl ? 1L : 0L), "auto");
                            zzfk2.zzb(zzfr2, zzi3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = Wrappers.packageManager((Context)zzfk2.zzadp.getContext()).getApplicationInfo(zzi3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzfk2.zzadp.zzgt().zzjg().zze("Application info is null, first open report might be inaccurate. appId", zzaq.zzby((String)zzi3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzi3.packageName;
                    zzr zzr3 = zzfk2.zzjt();
                    Preconditions.checkNotEmpty((String)string);
                    zzr3.zzaf();
                    zzr3.zzcl();
                    long l4 = zzr3.zzn(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzg3.putLong("_pfo", l4);
                    }
                    zzfr2 = new zzae("_f", new zzab((Bundle)zzg3), "auto", l2);
                    zzfk2.zzc((zzae)zzfr2, zzi3);
                } else if (n == 1) {
                    zzfr zzfr4 = new zzfr("_fvt", l, (Object)l3, "auto");
                    this.zzb(zzfr4, zzi2);
                    l2 = l;
                    zzi3 = zzi2;
                    zzfk2 = this;
                    zzfk2.zzaf();
                    zzfk2.zzlx();
                    zzg3 = new Bundle();
                    zzg3.putLong("_c", 1L);
                    zzg3.putLong("_r", 1L);
                    if (zzfk2.zzadp.zzgv().zzbm(zzi3.packageName)) {
                        zzg3.putLong("_et", 1L);
                    }
                    if (zzfk2.zzadp.zzgv().zzbc(zzi3.packageName) && zzi3.zzahc) {
                        zzg3.putLong("_dac", 1L);
                    }
                    bundle = new zzae("_v", new zzab((Bundle)zzg3), "auto", l2);
                    zzfk2.zzc((zzae)bundle, zzi3);
                }
                if (!this.zzadp.zzgv().zze(zzi2.packageName, zzag.zzalm)) {
                    l2 = l;
                    zzi3 = zzi2;
                    zzfk2 = this;
                    zzg3 = new Bundle();
                    zzg3.putLong("_et", 1L);
                    if (zzfk2.zzadp.zzgv().zzbm(zzi3.packageName)) {
                        zzg3.putLong("_fr", 1L);
                    }
                    bundle = new zzae("_e", new zzab((Bundle)zzg3), "auto", l2);
                    zzfk2.zzc((zzae)bundle, zzi3);
                }
            } else if (zzi2.zzagz) {
                l2 = l;
                zzi3 = zzi2;
                zzfk2 = this;
                zzg3 = new Bundle();
                bundle = new zzae("_cd", new zzab((Bundle)zzg3), "auto", l2);
                zzfk2.zzc((zzae)bundle, zzi3);
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    private final zzi zzct(String string) {
        zzg zzg2 = this.zzjt().zzbo(string);
        if (zzg2 == null || TextUtils.isEmpty((CharSequence)zzg2.zzak())) {
            this.zzadp.zzgt().zzjn().zzg("No app data available; dropping", (Object)string);
            return null;
        }
        Boolean bl = this.zzc(zzg2);
        if (bl != null && !bl.booleanValue()) {
            this.zzadp.zzgt().zzjg().zzg("App version does not match; dropping. appId", zzaq.zzby((String)string));
            return null;
        }
        return new zzi(string, zzg2.getGmpAppId(), zzg2.zzak(), zzg2.zzhf(), zzg2.zzhg(), zzg2.zzhh(), zzg2.zzhi(), null, zzg2.isMeasurementEnabled(), false, zzg2.getFirebaseInstanceId(), zzg2.zzhv(), 0L, 0, zzg2.zzhw(), zzg2.zzhx(), false, zzg2.zzhb());
    }

    @WorkerThread
    final void zze(zzm zzm2) {
        zzi zzi2 = this.zzct(zzm2.packageName);
        if (zzi2 != null) {
            this.zzb(zzm2, zzi2);
        }
    }

    @WorkerThread
    final void zzb(zzm zzm2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.packageName);
        Preconditions.checkNotNull((Object)zzm2.origin);
        Preconditions.checkNotNull((Object)zzm2.zzahe);
        Preconditions.checkNotEmpty((String)zzm2.zzahe.name);
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzi2.zzafx) && TextUtils.isEmpty((CharSequence)zzi2.zzagk)) {
            return;
        }
        if (!zzi2.zzagg) {
            this.zzg(zzi2);
            return;
        }
        zzm zzm3 = new zzm(zzm2);
        new zzm(zzm2).active = false;
        this.zzjt().beginTransaction();
        try {
            boolean bl = false;
            zzm zzm4 = this.zzjt().zzj(zzm3.packageName, zzm3.zzahe.name);
            if (zzm4 != null && !zzm4.origin.equals(zzm3.origin)) {
                this.zzadp.zzgt().zzjj().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", (Object)this.zzadp.zzgq().zzbx(zzm3.zzahe.name), (Object)zzm3.origin, (Object)zzm4.origin);
            }
            if (zzm4 != null && zzm4.active) {
                zzm3.origin = zzm4.origin;
                zzm3.creationTimestamp = zzm4.creationTimestamp;
                zzm3.triggerTimeout = zzm4.triggerTimeout;
                zzm3.triggerEventName = zzm4.triggerEventName;
                zzm3.zzahg = zzm4.zzahg;
                zzm3.active = zzm4.active;
                zzm3.zzahe = new zzfr(zzm3.zzahe.name, zzm4.zzahe.zzaux, zzm3.zzahe.getValue(), zzm4.zzahe.origin);
            } else if (TextUtils.isEmpty((CharSequence)zzm3.triggerEventName)) {
                zzm3.zzahe = new zzfr(zzm3.zzahe.name, zzm3.creationTimestamp, zzm3.zzahe.getValue(), zzm3.zzahe.origin);
                zzm3.active = true;
                bl = true;
            }
            if (zzm3.active) {
                zzfr zzfr2 = zzm3.zzahe;
                zzft zzft2 = new zzft(zzm3.packageName, zzm3.origin, zzfr2.name, zzfr2.zzaux, zzfr2.getValue());
                if (this.zzjt().zza(zzft2)) {
                    this.zzadp.zzgt().zzjn().zzd("User property updated immediately", (Object)zzm3.packageName, (Object)this.zzadp.zzgq().zzbx(zzft2.name), zzft2.value);
                } else {
                    this.zzadp.zzgt().zzjg().zzd("(2)Too many active user properties, ignoring", zzaq.zzby((String)zzm3.packageName), (Object)this.zzadp.zzgq().zzbx(zzft2.name), zzft2.value);
                }
                if (bl && zzm3.zzahg != null) {
                    zzae zzae2 = new zzae(zzm3.zzahg, zzm3.creationTimestamp);
                    this.zzd(zzae2, zzi2);
                }
            }
            if (this.zzjt().zza(zzm3)) {
                this.zzadp.zzgt().zzjn().zzd("Conditional property added", (Object)zzm3.packageName, (Object)this.zzadp.zzgq().zzbx(zzm3.zzahe.name), zzm3.zzahe.getValue());
            } else {
                this.zzadp.zzgt().zzjg().zzd("Too many conditional properties, ignoring", zzaq.zzby((String)zzm3.packageName), (Object)this.zzadp.zzgq().zzbx(zzm3.zzahe.name), zzm3.zzahe.getValue());
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    final void zzf(zzm zzm2) {
        zzi zzi2 = this.zzct(zzm2.packageName);
        if (zzi2 != null) {
            this.zzc(zzm2, zzi2);
        }
    }

    @WorkerThread
    final void zzc(zzm zzm2, zzi zzi2) {
        Preconditions.checkNotNull((Object)zzm2);
        Preconditions.checkNotEmpty((String)zzm2.packageName);
        Preconditions.checkNotNull((Object)zzm2.zzahe);
        Preconditions.checkNotEmpty((String)zzm2.zzahe.name);
        this.zzaf();
        this.zzlx();
        if (TextUtils.isEmpty((CharSequence)zzi2.zzafx) && TextUtils.isEmpty((CharSequence)zzi2.zzagk)) {
            return;
        }
        if (!zzi2.zzagg) {
            this.zzg(zzi2);
            return;
        }
        this.zzjt().beginTransaction();
        try {
            this.zzg(zzi2);
            zzm zzm3 = this.zzjt().zzj(zzm2.packageName, zzm2.zzahe.name);
            if (zzm3 != null) {
                this.zzadp.zzgt().zzjn().zze("Removing conditional user property", (Object)zzm2.packageName, (Object)this.zzadp.zzgq().zzbx(zzm2.zzahe.name));
                this.zzjt().zzk(zzm2.packageName, zzm2.zzahe.name);
                if (zzm3.active) {
                    this.zzjt().zzh(zzm2.packageName, zzm2.zzahe.name);
                }
                if (zzm2.zzahh != null) {
                    Bundle bundle = null;
                    if (zzm2.zzahh.zzaig != null) {
                        bundle = zzm2.zzahh.zzaig.zziy();
                    }
                    zzae zzae2 = this.zzadp.zzgr().zza(zzm2.packageName, zzm2.zzahh.name, bundle, zzm3.origin, zzm2.zzahh.zzais, true, false);
                    this.zzd(zzae2, zzi2);
                }
            } else {
                this.zzadp.zzgt().zzjj().zze("Conditional user property doesn't exist", zzaq.zzby((String)zzm2.packageName), (Object)this.zzadp.zzgq().zzbx(zzm2.zzahe.name));
            }
            this.zzjt().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzjt().endTransaction();
        }
    }

    @WorkerThread
    private final zzg zzg(zzi zzi2) {
        this.zzaf();
        this.zzlx();
        Preconditions.checkNotNull((Object)zzi2);
        Preconditions.checkNotEmpty((String)zzi2.packageName);
        zzg zzg2 = this.zzjt().zzbo(zzi2.packageName);
        String string = this.zzadp.zzgu().zzcc(zzi2.packageName);
        boolean bl = false;
        if (zzg2 == null) {
            zzg2 = new zzg(this.zzadp, zzi2.packageName);
            zzg2.zzal(this.zzadp.zzgr().zzmm());
            zzg2.zzao(string);
            bl = true;
        } else if (!string.equals(zzg2.zzhc())) {
            zzg2.zzao(string);
            zzg2.zzal(this.zzadp.zzgr().zzmm());
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzi2.zzafx, (CharSequence)zzg2.getGmpAppId())) {
            zzg2.zzam(zzi2.zzafx);
            bl = true;
        }
        if (!TextUtils.equals((CharSequence)zzi2.zzagk, (CharSequence)zzg2.zzhb())) {
            zzg2.zzan(zzi2.zzagk);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzi2.zzafz) && !zzi2.zzafz.equals(zzg2.getFirebaseInstanceId())) {
            zzg2.zzap(zzi2.zzafz);
            bl = true;
        }
        if (zzi2.zzadt != 0L && zzi2.zzadt != zzg2.zzhh()) {
            zzg2.zzv(zzi2.zzadt);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzi2.zzts) && !zzi2.zzts.equals(zzg2.zzak())) {
            zzg2.setAppVersion(zzi2.zzts);
            bl = true;
        }
        if (zzi2.zzagd != zzg2.zzhf()) {
            zzg2.zzu(zzi2.zzagd);
            bl = true;
        }
        if (zzi2.zzage != null && !zzi2.zzage.equals(zzg2.zzhg())) {
            zzg2.zzaq(zzi2.zzage);
            bl = true;
        }
        if (zzi2.zzagf != zzg2.zzhi()) {
            zzg2.zzw(zzi2.zzagf);
            bl = true;
        }
        if (zzi2.zzagg != zzg2.isMeasurementEnabled()) {
            zzg2.setMeasurementEnabled(zzi2.zzagg);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzi2.zzagy) && !zzi2.zzagy.equals(zzg2.zzht())) {
            zzg2.zzar(zzi2.zzagy);
            bl = true;
        }
        if (zzi2.zzagh != zzg2.zzhv()) {
            zzg2.zzag(zzi2.zzagh);
            bl = true;
        }
        if (zzi2.zzagi != zzg2.zzhw()) {
            zzg2.zze(zzi2.zzagi);
            bl = true;
        }
        if (zzi2.zzagj != zzg2.zzhx()) {
            zzg2.zzf(zzi2.zzagj);
            bl = true;
        }
        if (bl) {
            this.zzjt().zza(zzg2);
        }
        return zzg2;
    }

    final String zzh(zzi zzi2) {
        Future future = this.zzadp.zzgs().zzb((Callable)new zzfo(this, zzi2));
        try {
            return (String)future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzadp.zzgt().zzjg().zze("Failed to get app instance id. appId", zzaq.zzby((String)zzi2.packageName), (Object)exception);
            return null;
        }
    }

    final void zzm(boolean bl) {
        this.zzmb();
    }

    static /* synthetic */ void zza(zzfk zzfk2, zzfp zzfp2) {
        zzfk2.zza(zzfp2);
    }

    static /* synthetic */ zzg zza(zzfk zzfk2, zzi zzi2) {
        return zzfk2.zzg(zzi2);
    }

    final class zza
    implements zzt {
        zzgl zzaut;
        List<Long> zzauu;
        List<zzgi> zzauv;
        private long zzauw;

        private zza() {
        }

        @Override
        public final void zzb(zzgl zzgl2) {
            Preconditions.checkNotNull((Object)((Object)zzgl2));
            this.zzaut = zzgl2;
        }

        @Override
        public final boolean zza(long l, zzgi zzgi2) {
            Preconditions.checkNotNull((Object)((Object)zzgi2));
            if (this.zzauv == null) {
                this.zzauv = new ArrayList<zzgi>();
            }
            if (this.zzauu == null) {
                this.zzauu = new ArrayList<Long>();
            }
            if (this.zzauv.size() > 0 && zza.zza(this.zzauv.get(0)) != zza.zza(zzgi2)) {
                return false;
            }
            long l2 = this.zzauw + (long)zzgi2.zzwe();
            if (l2 >= (long)Math.max(0, (Integer)zzag.zzajo.get())) {
                return false;
            }
            this.zzauw = l2;
            this.zzauv.add(zzgi2);
            this.zzauu.add(l);
            return this.zzauv.size() < Math.max(1, (Integer)zzag.zzajp.get());
        }

        private static long zza(zzgi zzgi2) {
            return zzgi2.zzaxn / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzfl zzfl2) {
            this();
        }
    }
}

