/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzgb;
import com.google.android.gms.internal.measurement.zzgi;
import com.google.android.gms.internal.measurement.zzgj;
import com.google.android.gms.internal.measurement.zzgl;
import com.google.android.gms.internal.measurement.zzgm;
import com.google.android.gms.internal.measurement.zzzi;
import com.google.android.gms.internal.measurement.zzzj;
import com.google.android.gms.internal.measurement.zzzl;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzo;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzz;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzr
extends zzfj {
    private static final String[] zzahl = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzahm = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzahn = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;"};
    private static final String[] zzaho = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzahp = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzahq = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzu zzahr;
    private final zzff zzahs = new zzff(this.zzbx());

    zzr(zzfk zzfk2) {
        super(zzfk2);
        String string = "google_app_measurement.db";
        this.zzahr = new zzu(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzcl();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzcl();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzcl();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzgt().zzjg().zze("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzaf();
        try {
            return this.zzahr.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjj().zzg("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzaa zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            zzaa zzaa2 = new zzaa(string, string2, l, l2, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for event aggregates, expected one. appId", zzaq.zzby((String)string));
            }
            zzaa zzaa3 = zzaa2;
            return zzaa3;
        }
    }

    @WorkerThread
    public final void zza(zzaa zzaa2) {
        Preconditions.checkNotNull((Object)zzaa2);
        this.zzaf();
        this.zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzaa2.zztt);
        contentValues.put("name", zzaa2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzaa2.zzaih));
        contentValues.put("current_bundle_count", Long.valueOf(zzaa2.zzaii));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzaa2.zzaij));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzaa2.zzaik));
        contentValues.put("last_bundled_day", zzaa2.zzail);
        contentValues.put("last_sampled_complex_event_id", zzaa2.zzaim);
        contentValues.put("last_sampling_rate", zzaa2.zzain);
        Long l = null;
        if (zzaa2.zzaio != null && zzaa2.zzaio.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update event aggregates (got -1). appId", zzaq.zzby((String)zzaa2.zztt));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing event aggregates. appId", zzaq.zzby((String)zzaa2.zztt), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzgt().zzjo().zzg("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzd("Error deleting user attribute. appId", zzaq.zzby((String)string), (Object)this.zzgq().zzbx(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzft zzft2) {
        Preconditions.checkNotNull((Object)zzft2);
        this.zzaf();
        this.zzcl();
        if (this.zzi(zzft2.zztt, zzft2.name) == null && (zzfu.zzcv((String)zzft2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzft2.zztt}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzft2.zztt, zzft2.origin}) >= 25L)) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzft2.zztt);
        contentValues.put("origin", zzft2.origin);
        contentValues.put("name", zzft2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzft2.zzaux));
        zzr.zza(contentValues, "value", zzft2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update user property (got -1). appId", zzaq.zzby((String)zzft2.zztt));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing user property. appId", zzaq.zzby((String)zzft2.zztt), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzft zzi(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzft zzft2 = new zzft(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for user property, expected one. appId", zzaq.zzby((String)string));
            }
            zzft zzft3 = zzft2;
            return zzft3;
        }
    }

    @WorkerThread
    public final List<zzft> zzbn(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<zzft> arrayList = new ArrayList<zzft>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzft> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzgt().zzjg().zzg("Read invalid user property value, ignoring it. appId", zzaq.zzby((String)string));
                    continue;
                }
                zzft zzft2 = new zzft(string, string2, (String)object, l, object2);
                arrayList.add(zzft2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzft> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<zzft> arrayList = new ArrayList<zzft>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzft> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgt().zzjg().zzg("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzgt().zzjg().zzd("(2)Read invalid user property value, ignoring it", zzaq.zzby((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzft zzft2 = new zzft(string, string2, (String)object, l, object2);
                arrayList.add(zzft2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzm zzm2) {
        Preconditions.checkNotNull((Object)zzm2);
        this.zzaf();
        this.zzcl();
        if (this.zzi(zzm2.packageName, zzm2.zzahe.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzm2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzm2.packageName);
        contentValues.put("origin", zzm2.origin);
        contentValues.put("name", zzm2.zzahe.name);
        zzr.zza(contentValues, "value", zzm2.zzahe.getValue());
        contentValues.put("active", Boolean.valueOf(zzm2.active));
        contentValues.put("trigger_event_name", zzm2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzm2.triggerTimeout));
        this.zzgr();
        contentValues.put("timed_out_event", zzfu.zza((Parcelable)zzm2.zzahf));
        contentValues.put("creation_timestamp", Long.valueOf(zzm2.creationTimestamp));
        this.zzgr();
        contentValues.put("triggered_event", zzfu.zza((Parcelable)zzm2.zzahg));
        contentValues.put("triggered_timestamp", Long.valueOf(zzm2.zzahe.zzaux));
        contentValues.put("time_to_live", Long.valueOf(zzm2.timeToLive));
        this.zzgr();
        contentValues.put("expired_event", zzfu.zza((Parcelable)zzm2.zzahh));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update conditional user property (got -1)", zzaq.zzby((String)zzm2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing conditional user property", zzaq.zzby((String)zzm2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzm zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzae zzae2 = (zzae)this.zzjr().zza(cursor.getBlob(5), zzae.CREATOR);
            long l2 = cursor.getLong(6);
            zzae zzae3 = (zzae)this.zzjr().zza(cursor.getBlob(7), zzae.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzae zzae4 = (zzae)this.zzjr().zza(cursor.getBlob(10), zzae.CREATOR);
            zzfr zzfr2 = new zzfr(string2, l3, object, string3);
            zzm zzm2 = new zzm(string, string3, zzfr2, l2, bl, string4, zzae2, l, zzae3, l4, zzae4);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zze("Got multiple records for conditional property, expected one", zzaq.zzby((String)string), (Object)this.zzgq().zzbx(string2));
            }
            zzm zzm3 = zzm2;
            return zzm3;
        }
    }

    @WorkerThread
    public final int zzk(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzd("Error deleting conditional property", zzaq.zzby((String)string), (Object)this.zzgq().zzbx(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzm> zzc(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzm> zzb(String string, String[] stringArray) {
        this.zzaf();
        this.zzcl();
        ArrayList<zzm> arrayList = new ArrayList<zzm>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzm> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzgt().zzjg().zzg("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzae zzae2 = (zzae)this.zzjr().zza(cursor.getBlob(7), zzae.CREATOR);
                long l2 = cursor.getLong(8);
                zzae zzae3 = (zzae)this.zzjr().zza(cursor.getBlob(9), zzae.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzae zzae4 = (zzae)this.zzjr().zza(cursor.getBlob(12), zzae.CREATOR);
                zzfr zzfr2 = new zzfr(string3, l3, object2, string2);
                zzm zzm2 = new zzm((String)object, string2, zzfr2, l2, bl, string4, zzae2, l, zzae3, l4, zzae4);
                arrayList.add(zzm2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzg zzbo(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzg zzg2 = new zzg(this.zzang.zzmh(), string);
            zzg2.zzal(cursor.getString(0));
            zzg2.zzam(cursor.getString(1));
            zzg2.zzao(cursor.getString(2));
            zzg2.zzx(cursor.getLong(3));
            zzg2.zzs(cursor.getLong(4));
            zzg2.zzt(cursor.getLong(5));
            zzg2.setAppVersion(cursor.getString(6));
            zzg2.zzaq(cursor.getString(7));
            zzg2.zzv(cursor.getLong(8));
            zzg2.zzw(cursor.getLong(9));
            zzg2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzg2.zzaa(cursor.getLong(11));
            zzg2.zzab(cursor.getLong(12));
            zzg2.zzac(cursor.getLong(13));
            zzg2.zzad(cursor.getLong(14));
            zzg2.zzy(cursor.getLong(15));
            zzg2.zzz(cursor.getLong(16));
            zzg2.zzu(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzg2.zzap(cursor.getString(18));
            zzg2.zzaf(cursor.getLong(19));
            zzg2.zzae(cursor.getLong(20));
            zzg2.zzar(cursor.getString(21));
            zzg2.zzag(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzg2.zze(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzg2.zzf(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzg2.zzan(cursor.getString(25));
            zzg2.zzha();
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for app, expected one. appId", zzaq.zzby((String)string));
            }
            zzg zzg3 = zzg2;
            return zzg3;
        }
    }

    @WorkerThread
    public final void zza(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        this.zzaf();
        this.zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzal());
        contentValues.put("app_instance_id", zzg2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzg2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzg2.zzhc());
        contentValues.put("last_bundle_index", Long.valueOf(zzg2.zzhj()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzg2.zzhd()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzg2.zzhe()));
        contentValues.put("app_version", zzg2.zzak());
        contentValues.put("app_store", zzg2.zzhg());
        contentValues.put("gmp_version", Long.valueOf(zzg2.zzhh()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzg2.zzhi()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzg2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzg2.zzhn()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzg2.zzho()));
        contentValues.put("daily_events_count", Long.valueOf(zzg2.zzhp()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzg2.zzhq()));
        contentValues.put("config_fetched_time", Long.valueOf(zzg2.zzhk()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzg2.zzhl()));
        contentValues.put("app_version_int", Long.valueOf(zzg2.zzhf()));
        contentValues.put("firebase_instance_id", zzg2.getFirebaseInstanceId());
        contentValues.put("daily_error_events_count", Long.valueOf(zzg2.zzhs()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzg2.zzhr()));
        contentValues.put("health_monitor_sample", zzg2.zzht());
        contentValues.put("android_id", Long.valueOf(zzg2.zzhv()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzg2.zzhw()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzg2.zzhx()));
        contentValues.put("admob_app_id", zzg2.zzhb());
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzg2.zzal()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert/update app (got -1). appId", zzaq.zzby((String)zzg2.zzal()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing app. appId", zzaq.zzby((String)zzg2.zzal()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzbp(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzgv().zzb(string2, zzag.zzajv);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error deleting over the limit events. appId", zzaq.zzby((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzs zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        String[] stringArray = new String[]{string};
        zzs zzs2 = new zzs();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzgt().zzjj().zzg("Not updating daily counts, app is not known. appId", zzaq.zzby((String)string));
                zzs zzs3 = zzs2;
                return zzs3;
            }
            if (cursor.getLong(0) == l) {
                zzs2.zzahu = cursor.getLong(1);
                zzs2.zzaht = cursor.getLong(2);
                zzs2.zzahv = cursor.getLong(3);
                zzs2.zzahw = cursor.getLong(4);
                zzs2.zzahx = cursor.getLong(5);
            }
            if (bl) {
                ++zzs2.zzahu;
            }
            if (bl2) {
                ++zzs2.zzaht;
            }
            if (bl3) {
                ++zzs2.zzahv;
            }
            if (bl4) {
                ++zzs2.zzahw;
            }
            if (bl5) {
                ++zzs2.zzahx;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzs2.zzaht));
            contentValues.put("daily_events_count", Long.valueOf(zzs2.zzahu));
            contentValues.put("daily_conversions_count", Long.valueOf(zzs2.zzahv));
            contentValues.put("daily_error_events_count", Long.valueOf(zzs2.zzahw));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzs2.zzahx));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzs zzs4 = zzs2;
            return zzs4;
        }
    }

    @WorkerThread
    public final byte[] zzbq(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzgt().zzjg().zzg("Got multiple records for app config, expected one. appId", zzaq.zzby((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzgl zzgl2, boolean bl) {
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzgl2));
        Preconditions.checkNotEmpty((String)zzgl2.zztt);
        Preconditions.checkNotNull((Object)zzgl2.zzaxy);
        this.zzij();
        long l = this.zzbx().currentTimeMillis();
        if (zzgl2.zzaxy < l - zzo.zzib() || zzgl2.zzaxy > l + zzo.zzib()) {
            this.zzgt().zzjj().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzaq.zzby((String)zzgl2.zztt), (Object)l, (Object)zzgl2.zzaxy);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzgl2.zzwe()];
            zzzj zzzj2 = zzzj.zzk((byte[])byArray2, (int)0, (int)byArray3.length);
            zzgl2.zza(zzzj2);
            zzzj2.zzzh();
            byArray = this.zzjr().zzb(byArray2);
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Data loss. Failed to serialize bundle. appId", zzaq.zzby((String)zzgl2.zztt), (Object)iOException);
            return false;
        }
        this.zzgt().zzjo().zzg("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzgl2.zztt);
        contentValues.put("bundle_end_timestamp", zzgl2.zzaxy);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzgl2.zzayv != null) {
            contentValues.put("retry_count", zzgl2.zzayv);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert bundle (got -1). appId", zzaq.zzby((String)zzgl2.zztt));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing bundle. appId", zzaq.zzby((String)zzgl2.zztt), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzih() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzii() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzgl, Long>> zzb(String string, int n, int n2) {
        this.zzaf();
        this.zzcl();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzgl, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzgl, Long>> arrayList = new ArrayList<Pair<zzgl, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzjr().zza((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to unzip queued bundle. appId", zzaq.zzby((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzzi.zzj((byte[])byArray, (int)0, (int)byArray2.length);
                zzgl zzgl2 = new zzgl();
                try {
                    zzgl2.zza((zzzi)object);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to merge queued bundle. appId", zzaq.zzby((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    zzgl2.zzayv = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzgl, Long>)Pair.create((Object)((Object)zzgl2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzgl, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzij() {
        this.zzaf();
        this.zzcl();
        if (!this.zzip()) {
            return;
        }
        long l = this.zzgu().zzano.get();
        long l2 = this.zzbx().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzag.zzake.get()) {
            this.zzgu().zzano.set(l2);
            zzr zzr2 = this;
            zzr2.zzaf();
            zzr2.zzcl();
            if (zzr2.zzip()) {
                SQLiteDatabase sQLiteDatabase = zzr2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzr2.zzbx().currentTimeMillis()), String.valueOf(zzo.zzib())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzr2.zzgt().zzjo().zzg("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zzc(List<Long> list) {
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzip()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzgt().zzjj().zzca("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzg("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzfx[] zzfxArray) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzfxArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzr zzr2 = this;
            zzr2.zzcl();
            zzr2.zzaf();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzr2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzfxArray;
            int n2 = zzfxArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzfy zzfy2;
                int n3;
                int n4;
                zzfx zzfx2 = object2[n];
                object = zzfx2;
                string2 = string;
                zzr2 = this;
                zzr2.zzcl();
                zzr2.zzaf();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzavt);
                Preconditions.checkNotNull((Object)object.zzavs);
                if (object.zzavr == null) {
                    zzr2.zzgt().zzjj().zzg("Audience with no ID. appId", zzaq.zzby((String)string2));
                    continue;
                }
                int n5 = object.zzavr;
                zzzl[] zzzlArray = object.zzavt;
                int n6 = object.zzavt.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzzlArray[n4].zzavx != null) continue;
                    zzr2.zzgt().zzjj().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzaq.zzby((String)string2), (Object)object.zzavr);
                    continue block3;
                }
                zzzlArray = object.zzavs;
                n6 = object.zzavs.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzzlArray[n4].zzavx != null) continue;
                    zzr2.zzgt().zzjj().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzaq.zzby((String)string2), (Object)object.zzavr);
                    continue block3;
                }
                boolean bl = true;
                zzzl[] zzzlArray2 = object.zzavt;
                n4 = object.zzavt.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzfy2 = zzzlArray2[n3];
                    if (zzr2.zza(string2, n5, zzfy2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzzlArray2 = object.zzavs;
                    n4 = object.zzavs.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzfy2 = zzzlArray2[n3];
                        if (zzr2.zza(string2, n5, (zzgb)((Object)zzfy2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzr zzr3 = zzr2;
                zzr3.zzcl();
                zzr3.zzaf();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzr3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzfx[] zzfxArray2 = zzfxArray;
            n = zzfxArray.length;
            for (int i = 0; i < n; ++i) {
                zzfx zzfx3 = zzfxArray2[i];
                object2.add(zzfx3.zzavr);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzfy zzfy2) {
        byte[] byArray;
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzfy2));
        if (TextUtils.isEmpty((CharSequence)zzfy2.zzavy)) {
            this.zzgt().zzjj().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzaq.zzby((String)string), (Object)n, (Object)String.valueOf(zzfy2.zzavx));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzfy2.zzwe()];
            zzzj zzzj2 = zzzj.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfy2.zza(zzzj2);
            zzzj2.zzzh();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Configuration loss. Failed to serialize event filter. appId", zzaq.zzby((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzfy2.zzavx);
        contentValues.put("event_name", zzfy2.zzavy);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert event filter (got -1). appId", zzaq.zzby((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing event filter. appId", zzaq.zzby((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzgb zzgb2) {
        byte[] byArray;
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzgb2));
        if (TextUtils.isEmpty((CharSequence)zzgb2.zzawn)) {
            this.zzgt().zzjj().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzaq.zzby((String)string), (Object)n, (Object)String.valueOf(zzgb2.zzavx));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzgb2.zzwe()];
            zzzj zzzj2 = zzzj.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgb2.zza(zzzj2);
            zzzj2.zzzh();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Configuration loss. Failed to serialize property filter. appId", zzaq.zzby((String)string), (Object)iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzgb2.zzavx);
        contentValues.put("property_name", zzgb2.zzawn);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert property filter (got -1). appId", zzaq.zzby((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing property filter. appId", zzaq.zzby((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzfy>> zzl(String string, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzfy>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzzi zzzi2 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzfy zzfy2 = new zzfy();
                try {
                    zzfy2.zza(zzzi2);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to merge filter. appId", zzaq.zzby((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzfy> arrayList = (ArrayList<zzfy>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzfy>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzfy2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzgb>> zzm(String string, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzgb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzzi zzzi2 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzgb zzgb2 = new zzgb();
                try {
                    zzgb2.zza(zzzi2);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zze("Failed to merge filter", zzaq.zzby((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzgb> arrayList = (ArrayList<zzgb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzgb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzgb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzcl();
        this.zzaf();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Database error querying filters. appId", zzaq.zzby((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzgv().zzb(string2, zzag.zzakl);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzgm> zzbr(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzzi zzzi2 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray.length);
                zzgm zzgm2 = new zzgm();
                try {
                    zzgm2.zza(zzzi2);
                }
                catch (IOException iOException) {
                    this.zzgt().zzjg().zzd("Failed to merge filter results. appId, audienceId, error", zzaq.zzby((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzgm2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzgt().zzjg().zzca("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzgt().zzjg().zzca("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzgt().zzjg().zzg("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzik() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzn(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzaf();
        this.zzcl();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzgt().zzjg().zze("Failed to insert column (got -1). appId", zzaq.zzby((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzgt().zzjg().zze("Failed to update column (got 0). appId", zzaq.zzby((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zzd("Error inserting column. appId", zzaq.zzby((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzil() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzgl zzgl2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzgl2));
        Preconditions.checkNotEmpty((String)zzgl2.zztt);
        try {
            object = byArray = new byte[zzgl2.zzwe()];
            zzzj zzzj2 = zzzj.zzk((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzgl2.zza(zzzj2);
            zzzj2.zzzh();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Data loss. Failed to serialize event metadata. appId", zzaq.zzby((String)zzgl2.zztt), (Object)iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = (Object)this.zzjr();
        Preconditions.checkNotNull((Object)byArray2);
        object.zzgr().zzaf();
        MessageDigest messageDigest = zzfu.getMessageDigest();
        if (messageDigest == null) {
            object.zzgt().zzjg().zzca("Failed to get MD5");
            l = 0L;
        } else {
            l = zzfu.zzc((byte[])messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzgl2.zztt);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing raw event metadata. appId", zzaq.zzby((String)zzgl2.zztt), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzim() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzin() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzbs(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzah(long l) {
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgt().zzjo().zzca("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzio() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzgi, Long> zza(String string, Long l) {
        this.zzaf();
        this.zzcl();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzgt().zzjo().zzca("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            byte[] byArray2 = byArray;
            zzzi zzzi2 = zzzi.zzj((byte[])byArray, (int)0, (int)byArray2.length);
            zzgi zzgi2 = new zzgi();
            try {
                zzgi2.zza(zzzi2);
            }
            catch (IOException iOException) {
                this.zzgt().zzjg().zzd("Failed to merge main event. appId, eventId", zzaq.zzby((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzgi2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzgi zzgi2) {
        byte[] byArray;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)((Object)zzgi2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        try {
            byte[] byArray2 = byArray = new byte[zzgi2.zzwe()];
            zzzj zzzj2 = zzzj.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgi2.zza(zzzj2);
            zzzj2.zzzh();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzd("Data loss. Failed to serialize event params/data. appId, eventId", zzaq.zzby((String)string), (Object)l, (Object)iOException);
            return false;
        }
        this.zzgt().zzjo().zze("Saving complex main event, appId, data size", (Object)this.zzgq().zzbv(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert complex main event (got -1). appId", zzaq.zzby((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing complex main event. appId", zzaq.zzby((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzz zzz2, long l, boolean bl) {
        Object object;
        zzgj zzgj2;
        String string2;
        this.zzaf();
        this.zzcl();
        Preconditions.checkNotNull((Object)zzz2);
        Preconditions.checkNotEmpty((String)zzz2.zztt);
        zzgi zzgi2 = new zzgi();
        new zzgi().zzaxo = zzz2.zzaif;
        zzgi2.zzaxm = new zzgj[zzz2.zzaig.size()];
        int n = 0;
        for (String string2 : zzz2.zzaig) {
            zzgj2 = new zzgj();
            zzgi2.zzaxm[n++] = zzgj2;
            zzgj2.name = string2;
            Object object2 = zzz2.zzaig.get(string2);
            this.zzjr().zza(zzgj2, object2);
        }
        try {
            byte[] byArray = new byte[zzgi2.zzwe()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzgj2 = zzzj.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzgi2.zza((zzzj)zzgj2);
            zzgj2.zzzh();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zze("Data loss. Failed to serialize event params/data. appId", zzaq.zzby((String)zzz2.zztt), (Object)iOException);
            return false;
        }
        this.zzgt().zzjo().zze("Saving event, name, data size", (Object)this.zzgq().zzbv(zzz2.name), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzz2.zztt);
        string2.put("name", zzz2.name);
        string2.put("timestamp", Long.valueOf(zzz2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzgt().zzjg().zzg("Failed to insert raw event (got -1). appId", zzaq.zzby((String)zzz2.zztt));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzgt().zzjg().zze("Error storing raw event. appId", zzaq.zzby((String)zzz2.zztt), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzip() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzff zza(zzr zzr2) {
        return zzr2.zzahs;
    }

    static /* synthetic */ String[] zziq() {
        return zzahl;
    }

    static /* synthetic */ String[] zzir() {
        return zzahm;
    }

    static /* synthetic */ String[] zzis() {
        return zzahn;
    }

    static /* synthetic */ String[] zzit() {
        return zzahp;
    }

    static /* synthetic */ String[] zziu() {
        return zzaho;
    }

    static /* synthetic */ String[] zziv() {
        return zzahq;
    }
}

