/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbm;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzy;

public final class zzfk
extends zzfn {
    private final AlarmManager zzyt = (AlarmManager)this.getContext().getSystemService("alarm");
    private final zzy zzate;
    private Integer zzyu;

    protected zzfk(zzfo zzfo2) {
        super(zzfo2);
        this.zzate = new zzfl(this, (zzct)zzfo2.zzmh(), zzfo2);
    }

    @Override
    protected final boolean zzgy() {
        this.zzyt.cancel(this.zzeo());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzlr();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzlr() {
        JobScheduler jobScheduler = (JobScheduler)this.getContext().getSystemService("jobscheduler");
        int n = this.getJobId();
        this.zzgt().zzjo().zzg("Cancelling job. JobID", (Object)n);
        jobScheduler.cancel(n);
    }

    public final void zzh(long l) {
        this.zzcl();
        zzn zzn2 = this.zzgw();
        Context context = this.getContext();
        if (!zzbm.zza((Context)context)) {
            this.zzgt().zzjn().zzby("Receiver not registered/enabled");
        }
        if (!zzfy.zza((Context)context, (boolean)false)) {
            this.zzgt().zzjn().zzby("Service not registered/enabled");
        }
        this.cancel();
        long l2 = this.zzbx().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzai.zzajr.get()) && !this.zzate.zzej()) {
            this.zzgt().zzjo().zzby("Scheduling upload with DelayedRunnable");
            this.zzate.zzh(l);
        }
        zzn2 = this.zzgw();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzgt().zzjo().zzby("Scheduling upload with JobScheduler");
            long l3 = l;
            zzfk zzfk2 = this;
            Context context2 = zzfk2.getContext();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzfk2.getJobId();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzfk2.zzgt().zzjo().zzg("Scheduling job. JobID", (Object)n);
            zzdi.zza((Context)context2, (JobInfo)jobInfo, (String)"com.google.android.gms", (String)"UploadAlarm");
            return;
        }
        this.zzgt().zzjo().zzby("Scheduling upload with AlarmManager");
        this.zzyt.setInexactRepeating(2, l2, Math.max((Long)zzai.zzajm.get(), l), this.zzeo());
    }

    private final int getJobId() {
        if (this.zzyu == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzyu = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzyu;
    }

    public final void cancel() {
        this.zzcl();
        this.zzyt.cancel(this.zzeo());
        this.zzate.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzlr();
        }
    }

    private final PendingIntent zzeo() {
        Context context = this.getContext();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

