/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public final class zzaw
extends zzfm {
    private final SSLSocketFactory zzamo = Build.VERSION.SDK_INT < 19 ? new zzfy() : null;

    public zzaw(zzfn zzfn2) {
        super(zzfn2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    public final boolean zzfb() {
        this.zzcl();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {}
        return networkInfo != null && networkInfo.isConnected();
    }

    @WorkerThread
    private static byte[] zzb(HttpURLConnection httpURLConnection) throws IOException {
        try (InputStream inputStream = null;){
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
    }

    @VisibleForTesting
    @WorkerThread
    protected final HttpURLConnection zzb(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain HTTP connection");
        }
        if (this.zzamo != null && uRLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(this.zzamo);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setReadTimeout(61000);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    static /* synthetic */ byte[] zza(zzaw zzaw2, HttpURLConnection httpURLConnection) throws IOException {
        return zzaw.zzb(httpURLConnection);
    }
}

