/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfs;
import com.google.android.gms.internal.measurement.zzfu;
import com.google.android.gms.internal.measurement.zzfv;
import com.google.android.gms.internal.measurement.zzfw;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzfy;
import com.google.android.gms.internal.measurement.zzfz;
import com.google.android.gms.internal.measurement.zzya;
import com.google.android.gms.internal.measurement.zzyc;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzn;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class zzft
extends zzfm {
    zzft(zzfn zzfn2) {
        super(zzfn2);
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    final void zza(zzfz zzfz2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzfz2.zzamn = null;
        zzfz2.zzaxg = null;
        zzfz2.zzaup = null;
        if (object instanceof String) {
            zzfz2.zzamn = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzfz2.zzaxg = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzfz2.zzaup = (Double)object;
            return;
        }
        this.zzgt().zzjg().zzg("Ignoring invalid (type) user attribute value", object);
    }

    final void zza(zzfu zzfu2, Object object) {
        Preconditions.checkNotNull((Object)object);
        zzfu2.zzamn = null;
        zzfu2.zzaxg = null;
        zzfu2.zzaup = null;
        if (object instanceof String) {
            zzfu2.zzamn = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzfu2.zzaxg = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzfu2.zzaup = (Double)object;
            return;
        }
        this.zzgt().zzjg().zzg("Ignoring invalid (type) event param value", object);
    }

    final byte[] zza(zzfv zzfv2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzfv2.zzvx()];
            zzya zzya2 = zzya.zzk((byte[])byArray, (int)0, (int)byArray2.length);
            zzfv2.zza(zzya2);
            zzya2.zzza();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Data loss. Failed to serialize batch", (Object)iOException);
            return null;
        }
    }

    static zzfu zza(com.google.android.gms.internal.measurement.zzft zzft2, String string) {
        zzfu[] zzfuArray = zzft2.zzaxc;
        int n = zzft2.zzaxc.length;
        for (int i = 0; i < n; ++i) {
            zzfu zzfu2 = zzfuArray[i];
            if (!zzfu2.name.equals(string)) continue;
            return zzfu2;
        }
        return null;
    }

    static Object zzb(com.google.android.gms.internal.measurement.zzft zzft2, String string) {
        zzfu zzfu2 = zzft.zza(zzft2, string);
        if (zzfu2 != null) {
            if (zzfu2.zzamn != null) {
                return zzfu2.zzamn;
            }
            if (zzfu2.zzaxg != null) {
                return zzfu2.zzaxg;
            }
            if (zzfu2.zzaup != null) {
                return zzfu2.zzaup;
            }
        }
        return null;
    }

    static zzfu[] zza(zzfu[] zzfuArray, String string, Object object) {
        zzfu[] zzfuArray2 = zzfuArray;
        int n = zzfuArray.length;
        for (int i = 0; i < n; ++i) {
            zzfu zzfu2 = zzfuArray2[i];
            if (!string.equals(zzfu2.name)) continue;
            zzfu2.zzaxg = null;
            zzfu2.zzamn = null;
            zzfu2.zzaup = null;
            if (object instanceof Long) {
                zzfu2.zzaxg = (Long)object;
            } else if (object instanceof String) {
                zzfu2.zzamn = (String)object;
            } else if (object instanceof Double) {
                zzfu2.zzaup = (Double)object;
            }
            return zzfuArray;
        }
        zzfuArray2 = new zzfu[zzfuArray.length + 1];
        System.arraycopy(zzfuArray, 0, zzfuArray2, 0, zzfuArray.length);
        zzfu zzfu3 = new zzfu();
        new zzfu().name = string;
        if (object instanceof Long) {
            zzfu3.zzaxg = (Long)object;
        } else if (object instanceof String) {
            zzfu3.zzamn = (String)object;
        } else if (object instanceof Double) {
            zzfu3.zzaup = (Double)object;
        }
        zzfuArray2[zzfuArray.length] = zzfu3;
        return zzfuArray2;
    }

    final String zzb(zzfv zzfv2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzfv2.zzaxh != null) {
            zzfw[] zzfwArray = zzfv2.zzaxh;
            int n = zzfv2.zzaxh.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2;
                int n3;
                Object object2;
                zzfw zzfw2 = zzfwArray[i];
                if (zzfw2 == null) continue;
                zzfw zzfw3 = zzfw2;
                StringBuilder stringBuilder2 = stringBuilder;
                zzft zzft2 = this;
                if (zzfw3 == null) continue;
                zzft.zza(stringBuilder2, 1);
                stringBuilder2.append("bundle {\n");
                zzft.zza(stringBuilder2, 1, "protocol_version", zzfw3.zzaxj);
                zzft.zza(stringBuilder2, 1, "platform", zzfw3.zzaxr);
                zzft.zza(stringBuilder2, 1, "gmp_version", zzfw3.zzaxv);
                zzft.zza(stringBuilder2, 1, "uploading_gmp_version", zzfw3.zzaxw);
                zzft.zza(stringBuilder2, 1, "config_version", zzfw3.zzayh);
                zzft.zza(stringBuilder2, 1, "gmp_app_id", zzfw3.zzafi);
                zzft.zza(stringBuilder2, 1, "admob_app_id", zzfw3.zzawr);
                zzft.zza(stringBuilder2, 1, "app_id", zzfw3.zztt);
                zzft.zza(stringBuilder2, 1, "app_version", zzfw3.zzts);
                zzft.zza(stringBuilder2, 1, "app_version_major", zzfw3.zzayd);
                zzft.zza(stringBuilder2, 1, "firebase_instance_id", zzfw3.zzafk);
                zzft.zza(stringBuilder2, 1, "dev_cert_hash", zzfw3.zzaxz);
                zzft.zza(stringBuilder2, 1, "app_store", zzfw3.zzafp);
                zzft.zza(stringBuilder2, 1, "upload_timestamp_millis", zzfw3.zzaxm);
                zzft.zza(stringBuilder2, 1, "start_timestamp_millis", zzfw3.zzaxn);
                zzft.zza(stringBuilder2, 1, "end_timestamp_millis", zzfw3.zzaxo);
                zzft.zza(stringBuilder2, 1, "previous_bundle_start_timestamp_millis", zzfw3.zzaxp);
                zzft.zza(stringBuilder2, 1, "previous_bundle_end_timestamp_millis", zzfw3.zzaxq);
                zzft.zza(stringBuilder2, 1, "app_instance_id", zzfw3.zzafh);
                zzft.zza(stringBuilder2, 1, "resettable_device_id", zzfw3.zzaxx);
                zzft.zza(stringBuilder2, 1, "device_id", zzfw3.zzayg);
                zzft.zza(stringBuilder2, 1, "ds_id", zzfw3.zzayj);
                zzft.zza(stringBuilder2, 1, "limited_ad_tracking", zzfw3.zzaxy);
                zzft.zza(stringBuilder2, 1, "os_version", zzfw3.zzaxs);
                zzft.zza(stringBuilder2, 1, "device_model", zzfw3.zzaxt);
                zzft.zza(stringBuilder2, 1, "user_default_language", zzfw3.zzahr);
                zzft.zza(stringBuilder2, 1, "time_zone_offset_minutes", zzfw3.zzaxu);
                zzft.zza(stringBuilder2, 1, "bundle_sequential_index", zzfw3.zzaya);
                zzft.zza(stringBuilder2, 1, "service_upload", zzfw3.zzayb);
                zzft.zza(stringBuilder2, 1, "health_monitor", zzfw3.zzagm);
                if (zzfw3.zzayi != null && zzfw3.zzayi != 0L) {
                    zzft.zza(stringBuilder2, 1, "android_id", zzfw3.zzayi);
                }
                if (zzfw3.zzayl != null) {
                    zzft.zza(stringBuilder2, 1, "retry_counter", zzfw3.zzayl);
                }
                zzyc[] zzycArray = zzfw3.zzaxl;
                StringBuilder stringBuilder3 = stringBuilder2;
                zzft zzft3 = zzft2;
                if (zzycArray != null) {
                    object2 = zzycArray;
                    n3 = zzycArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzfz zzfz2 = object2[n2];
                        if (zzfz2 == null) continue;
                        zzft.zza(stringBuilder3, 2);
                        stringBuilder3.append("user_property {\n");
                        zzft.zza(stringBuilder3, 2, "set_timestamp_millis", zzfz2.zzayw);
                        zzft.zza(stringBuilder3, 2, "name", zzft3.zzgq().zzbv(zzfz2.name));
                        zzft.zza(stringBuilder3, 2, "string_value", zzfz2.zzamn);
                        zzft.zza(stringBuilder3, 2, "int_value", zzfz2.zzaxg);
                        zzft.zza(stringBuilder3, 2, "double_value", zzfz2.zzaup);
                        zzft.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                object2 = zzfw3.zztt;
                zzycArray = zzfw3.zzayc;
                stringBuilder3 = stringBuilder2;
                zzft3 = zzft2;
                if (zzycArray != null) {
                    zzyc[] zzycArray2 = zzycArray;
                    n2 = zzycArray.length;
                    for (int j = 0; j < n2; ++j) {
                        object = zzycArray2[j];
                        if (object == null) continue;
                        zzft.zza(stringBuilder3, 2);
                        stringBuilder3.append("audience_membership {\n");
                        zzft.zza(stringBuilder3, 2, "audience_id", object.zzavg);
                        zzft.zza(stringBuilder3, 2, "new_audience", object.zzawx);
                        zzft3.zza(stringBuilder3, 2, "current_data", object.zzawv, (String)object2);
                        zzft3.zza(stringBuilder3, 2, "previous_data", object.zzaww, (String)object2);
                        zzft.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzycArray = zzfw3.zzaxk;
                stringBuilder3 = stringBuilder2;
                zzft3 = zzft2;
                if (zzycArray != null) {
                    object2 = zzycArray;
                    n3 = zzycArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        zzfz zzfz3 = object2[n2];
                        if (zzfz3 == null) continue;
                        zzft.zza(stringBuilder3, 2);
                        stringBuilder3.append("event {\n");
                        zzft.zza(stringBuilder3, 2, "name", zzft3.zzgq().zzbt(((com.google.android.gms.internal.measurement.zzft)((Object)zzfz3)).name));
                        zzft.zza(stringBuilder3, 2, "timestamp_millis", ((com.google.android.gms.internal.measurement.zzft)((Object)zzfz3)).zzaxd);
                        zzft.zza(stringBuilder3, 2, "previous_timestamp_millis", ((com.google.android.gms.internal.measurement.zzft)((Object)zzfz3)).zzaxe);
                        zzft.zza(stringBuilder3, 2, "count", ((com.google.android.gms.internal.measurement.zzft)((Object)zzfz3)).count);
                        zzfu[] zzfuArray = ((com.google.android.gms.internal.measurement.zzft)((Object)zzfz3)).zzaxc;
                        StringBuilder stringBuilder4 = stringBuilder3;
                        object = zzft3;
                        if (zzfuArray != null) {
                            zzfu[] zzfuArray2 = zzfuArray;
                            int n4 = zzfuArray.length;
                            for (int j = 0; j < n4; ++j) {
                                zzfu zzfu2 = zzfuArray2[j];
                                if (zzfu2 == null) continue;
                                zzft.zza(stringBuilder4, 3);
                                stringBuilder4.append("param {\n");
                                zzft.zza(stringBuilder4, 3, "name", object.zzgq().zzbu(zzfu2.name));
                                zzft.zza(stringBuilder4, 3, "string_value", zzfu2.zzamn);
                                zzft.zza(stringBuilder4, 3, "int_value", zzfu2.zzaxg);
                                zzft.zza(stringBuilder4, 3, "double_value", zzfu2.zzaup);
                                zzft.zza(stringBuilder4, 3);
                                stringBuilder4.append("}\n");
                            }
                        }
                        zzft.zza(stringBuilder3, 2);
                        stringBuilder3.append("}\n");
                    }
                }
                zzft.zza(stringBuilder2, 1);
                stringBuilder2.append("}\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    final String zza(zzfj zzfj2) {
        if (zzfj2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzft.zza(stringBuilder, 0, "filter_id", zzfj2.zzavm);
        zzft.zza(stringBuilder, 0, "event_name", this.zzgq().zzbt(zzfj2.zzavn));
        this.zza(stringBuilder, 1, "event_count_filter", zzfj2.zzavq);
        stringBuilder.append("  filters {\n");
        zzfk[] zzfkArray = zzfj2.zzavo;
        int n = zzfj2.zzavo.length;
        for (int i = 0; i < n; ++i) {
            zzfk zzfk2 = zzfkArray[i];
            this.zza(stringBuilder, 2, zzfk2);
        }
        zzft.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    final String zza(com.google.android.gms.internal.measurement.zzfm zzfm2) {
        if (zzfm2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzft.zza(stringBuilder, 0, "filter_id", zzfm2.zzavm);
        zzft.zza(stringBuilder, 0, "property_name", this.zzgq().zzbv(zzfm2.zzawc));
        this.zza(stringBuilder, 1, zzfm2.zzawd);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzfx zzfx2, String string2) {
        Object object;
        int n2;
        int n3;
        Object[] objectArray;
        int n4;
        if (zzfx2 == null) {
            return;
        }
        zzft.zza(stringBuilder, 3);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzfx2.zzayq != null) {
            zzft.zza(stringBuilder, 4);
            stringBuilder.append("results: ");
            n4 = 0;
            objectArray = zzfx2.zzayq;
            n3 = zzfx2.zzayq.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (zzfx2.zzayp != null) {
            zzft.zza(stringBuilder, 4);
            stringBuilder.append("status: ");
            n4 = 0;
            objectArray = zzfx2.zzayp;
            n3 = zzfx2.zzayp.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(object);
            }
            stringBuilder.append('\n');
        }
        if (this.zzgv().zzbb(string2)) {
            if (zzfx2.zzayr != null) {
                zzft.zza(stringBuilder, 4);
                stringBuilder.append("dynamic_filter_timestamps: {");
                n4 = 0;
                objectArray = (Object[])zzfx2.zzayr;
                n3 = zzfx2.zzayr.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    if (n4++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((zzfs)((Object)object)).zzawz).append(":").append(((zzfs)((Object)object)).zzaxa);
                }
                stringBuilder.append("}\n");
            }
            if (zzfx2.zzays != null) {
                zzft.zza(stringBuilder, 4);
                stringBuilder.append("sequence_filter_timestamps: {");
                n4 = 0;
                objectArray = (Object[])zzfx2.zzays;
                n3 = zzfx2.zzays.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray[n2];
                    if (n4++ != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(((zzfy)((Object)object)).zzawz).append(": [");
                    int n5 = 0;
                    long[] lArray = ((zzfy)((Object)((Object)object))).zzayu;
                    int n6 = ((zzfy)((Object)((Object)object))).zzayu.length;
                    for (int i = 0; i < n6; ++i) {
                        long l = lArray[i];
                        if (n5++ != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(l);
                    }
                    stringBuilder.append("]");
                }
                stringBuilder.append("}\n");
            }
        }
        zzft.zza(stringBuilder, 3);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, String string, zzfl zzfl2) {
        if (zzfl2 == null) {
            return;
        }
        zzft.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzfl2.zzavw != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzfl2.zzavw) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzft.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzft.zza(stringBuilder, n, "match_as_float", zzfl2.zzavx);
        zzft.zza(stringBuilder, n, "comparison_value", zzfl2.zzavy);
        zzft.zza(stringBuilder, n, "min_comparison_value", zzfl2.zzavz);
        zzft.zza(stringBuilder, n, "max_comparison_value", zzfl2.zzawa);
        zzft.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private final void zza(StringBuilder stringBuilder, int n, zzfk zzfk2) {
        if (zzfk2 == null) {
            return;
        }
        zzft.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzft.zza(stringBuilder, n, "complement", zzfk2.zzavu);
        zzft.zza(stringBuilder, n, "param_name", this.zzgq().zzbu(zzfk2.zzavv));
        com.google.android.gms.internal.measurement.zzfn zzfn2 = zzfk2.zzavs;
        String string = "string_filter";
        int n2 = n + 1;
        StringBuilder stringBuilder2 = stringBuilder;
        if (zzfn2 != null) {
            String[] stringArray;
            zzft.zza(stringBuilder2, n2);
            stringBuilder2.append(string);
            stringBuilder2.append(" {\n");
            if (zzfn2.zzawe != null) {
                stringArray = "UNKNOWN_MATCH_TYPE";
                switch (zzfn2.zzawe) {
                    case 1: {
                        stringArray = "REGEXP";
                        break;
                    }
                    case 2: {
                        stringArray = "BEGINS_WITH";
                        break;
                    }
                    case 3: {
                        stringArray = "ENDS_WITH";
                        break;
                    }
                    case 4: {
                        stringArray = "PARTIAL";
                        break;
                    }
                    case 5: {
                        stringArray = "EXACT";
                        break;
                    }
                    case 6: {
                        stringArray = "IN_LIST";
                    }
                }
                zzft.zza(stringBuilder2, n2, "match_type", stringArray);
            }
            zzft.zza(stringBuilder2, n2, "expression", zzfn2.zzawf);
            zzft.zza(stringBuilder2, n2, "case_sensitive", zzfn2.zzawg);
            if (zzfn2.zzawh.length > 0) {
                zzft.zza(stringBuilder2, n2 + 1);
                stringBuilder2.append("expression_list {\n");
                stringArray = zzfn2.zzawh;
                int n3 = zzfn2.zzawh.length;
                for (int i = 0; i < n3; ++i) {
                    String string2 = stringArray[i];
                    zzft.zza(stringBuilder2, n2 + 2);
                    stringBuilder2.append(string2);
                    stringBuilder2.append("\n");
                }
                stringBuilder2.append("}\n");
            }
            zzft.zza(stringBuilder2, n2);
            stringBuilder2.append("}\n");
        }
        this.zza(stringBuilder, n + 1, "number_filter", zzfk2.zzavt);
        zzft.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzft.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    final <T extends Parcelable> T zza(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (SafeParcelReader.ParseException parseException) {
            this.zzgt().zzjg().zzby("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    @WorkerThread
    final boolean zze(zzag zzag2, zzk zzk2) {
        Preconditions.checkNotNull((Object)zzag2);
        Preconditions.checkNotNull((Object)zzk2);
        if (TextUtils.isEmpty((CharSequence)zzk2.zzafi) && TextUtils.isEmpty((CharSequence)zzk2.zzafv)) {
            zzn zzn2 = this.zzgw();
            return false;
        }
        return true;
    }

    static boolean zzcs(String string) {
        return string != null && string.matches("([+-])?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    final boolean zzb(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zzbx().currentTimeMillis() - l) > l2;
    }

    final byte[] zza(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Failed to ungzip content", (Object)iOException);
            throw iOException;
        }
    }

    final byte[] zzb(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzgt().zzjg().zzg("Failed to gzip content", (Object)iOException);
            throw iOException;
        }
    }

    @Nullable
    final int[] zzmi() {
        Map map = zzai.zzm((Context)this.zzamx.getContext());
        if (map == null || map.size() == 0) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = (Integer)zzai.zzakg.get();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).startsWith("measurement.id.")) continue;
            try {
                int n2 = Integer.parseInt((String)entry.getValue());
                if (n2 == 0) continue;
                arrayList.add(n2);
                if (arrayList.size() < n) continue;
                this.zzgt().zzjj().zzg("Too many experiment IDs. Number of IDs", (Object)arrayList.size());
                break;
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgt().zzjj().zzg("Experiment ID NumberFormatException", (Object)numberFormatException);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Object object = new int[arrayList.size()];
        int n3 = 0;
        ArrayList<Integer> arrayList2 = arrayList;
        int n4 = arrayList2.size();
        for (int i = 0; i < n4; ++i) {
            Object e = arrayList2.get(i);
            Integer n5 = (Integer)e;
            object[n3++] = n5;
        }
        return object;
    }
}

