/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.playintegrity.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.play.core.integrity.IntegrityManager;
import com.google.android.play.core.integrity.IntegrityManagerFactory;
import com.google.android.play.core.integrity.IntegrityTokenRequest;
import com.google.android.play.core.integrity.IntegrityTokenResponse;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckProvider;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.internal.AppCheckTokenResponse;
import com.google.firebase.appcheck.internal.DefaultAppCheckToken;
import com.google.firebase.appcheck.internal.NetworkClient;
import com.google.firebase.appcheck.internal.RetryManager;
import com.google.firebase.appcheck.playintegrity.internal.ExchangePlayIntegrityTokenRequest;
import com.google.firebase.appcheck.playintegrity.internal.GeneratePlayIntegrityChallengeRequest;
import com.google.firebase.appcheck.playintegrity.internal.GeneratePlayIntegrityChallengeResponse;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PlayIntegrityAppCheckProvider
implements AppCheckProvider {
    private static final String UTF_8 = "UTF-8";
    private final String projectNumber;
    private final IntegrityManager integrityManager;
    private final NetworkClient networkClient;
    private final ExecutorService backgroundExecutor;
    private final RetryManager retryManager;

    public PlayIntegrityAppCheckProvider(@NonNull FirebaseApp firebaseApp) {
        this(firebaseApp.getOptions().getGcmSenderId(), IntegrityManagerFactory.create((Context)firebaseApp.getApplicationContext()), new NetworkClient(firebaseApp), Executors.newCachedThreadPool(), new RetryManager());
    }

    @VisibleForTesting
    PlayIntegrityAppCheckProvider(@NonNull String projectNumber, @NonNull IntegrityManager integrityManager, @NonNull NetworkClient networkClient, @NonNull ExecutorService backgroundExecutor, @NonNull RetryManager retryManager) {
        this.projectNumber = projectNumber;
        this.integrityManager = integrityManager;
        this.networkClient = networkClient;
        this.backgroundExecutor = backgroundExecutor;
        this.retryManager = retryManager;
    }

    @NonNull
    public Task<AppCheckToken> getToken() {
        return this.getPlayIntegrityAttestation().onSuccessTask(integrityTokenResponse -> {
            ExchangePlayIntegrityTokenRequest request = new ExchangePlayIntegrityTokenRequest(integrityTokenResponse.token());
            return Tasks.call((Executor)this.backgroundExecutor, () -> this.networkClient.exchangeAttestationForAppCheckToken(request.toJsonString().getBytes(UTF_8), 3, this.retryManager));
        }).onSuccessTask(appCheckTokenResponse -> Tasks.forResult((Object)DefaultAppCheckToken.constructFromAppCheckTokenResponse((AppCheckTokenResponse)appCheckTokenResponse)));
    }

    @NonNull
    private Task<IntegrityTokenResponse> getPlayIntegrityAttestation() {
        GeneratePlayIntegrityChallengeRequest generateChallengeRequest = new GeneratePlayIntegrityChallengeRequest();
        Task generateChallengeTask = Tasks.call((Executor)this.backgroundExecutor, () -> GeneratePlayIntegrityChallengeResponse.fromJsonString(this.networkClient.generatePlayIntegrityChallenge(generateChallengeRequest.toJsonString().getBytes(UTF_8), this.retryManager)));
        return generateChallengeTask.onSuccessTask(generatePlayIntegrityChallengeResponse -> this.integrityManager.requestIntegrityToken(IntegrityTokenRequest.builder().setCloudProjectNumber(Long.parseLong(this.projectNumber)).setNonce(generatePlayIntegrityChallengeResponse.getChallenge()).build()));
    }
}

