/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.internal.DefaultFirebaseAppCheck;
import com.google.firebase.appcheck.internal.util.Logger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DefaultTokenRefresher {
    private static final long UNSET_DELAY = -1L;
    @VisibleForTesting
    static final long INITIAL_DELAY_SECONDS = 30L;
    @VisibleForTesting
    static final long MAX_DELAY_SECONDS = 960L;
    private final DefaultFirebaseAppCheck firebaseAppCheck;
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile ScheduledFuture<?> refreshFuture;
    private volatile long delayAfterFailureSeconds;

    DefaultTokenRefresher(@NonNull DefaultFirebaseAppCheck firebaseAppCheck) {
        this((DefaultFirebaseAppCheck)Preconditions.checkNotNull((Object)firebaseAppCheck), Executors.newScheduledThreadPool(1));
    }

    @VisibleForTesting
    DefaultTokenRefresher(DefaultFirebaseAppCheck firebaseAppCheck, ScheduledExecutorService scheduledExecutorService) {
        this.firebaseAppCheck = firebaseAppCheck;
        this.scheduledExecutorService = scheduledExecutorService;
        this.delayAfterFailureSeconds = -1L;
    }

    public void scheduleRefresh(long timeToRefreshMillis) {
        this.cancel();
        this.delayAfterFailureSeconds = -1L;
        this.refreshFuture = this.scheduledExecutorService.schedule(this::onRefresh, Math.max(0L, timeToRefreshMillis), TimeUnit.MILLISECONDS);
    }

    private void scheduleRefreshAfterFailure() {
        this.cancel();
        this.delayAfterFailureSeconds = this.getNextRefreshMillis();
        this.refreshFuture = this.scheduledExecutorService.schedule(this::onRefresh, this.delayAfterFailureSeconds, TimeUnit.SECONDS);
    }

    private long getNextRefreshMillis() {
        if (this.delayAfterFailureSeconds == -1L) {
            return 30L;
        }
        if (this.delayAfterFailureSeconds * 2L < 960L) {
            return this.delayAfterFailureSeconds * 2L;
        }
        return 960L;
    }

    private void onRefresh() {
        Task<AppCheckTokenResult> task = this.firebaseAppCheck.fetchTokenFromProvider();
        task.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AppCheckTokenResult>(){

            public void onComplete(@NonNull Task<AppCheckTokenResult> task) {
                if (task.isSuccessful()) {
                    AppCheckTokenResult tokenResult = (AppCheckTokenResult)task.getResult();
                    if (tokenResult.getError() != null) {
                        DefaultTokenRefresher.this.scheduleRefreshAfterFailure();
                    }
                } else {
                    Logger.getLogger().e("Unexpected failure while fetching token.");
                }
            }
        });
    }

    public void cancel() {
        if (this.refreshFuture != null && !this.refreshFuture.isDone()) {
            this.refreshFuture.cancel(false);
        }
    }
}

